/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.datagen.providers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.fabric.datagen.ModuleType;
import net.creeperhost.polylib.fabric.datagen.PolyDataGen;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_304;
import net.minecraft.class_7403;

public class PolyLanguageProvider
extends FabricLanguageProvider {
    ModuleType moduleType;
    Map<String, String> values = new HashMap<String, String>();

    public PolyLanguageProvider(FabricDataGenerator dataGenerator, ModuleType moduleType) {
        super(dataGenerator, "en_us");
        this.moduleType = moduleType;
        PolyLib.LOGGER.info("PolyLanguageProvider created for " + dataGenerator.getModId() + " " + moduleType.name());
    }

    public void add(String key, String translation, ModuleType moduleType) {
        if (this.moduleType == moduleType) {
            PolyLib.LOGGER.info("Adding " + key + " for " + moduleType.name());
            this.values.put(key, translation);
        }
    }

    public void add(class_1792 item, String translation, ModuleType moduleType) {
        this.add(item.method_7876(), translation, moduleType);
    }

    public void add(class_2248 block, String translation, ModuleType moduleType) {
        this.add(block.method_9539(), translation, moduleType);
    }

    public void add(class_1761 creativeModeTab, String translation, ModuleType moduleType) {
        this.add(creativeModeTab.method_7737().getString(), translation, moduleType);
    }

    public void add(class_304 keyMapping, String translation, ModuleType moduleType) {
        this.add(keyMapping.method_1431(), translation, moduleType);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.values.forEach((s, s2) -> {
            PolyLib.LOGGER.info("Running data gen for key " + s + " " + this.dataGenerator.method_10313());
            translationBuilder.add(s, s2);
        });
    }

    public Path appendPath(ModuleType moduleType) {
        return PolyDataGen.getPathFromModuleType(moduleType);
    }

    public void method_10319(class_7403 writer) throws IOException {
        if (this.values.isEmpty()) {
            return;
        }
        this.dataGenerator.field_11274 = this.appendPath(this.moduleType);
        super.method_10319(writer);
    }
}

