/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.fabric.datagen.providers;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.fabric.datagen.ModuleType;
import net.creeperhost.polylib.fabric.datagen.PolyDataGen;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_7403;
import org.jetbrains.annotations.NotNull;

public class PolyModelProvider
extends FabricModelProvider {
    private final ModuleType moduleType;
    private Map<class_1792, class_4942> itemValues = new HashMap<class_1792, class_4942>();
    private Map<class_2248, class_4925> blockValues = new HashMap<class_2248, class_4925>();

    public PolyModelProvider(FabricDataGenerator dataGenerator, ModuleType moduleType) {
        super(dataGenerator);
        this.moduleType = moduleType;
        this.updatePaths();
        PolyLib.LOGGER.info("PolyModelProvider created for " + dataGenerator.getModId() + " " + moduleType.name());
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        this.blockValues.forEach((block, blockStateGenerator) -> {
            PolyLib.LOGGER.info(block.method_9539() + " " + this.dataGenerator.method_10313());
            blockStateModelGenerator.method_25641(block);
        });
    }

    public void addBlockModel(class_2248 block, class_4925 blockStateGenerator, ModuleType moduleType) {
        if (this.moduleType == moduleType) {
            this.blockValues.put(block, blockStateGenerator);
        }
    }

    public void addSimpleBlockModel(class_2248 block, class_2960 textureLocation, ModuleType moduleType) {
        class_4925 multiVariantGenerator = class_4910.method_25644((class_2248)block, (class_2960)textureLocation);
        this.addBlockModel(block, multiVariantGenerator, moduleType);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        this.itemValues.forEach((item, modelTemplate) -> itemModelGenerator.method_25733(item, class_4943.field_22938));
    }

    public void addItemModel(class_1792 item, class_4942 modelTemplate, ModuleType moduleType) {
        if (this.moduleType == moduleType) {
            PolyLib.LOGGER.info("Adding item model for " + item.method_7876() + " " + this.dataGenerator.method_10313());
            this.itemValues.put(item, modelTemplate);
        }
    }

    public void addSimpleItemModel(class_1792 item, ModuleType moduleType) {
        this.addItemModel(item, class_4943.field_22938, moduleType);
    }

    public void addSimpleToolModel(class_1792 item, ModuleType moduleType) {
        this.addItemModel(item, class_4943.field_22939, moduleType);
    }

    public void method_10319(@NotNull class_7403 cachedOutput) {
        this.updatePaths();
        super.method_10319(cachedOutput);
    }

    public void updatePaths() {
        this.dataGenerator.field_11274 = this.appendPath(this.moduleType);
        this.field_39375.field_39365 = this.appendPath(this.moduleType);
        this.field_39376.field_39365 = this.appendPath(this.moduleType);
    }

    public Path appendPath(ModuleType moduleType) {
        return PolyDataGen.getPathFromModuleType(moduleType).resolve("assets");
    }
}

