/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.mulitblock.IMultiblockPart;
import net.creeperhost.polylib.mulitblock.MultiblockControllerBase;
import net.creeperhost.polylib.mulitblock.MultiblockRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockBlockEntityBase
extends IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private class_2487 cachedMultiblockData = null;

    public MultiblockBlockEntityBase(class_2591<?> tileEntityTypeIn, class_2338 blockPos, class_2680 blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            PolyLib.LOGGER.info(String.format("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
            this.controller = null;
        }
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        super.method_11014(compoundTag);
        if (!compoundTag.method_10562("multiblockData").method_33133()) {
            this.cachedMultiblockData = compoundTag.method_10562("multiblockData");
        }
    }

    protected void method_11007(@NotNull class_2487 compoundTag) {
        super.method_11007(compoundTag);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            class_2487 multiblockData = new class_2487();
            this.controller.writeToNBT(multiblockData);
            compoundTag.method_10566("multiblockData", (class_2520)multiblockData);
        }
    }

    public void method_11012() {
        super.method_11012();
        this.detachSelf(false);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        MultiblockRegistry.onPartAdded(this.method_10997(), this);
    }

    protected void encodeDescriptionPacket(class_2487 packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            class_2487 tag = new class_2487();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.method_10566("multiblockData", (class_2520)tag);
        }
    }

    protected void decodeDescriptionPacket(class_2487 packetData) {
        if (packetData.method_10580("multiblockData") != null) {
            class_2487 tag = packetData.method_10562("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public class_2487 getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public class_2338 getWorldLocation() {
        return this.method_11016();
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        class_2338 partPosition = this.getWorldLocation();
        for (class_2350 facing : class_2350.values()) {
            class_2338 neighborPosition = partPosition.method_10093(facing);
            class_2586 te = this.field_11863.method_8321(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.method_10997(), this);
    }
}

