/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock.rectangular;

import net.creeperhost.polylib.mulitblock.MultiblockControllerBase;
import net.creeperhost.polylib.mulitblock.MultiblockValidationException;
import net.creeperhost.polylib.mulitblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(class_1937 world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        class_2338 maximumCoord = this.getMaximumCoord();
        class_2338 minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.method_10263() - minimumCoord.method_10263() + 1;
        int deltaY = maximumCoord.method_10264() - minimumCoord.method_10264() + 1;
        int deltaZ = maximumCoord.method_10260() - minimumCoord.method_10260() + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.method_10263(); x <= maximumCoord.method_10263(); ++x) {
            for (int y = minimumCoord.method_10264(); y <= maximumCoord.method_10264(); ++y) {
                for (int z = minimumCoord.method_10260(); z <= maximumCoord.method_10260(); ++z) {
                    RectangularMultiblockTileEntityBase part;
                    class_2586 te = this.worldObj.method_8321(new class_2338(x, y, z));
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.method_10263()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.method_10264()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.method_10260()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.method_10263()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.method_10264()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.method_10260()) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.method_10264()) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.method_10264()) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

