/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.client.recipe.RecipesWidget;
import com.illusivesoulworks.polymorph.common.capability.AbstractRecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;

public class PlayerRecipeData
extends AbstractRecipeData<class_1657>
implements IPlayerRecipeData {
    private class_1703 containerMenu;
    private class_1860<?> cachedSelection;
    private int lastAccessTick;

    public PlayerRecipeData(class_1657 owner) {
        super(owner);
    }

    @Override
    public <T extends class_1860<C>, C extends class_1263> Optional<T> getRecipe(class_3956<T> type, C inventory, class_1937 level, List<T> recipesList) {
        if (((class_1657)this.getOwner()).field_6012 == this.lastAccessTick) {
            if (this.cachedSelection != null) {
                this.setSelectedRecipe(this.cachedSelection);
            }
        } else {
            this.cachedSelection = null;
        }
        Optional<Object> maybeRecipe = super.getRecipe(type, inventory, level, recipesList);
        if (this.getContainerMenu() == ((class_1657)this.getOwner()).field_7512) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        if (((class_1657)this.getOwner()).field_6012 != this.lastAccessTick) {
            this.lastAccessTick = ((class_1657)this.getOwner()).field_6012;
            this.cachedSelection = maybeRecipe.orElse(null);
        }
        return maybeRecipe;
    }

    @Override
    public void selectRecipe(@Nonnull class_1860<?> recipe) {
        super.selectRecipe(recipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof class_3222) {
            PolymorphApi.common().getPacketDistributor().sendPlayerSyncS2C((class_3222)this.getOwner(), this.getRecipesList(), this.getSelectedRecipe().map(class_1860::method_8114).orElse(null));
        }
    }

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        if (this.getContainerMenu() == ((class_1657)this.getOwner()).field_7512) {
            Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
            class_1657 player = (class_1657)this.getOwner();
            if (player.field_6002.method_8608()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (class_2960)packetData.getSecond()));
            } else if (player instanceof class_3222) {
                PolymorphApi.common().getPacketDistributor().sendRecipesListS2C((class_3222)player, (SortedSet)packetData.getFirst(), (class_2960)packetData.getSecond());
            }
        }
    }

    @Override
    public Set<class_3222> getListeners() {
        class_1657 player = (class_1657)this.getOwner();
        if (player instanceof class_3222) {
            return Collections.singleton((class_3222)player);
        }
        return new HashSet<class_3222>();
    }

    @Override
    public void setContainerMenu(class_1703 containerMenu) {
        this.containerMenu = containerMenu;
    }

    @Override
    public class_1703 getContainerMenu() {
        return this.containerMenu;
    }
}

