/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.promenade.object.world.gen.feature;

import com.hugman.promenade.object.world.gen.feature.EHugeMushroomFeatureConfig;
import com.mojang.serialization.Codec;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4784;
import net.minecraft.class_4953;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class EHugeMushroomFeature
extends class_3031<EHugeMushroomFeatureConfig> {
    public EHugeMushroomFeature(Codec<EHugeMushroomFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<EHugeMushroomFeatureConfig> context) {
        class_5819 random = context.method_33654();
        EHugeMushroomFeatureConfig config = (EHugeMushroomFeatureConfig)context.method_33656();
        class_5281 world = context.method_33652();
        class_2338 pos = context.method_33655();
        int stemHeight = this.getStemHeight(random, config);
        int hatSize = this.getHatSize(random, config);
        class_2338.class_2339 origin = EHugeMushroomFeature.getOrigin((class_1936)world, pos, stemHeight, config);
        if (origin == null) {
            return false;
        }
        if (origin.method_10264() + stemHeight + 1 >= world.method_31605()) {
            return false;
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 4);
        this.generateStem((class_1936)world, random, (class_2338)origin, stemHeight, config);
        if (config.flatHat) {
            this.generateFlatHat((class_1936)world, random, (class_2338)origin, stemHeight, hatSize, config);
        } else {
            this.generateBubbleHat((class_1936)world, random, (class_2338)origin, stemHeight, hatSize, config);
        }
        return true;
    }

    private static void generateVines(class_2338 pos, class_1936 worldAccess, class_5819 random, EHugeMushroomFeatureConfig config) {
        class_2338.class_2339 mutable = pos.method_25503().method_10098(config.upsideDown ? class_2350.field_11036 : class_2350.field_11033);
        if (worldAccess.method_22347((class_2338)mutable)) {
            int i = class_3532.method_15395((class_5819)random, (int)1, (int)5);
            if (random.method_43048(7) == 0) {
                i *= 2;
            }
            if (config.upsideDown) {
                class_4953.method_25987((class_1936)worldAccess, (class_5819)random, (class_2338.class_2339)mutable, (int)i, (int)23, (int)25);
            } else {
                class_4784.method_24450((class_1936)worldAccess, (class_5819)random, (class_2338.class_2339)mutable, (int)i, (int)23, (int)25);
            }
        }
    }

    private static class_2338.class_2339 getOrigin(class_1936 world, class_2338 pos, int height, EHugeMushroomFeatureConfig config) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = pos.method_10264(); i >= 1; --i) {
            mutable.method_33098(i);
            if (!EHugeMushroomFeature.isValidGround(world, mutable.method_10093(config.upsideDown ? class_2350.field_11036 : class_2350.field_11033))) continue;
            class_2338.class_2339 mutable2 = mutable.method_25503();
            boolean allReplaceable = true;
            for (int j = 0; j <= height + 1; ++j) {
                mutable2.method_10104(config.upsideDown ? class_2350.field_11033 : class_2350.field_11036, j);
                if (EHugeMushroomFeature.isReplaceable(world, (class_2338)mutable2, false, true)) continue;
                allReplaceable = false;
                break;
            }
            if (!allReplaceable) continue;
            return mutable;
        }
        return null;
    }

    private static boolean isReplaceable(class_1936 worldAccess, class_2338 blockPos, boolean canReplaceFluid, boolean canReplaceAllPlants) {
        return worldAccess.method_16358(blockPos, blockState -> {
            class_3614 material = blockState.method_26207();
            return blockState.method_26215() || canReplaceFluid && blockState.method_27852(class_2246.field_10382) || canReplaceFluid && blockState.method_27852(class_2246.field_10164) || material == class_3614.field_15956 || canReplaceAllPlants && material == class_3614.field_15935;
        });
    }

    public static boolean isValidGround(class_1936 worldAccess, class_2338 blockPos) {
        return worldAccess.method_16358(blockPos, blockState -> blockState.method_27852(class_2246.field_10515) || blockState.method_27852(class_2246.field_10213) || blockState.method_27852(class_2246.field_23077));
    }

    private void generateStem(class_1936 world, class_5819 random, class_2338 origin, int stemHeight, EHugeMushroomFeatureConfig config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 blockState = config.stemState;
        if (blockState.method_28498((class_2769)class_2381.field_11166) && blockState.method_28498((class_2769)class_2381.field_11169)) {
            blockState = (class_2680)((class_2680)blockState.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2381.field_11169, (Comparable)Boolean.valueOf(false));
        }
        for (int i = 0; i < stemHeight; ++i) {
            mutable.method_10101((class_2382)origin).method_10104(config.upsideDown ? class_2350.field_11033 : class_2350.field_11036, i);
            if (!EHugeMushroomFeature.isReplaceable(world, (class_2338)mutable, true, true)) continue;
            this.method_13153((class_1945)world, (class_2338)mutable, blockState);
        }
    }

    protected void generateBubbleHat(class_1936 world, class_5819 random, class_2338 origin, int stemHeight, int hatSize, EHugeMushroomFeatureConfig config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = stemHeight - hatSize; i <= stemHeight; ++i) {
            int j = i < stemHeight ? hatSize : hatSize - 1;
            int k = hatSize - 2;
            for (int l = -j; l <= j; ++l) {
                for (int m = -j; m <= j; ++m) {
                    boolean bl6;
                    boolean bl = l == -j;
                    boolean bl2 = l == j;
                    boolean bl3 = m == -j;
                    boolean bl4 = m == j;
                    boolean bl5 = bl || bl2;
                    boolean bl7 = bl6 = bl3 || bl4;
                    if (i < stemHeight && bl5 == bl6) continue;
                    mutable.method_25504((class_2382)origin, l, config.upsideDown ? -i : i, m);
                    if (world.method_8320((class_2338)mutable).method_26216((class_1922)world, (class_2338)mutable)) continue;
                    boolean bl72 = i >= stemHeight - 1;
                    boolean bl8 = i <= stemHeight - hatSize;
                    boolean up = config.upsideDown ? bl8 : bl72;
                    boolean down = config.upsideDown ? bl72 : bl8;
                    class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)config.hatState.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(up))).method_11657((class_2769)class_2381.field_11169, (Comparable)Boolean.valueOf(down))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(l < -k))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(l > k))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(m < -k))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(m > k));
                    this.generateHatBlock(world, random, (class_2338)mutable, state, config);
                }
            }
        }
    }

    protected void generateFlatHat(class_1936 world, class_5819 random, class_2338 origin, int stemHeight, int hatSize, EHugeMushroomFeatureConfig config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int j = -hatSize; j <= hatSize; ++j) {
            for (int k = -hatSize; k <= hatSize; ++k) {
                boolean bl6;
                boolean bl = j == -hatSize;
                boolean bl2 = j == hatSize;
                boolean bl3 = k == -hatSize;
                boolean bl4 = k == hatSize;
                boolean bl5 = bl || bl2;
                boolean bl7 = bl6 = bl3 || bl4;
                if (bl5 && bl6) continue;
                mutable.method_25504((class_2382)origin, j, config.upsideDown ? -stemHeight : stemHeight, k);
                if (world.method_8320((class_2338)mutable).method_26216((class_1922)world, (class_2338)mutable)) continue;
                boolean bl72 = bl || bl6 && j == 1 - hatSize;
                boolean bl8 = bl2 || bl6 && j == hatSize - 1;
                boolean bl9 = bl3 || bl5 && k == 1 - hatSize;
                boolean bl10 = bl4 || bl5 && k == hatSize - 1;
                class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)config.hatState.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(!config.upsideDown))).method_11657((class_2769)class_2381.field_11169, (Comparable)Boolean.valueOf(config.upsideDown))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(bl72))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(bl8))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(bl9))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(bl10));
                this.generateHatBlock(world, random, (class_2338)mutable, state, config);
            }
        }
    }

    private void generateHatBlock(class_1936 world, class_5819 random, class_2338 pos, class_2680 hatState, EHugeMushroomFeatureConfig config) {
        if ((double)random.method_43057() < config.decorationChance) {
            this.method_13153((class_1945)world, pos, config.decorationState);
        } else {
            this.method_13153((class_1945)world, pos, hatState);
            if ((double)random.method_43057() < config.vineChance) {
                EHugeMushroomFeature.generateVines(pos, world, random, config);
            }
        }
    }

    protected int getStemHeight(class_5819 random, EHugeMushroomFeatureConfig config) {
        int i = config.stemBaseHeight + random.method_43048(config.stemRandomHeight);
        if (random.method_43048(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected int getHatSize(class_5819 random, EHugeMushroomFeatureConfig config) {
        if (config.hatRandomSize == 0) {
            return config.hatBaseSize;
        }
        return config.hatBaseSize + random.method_43048(config.hatRandomSize);
    }
}

