/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config;

import com.teamresourceful.resourcefulconfig.common.annotations.ByteRange;
import com.teamresourceful.resourcefulconfig.common.annotations.DoubleRange;
import com.teamresourceful.resourcefulconfig.common.annotations.FloatRange;
import com.teamresourceful.resourcefulconfig.common.annotations.IntRange;
import com.teamresourceful.resourcefulconfig.common.annotations.LongRange;
import com.teamresourceful.resourcefulconfig.common.annotations.ShortRange;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Objects;

public interface ResourcefulConfigEntry {
    public EntryType type();

    public Field field();

    public Object defaultValue();

    default public <T> T getDefaultOrElse(T value) {
        Object defaultValue = this.defaultValue();
        return (T)(defaultValue == null ? value : defaultValue);
    }

    default public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.field().getAnnotation(annotation);
    }

    default public boolean setArray(Object[] array) {
        try {
            for (Object o : array) {
                if (this.type().test(o.getClass())) continue;
                return false;
            }
            this.field().set(null, ResourcefulConfigEntry.castArray(array, this.field().getType().componentType()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static <T> T[] castArray(Object[] array, Class<T> clazz) {
        Object[] newArray = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = clazz.cast(array[i]);
        }
        return newArray;
    }

    default public boolean setByte(byte value) {
        if (this.type() != EntryType.BYTE) {
            return false;
        }
        try {
            ByteRange range = this.field().getAnnotation(ByteRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setByte(null, (Byte)this.defaultValue());
                return false;
            }
            this.field().setByte(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setShort(short value) {
        if (this.type() != EntryType.SHORT) {
            return false;
        }
        try {
            ShortRange range = this.field().getAnnotation(ShortRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setShort(null, (Short)this.defaultValue());
                return false;
            }
            this.field().setShort(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setInt(int value) {
        if (this.type() != EntryType.INTEGER) {
            return false;
        }
        try {
            IntRange range = this.field().getAnnotation(IntRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setInt(null, (Integer)this.defaultValue());
                return false;
            }
            this.field().setInt(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setLong(long value) {
        if (this.type() != EntryType.LONG) {
            return false;
        }
        try {
            LongRange range = this.field().getAnnotation(LongRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setLong(null, (Long)this.defaultValue());
                return false;
            }
            this.field().setLong(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setFloat(float value) {
        if (this.type() != EntryType.FLOAT) {
            return false;
        }
        try {
            FloatRange range = this.field().getAnnotation(FloatRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setFloat(null, ((Float)this.defaultValue()).floatValue());
                return false;
            }
            this.field().setFloat(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setDouble(double value) {
        if (this.type() != EntryType.DOUBLE) {
            return false;
        }
        try {
            DoubleRange range = this.field().getAnnotation(DoubleRange.class);
            if (range != null && (value < range.min() || value > range.max())) {
                this.field().setDouble(null, (Double)this.defaultValue());
                return false;
            }
            this.field().setDouble(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setBoolean(boolean value) {
        if (this.type() != EntryType.BOOLEAN) {
            return false;
        }
        try {
            this.field().setBoolean(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setString(String value) {
        if (this.type() != EntryType.STRING) {
            return false;
        }
        try {
            this.field().set(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean setEnum(Enum<?> value) {
        if (this.type() != EntryType.ENUM) {
            return false;
        }
        if (value == null) {
            return false;
        }
        try {
            this.field().set(null, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean isDefault(Object object) {
        return switch (this.type()) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.BYTE, EntryType.SHORT, EntryType.INTEGER, EntryType.LONG, EntryType.FLOAT, EntryType.DOUBLE, EntryType.BOOLEAN, EntryType.STRING -> Objects.equals(object, this.defaultValue());
            case EntryType.ENUM -> {
                Enum value;
                yield object instanceof Enum && (value = (Enum)object).name().equals(((Enum)this.defaultValue()).name());
            }
        };
    }

    default public void reset() {
        if (this.field().getType().isArray()) {
            this.setArray((Object[])this.defaultValue());
        } else {
            switch (this.type()) {
                case BYTE: {
                    this.setByte((Byte)this.defaultValue());
                    break;
                }
                case SHORT: {
                    this.setShort((Short)this.defaultValue());
                    break;
                }
                case INTEGER: {
                    this.setInt((Integer)this.defaultValue());
                    break;
                }
                case LONG: {
                    this.setLong((Long)this.defaultValue());
                    break;
                }
                case FLOAT: {
                    this.setFloat(((Float)this.defaultValue()).floatValue());
                    break;
                }
                case DOUBLE: {
                    this.setDouble((Double)this.defaultValue());
                    break;
                }
                case BOOLEAN: {
                    this.setBoolean((Boolean)this.defaultValue());
                    break;
                }
                case STRING: {
                    this.setString((String)this.defaultValue());
                    break;
                }
                case ENUM: {
                    this.setEnum((Enum)this.defaultValue());
                }
            }
        }
    }
}

