/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt;

import com.teamresourceful.resourcefullib.common.nbt.NbtReader;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class TagReader<I, T extends class_2520>
implements NbtReader<I, T> {
    private final byte type;
    private final Function<I, T> writer;
    private final BiConsumer<I, T> reader;
    @Nullable
    private final Supplier<T> defaultCreator;

    public TagReader(byte type, Function<I, T> writer, BiConsumer<I, T> reader, @Nullable Supplier<T> defaultCreator) {
        this.type = type;
        this.writer = writer;
        this.reader = reader;
        this.defaultCreator = defaultCreator;
    }

    public static <I> TagReader<I, class_2481> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader) {
        return new TagReader<Object, class_2481>(1, i -> class_2481.method_23233((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10698()), null);
    }

    public static <I> TagReader<I, class_2481> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader, byte defaultValue) {
        return new TagReader<Object, class_2481>(1, i -> class_2481.method_23233((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10698()), () -> class_2481.method_23233((byte)defaultValue));
    }

    public static <I> TagReader<I, class_2516> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader) {
        return new TagReader<Object, class_2516>(2, i -> class_2516.method_23254((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10696()), null);
    }

    public static <I> TagReader<I, class_2516> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader, short defaultValue) {
        return new TagReader<Object, class_2516>(2, i -> class_2516.method_23254((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10696()), () -> class_2516.method_23254((short)defaultValue));
    }

    public static <I> TagReader<I, class_2497> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader) {
        return new TagReader<Object, class_2497>(3, i -> class_2497.method_23247((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10701()), null);
    }

    public static <I> TagReader<I, class_2497> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader, int defaultValue) {
        return new TagReader<Object, class_2497>(3, i -> class_2497.method_23247((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10701()), () -> class_2497.method_23247((int)defaultValue));
    }

    public static <I> TagReader<I, class_2503> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader) {
        return new TagReader<Object, class_2503>(4, i -> class_2503.method_23251((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10699()), null);
    }

    public static <I> TagReader<I, class_2503> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader, long defaultValue) {
        return new TagReader<Object, class_2503>(4, i -> class_2503.method_23251((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10699()), () -> class_2503.method_23251((long)defaultValue));
    }

    public static <I> TagReader<I, class_2494> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader) {
        return new TagReader<Object, class_2494>(5, i -> class_2494.method_23244((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.method_10700())), null);
    }

    public static <I> TagReader<I, class_2494> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader, float defaultValue) {
        return new TagReader<Object, class_2494>(5, i -> class_2494.method_23244((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.method_10700())), () -> class_2494.method_23244((float)defaultValue));
    }

    public static <I> TagReader<I, class_2489> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader) {
        return new TagReader<Object, class_2489>(6, i -> class_2489.method_23241((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10697()), null);
    }

    public static <I> TagReader<I, class_2489> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader, double defaultValue) {
        return new TagReader<Object, class_2489>(6, i -> class_2489.method_23241((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10697()), () -> class_2489.method_23241((double)defaultValue));
    }

    public static <I> TagReader<I, class_2519> stringTag(Function<I, String> writer, BiConsumer<I, String> reader) {
        return new TagReader<Object, class_2519>(8, i -> class_2519.method_23256((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10714()), null);
    }

    public static <I> TagReader<I, class_2519> stringTag(Function<I, String> writer, BiConsumer<I, String> reader, String defaultValue) {
        return new TagReader<Object, class_2519>(8, i -> class_2519.method_23256((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.method_10714()), () -> class_2519.method_23256((String)defaultValue));
    }

    @Override
    public byte type() {
        return this.type;
    }

    @Override
    public void setDefault(I instance) {
        if (this.defaultCreator != null) {
            this.reader.accept(instance, (class_2520)this.defaultCreator.get());
        }
    }

    @Override
    public void read(I instance, T tag) {
        this.reader.accept(instance, tag);
    }

    @Override
    public T write(I instance) {
        return (T)((class_2520)this.writer.apply(instance));
    }
}

