/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericMemoryPack
implements class_3262 {
    private final HashMap<class_2960, Supplier<? extends InputStream>> data = new HashMap();
    private final JsonObject metaData;
    private final class_3264 allowedType;
    private final String id;

    protected GenericMemoryPack(class_3264 type, String id, JsonObject meta) {
        this.metaData = meta;
        this.allowedType = type;
        this.id = id;
    }

    private boolean isTypeAllowed(class_3264 type) {
        return this.allowedType.equals((Object)type);
    }

    public void putData(class_3264 type, class_2960 location, Supplier<? extends InputStream> supplier) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.put(location, supplier);
    }

    public void putJson(class_3264 type, class_2960 location, JsonElement json) {
        this.putData(type, location, () -> new ByteArrayInputStream(Constants.GSON.toJson(json).getBytes(StandardCharsets.UTF_8)));
    }

    @NotNull
    public InputStream method_14410(@NotNull String file) throws IOException {
        if (file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        throw new FileNotFoundException(file);
    }

    @NotNull
    public InputStream method_14405(@NotNull class_3264 type, @NotNull class_2960 location) throws IOException {
        if (this.method_14411(type, location)) {
            return this.data.get(location).get();
        }
        throw new FileNotFoundException(location.toString());
    }

    @NotNull
    public Collection<class_2960> method_14408(@NotNull class_3264 type, @NotNull String namespace, @NotNull String path, @NotNull Predicate<class_2960> predicate) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptyList();
        }
        return this.data.keySet().stream().filter(location -> location.method_12836().equals(namespace)).filter(location -> location.method_12832().startsWith(path)).filter(location -> predicate.test(GenericMemoryPack.createPath(namespace, location.method_12832().substring(Math.max(location.method_12832().lastIndexOf(47), 0))))).collect(Collectors.toList());
    }

    private static class_2960 createPath(String namespace, String input) {
        return class_2960.method_12829((String)(namespace + ":" + input));
    }

    public boolean method_14411(@NotNull class_3264 type, @NotNull class_2960 location) {
        return this.isTypeAllowed(type) && this.data.containsKey(location);
    }

    @NotNull
    public Set<String> method_14406(@NotNull class_3264 type) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptySet();
        }
        return this.data.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T method_14407(@NotNull class_3270<T> serializer) {
        if (!serializer.method_14420().equals("pack")) {
            return null;
        }
        return (T)serializer.method_14421(this.metaData);
    }

    @NotNull
    public String method_14409() {
        return this.id;
    }

    public void close() {
        for (Supplier<? extends InputStream> value : this.data.values()) {
            try {
                value.get().close();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to close input stream", (Throwable)e);
            }
        }
    }
}

