/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn;

import com.teamresourceful.resourcefullib.common.utils.readers.ByteReader;
import com.teamresourceful.resourcefullib.common.yabn.YabnCompressor;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnArray;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnException;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnObject;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnPrimitive;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnType;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NullContents;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class YabnParser {
    private YabnParser() {
    }

    public static YabnElement parseCompress(ByteReader data) throws YabnException {
        return YabnCompressor.compress(YabnParser.parse(data));
    }

    public static YabnElement parse(ByteReader data) throws YabnException {
        try {
            YabnType type = YabnType.fromId(data.readByte());
            return YabnParser.getElement(type, data);
        }
        catch (Exception exception) {
            if (exception instanceof YabnException) {
                throw exception;
            }
            if (exception instanceof ArrayIndexOutOfBoundsException) {
                throw new YabnException("Array index out of bounds, make sure there is an EOD byte at the end of the data that requires it.");
            }
            throw new YabnException(exception.getMessage());
        }
    }

    private static YabnElement read(ByteReader data) {
        LinkedHashMap<String, YabnElement> obj = new LinkedHashMap<String, YabnElement>();
        while (data.peek() != 0) {
            YabnType type = YabnType.fromId(data.readByte());
            String key = data.readString();
            obj.put(key, YabnParser.getElement(type, data));
        }
        data.advance();
        return new YabnObject(obj);
    }

    private static YabnArray readArray(ByteReader data) {
        ArrayList<YabnElement> elements = new ArrayList<YabnElement>();
        while (data.peek() != 0) {
            YabnType type = YabnType.fromId(data.readByte());
            elements.add(YabnParser.getElement(type, data));
        }
        data.advance();
        return new YabnArray(elements);
    }

    private static YabnElement getElement(YabnType type, ByteReader data) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case YabnType.NULL -> NullContents.NULL;
            case YabnType.BOOLEAN_TRUE -> YabnPrimitive.ofBoolean(true);
            case YabnType.BOOLEAN_FALSE -> YabnPrimitive.ofBoolean(false);
            case YabnType.BYTE -> YabnPrimitive.ofByte(data.readByte());
            case YabnType.SHORT -> YabnPrimitive.ofShort(data.readShort());
            case YabnType.INT -> YabnPrimitive.ofInt(data.readInt());
            case YabnType.LONG -> YabnPrimitive.ofLong(data.readLong());
            case YabnType.FLOAT -> YabnPrimitive.ofFloat(data.readFloat());
            case YabnType.DOUBLE -> YabnPrimitive.ofDouble(data.readDouble());
            case YabnType.STRING -> YabnPrimitive.ofString(data.readString());
            case YabnType.EMPTY_STRING -> YabnPrimitive.ofString("");
            case YabnType.ARRAY -> YabnParser.readArray(data);
            case YabnType.OBJECT -> YabnParser.read(data);
            case YabnType.EMPTY_ARRAY -> new YabnArray();
            case YabnType.EMPTY_OBJECT -> new YabnObject();
        };
    }
}

