/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.revelationary;

import de.dafuqs.revelationary.ClientRevelationHolder;
import de.dafuqs.revelationary.api.advancements.ClientAdvancementPacketCallback;
import de.dafuqs.revelationary.mixin.client.AccessorClientAdvancementManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2779;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_632;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientAdvancements {
    protected static boolean receivedFirstAdvancementPacket = false;
    public static List<ClientAdvancementPacketCallback> callbacks = new ArrayList<ClientAdvancementPacketCallback>();

    public static void onClientPacket(@NotNull class_2779 packet) {
        boolean hadPacketBefore = receivedFirstAdvancementPacket;
        receivedFirstAdvancementPacket = true;
        boolean isReset = packet.method_11924();
        boolean isFirstPacket = !hadPacketBefore || isReset;
        Set<class_2960> doneAdvancements = ClientAdvancements.getDoneAdvancements(packet);
        Set removedAdvancements = packet.method_11926();
        ClientRevelationHolder.processRemovedAdvancements(removedAdvancements);
        ClientRevelationHolder.processNewAdvancements(doneAdvancements, isFirstPacket);
        for (ClientAdvancementPacketCallback callback : callbacks) {
            callback.onClientAdvancementPacket(doneAdvancements, removedAdvancements, isFirstPacket);
        }
    }

    public static boolean hasDone(class_2960 identifier) {
        class_632 cm;
        class_161 adv;
        class_634 conn;
        if (!receivedFirstAdvancementPacket) {
            return false;
        }
        if (identifier != null && (conn = class_310.method_1551().method_1562()) != null && (adv = (cm = conn.method_2869()).method_2863().method_716(identifier)) != null) {
            Map<class_161, class_167> progressMap = ((AccessorClientAdvancementManager)cm).getAdvancementProgresses();
            class_167 progress = progressMap.get(adv);
            return progress != null && progress.method_740();
        }
        return false;
    }

    @NotNull
    public static Set<class_2960> getDoneAdvancements(@NotNull class_2779 packet) {
        HashSet<class_2960> doneAdvancements = new HashSet<class_2960>();
        for (class_2960 earnedAdvancementIdentifier : packet.method_11928().keySet()) {
            if (!ClientAdvancements.hasDone(earnedAdvancementIdentifier)) continue;
            doneAdvancements.add(earnedAdvancementIdentifier);
        }
        for (class_2960 progressedAdvancementIdentifier : packet.method_11927().keySet()) {
            if (!ClientAdvancements.hasDone(progressedAdvancementIdentifier)) continue;
            doneAdvancements.add(progressedAdvancementIdentifier);
        }
        return doneAdvancements;
    }

    public static void playerLogout() {
        receivedFirstAdvancementPacket = false;
    }
}

