/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.revelationary;

import de.dafuqs.revelationary.RevelationRegistry;
import de.dafuqs.revelationary.api.revelations.RevealingCallback;
import de.dafuqs.revelationary.api.revelations.RevelationAware;
import de.dafuqs.revelationary.api.revelations.WorldRendererAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientRevelationHolder {
    public static List<RevealingCallback> callbacks = new ArrayList<RevealingCallback>();
    private static final Set<class_2680> activeBlockStateSwaps = new HashSet<class_2680>();
    private static final Set<class_1792> activeItemSwaps = new HashSet<class_1792>();

    public static void processNewAdvancements(Set<class_2960> doneAdvancements, boolean isJoinPacket) {
        if (!doneAdvancements.isEmpty()) {
            RevelationAware revelationAware;
            HashSet<class_1792> revealedItems = new HashSet<class_1792>();
            HashSet<class_2680> revealedBlockStates = new HashSet<class_2680>();
            HashSet<class_2248> revealedBlocks = new HashSet<class_2248>();
            for (class_2960 doneAdvancement : doneAdvancements) {
                revealedItems.addAll(RevelationRegistry.getRevealedItems(doneAdvancement));
                revealedBlockStates.addAll(RevelationRegistry.getRevealedBlockStates(doneAdvancement));
                for (class_2680 state : revealedBlockStates) {
                    class_2248 block = state.method_26204();
                    revealedBlocks.add(block);
                }
            }
            if (revealedBlockStates.size() > 0) {
                for (class_2680 revealedBlockState : revealedBlockStates) {
                    activeBlockStateSwaps.remove(revealedBlockState);
                    class_1792 blockItem = revealedBlockState.method_26204().method_8389();
                    if (blockItem == null) continue;
                    activeItemSwaps.remove(blockItem);
                }
                ClientRevelationHolder.rebuildAllChunks();
            }
            for (class_2248 revealedBlock : revealedBlocks) {
                if (!(revealedBlock instanceof RevelationAware)) continue;
                revelationAware = (RevelationAware)revealedBlock;
                revelationAware.onUncloak();
            }
            for (class_1792 revealedItem : revealedItems) {
                activeItemSwaps.remove(revealedItem);
                if (!(revealedItem instanceof RevelationAware)) continue;
                revelationAware = (RevelationAware)revealedItem;
                revelationAware.onUncloak();
            }
            if (!revealedBlocks.isEmpty() || !revealedItems.isEmpty()) {
                for (RevealingCallback callback : callbacks) {
                    callback.trigger(doneAdvancements, revealedBlocks, revealedItems, isJoinPacket);
                }
            }
        }
    }

    public static void processRemovedAdvancements(@NotNull Set<class_2960> removedAdvancements) {
        if (!removedAdvancements.isEmpty()) {
            RevelationAware revelationAware;
            ArrayList<class_1792> concealedItems = new ArrayList<class_1792>();
            ArrayList<class_2680> concealedBlockStates = new ArrayList<class_2680>();
            ArrayList<class_2248> concealedBlocks = new ArrayList<class_2248>();
            for (class_2960 removedAdvancement : removedAdvancements) {
                concealedItems.addAll(RevelationRegistry.getRevealedItems(removedAdvancement));
                concealedBlockStates.addAll(RevelationRegistry.getRevealedBlockStates(removedAdvancement));
                for (class_2680 state : concealedBlockStates) {
                    class_2248 block = state.method_26204();
                    if (concealedBlocks.contains(block)) continue;
                    concealedBlocks.add(block);
                }
            }
            if (concealedBlockStates.size() > 0) {
                for (class_2680 concealedBlockState : concealedBlockStates) {
                    class_1792 blockItem;
                    if (!activeBlockStateSwaps.contains(concealedBlockState)) {
                        activeBlockStateSwaps.add(concealedBlockState);
                    }
                    if ((blockItem = concealedBlockState.method_26204().method_8389()) == null || activeItemSwaps.contains(blockItem)) continue;
                    activeItemSwaps.add(blockItem);
                }
                ClientRevelationHolder.rebuildAllChunks();
            }
            activeItemSwaps.addAll(concealedItems);
            for (class_2248 concealedBlock : concealedBlocks) {
                if (!(concealedBlock instanceof RevelationAware)) continue;
                revelationAware = (RevelationAware)concealedBlock;
                revelationAware.onCloak();
            }
            for (class_1792 concealedItem : concealedItems) {
                if (!(concealedItem instanceof RevelationAware)) continue;
                revelationAware = (RevelationAware)concealedItem;
                revelationAware.onCloak();
            }
        }
    }

    static void rebuildAllChunks() {
        class_761 renderer = class_310.method_1551().field_1769;
        ((WorldRendererAccessor)renderer).rebuildAllChunks();
    }

    private static void cloak(class_2680 blockState) {
        activeBlockStateSwaps.add(blockState);
        if (blockState instanceof RevelationAware) {
            RevelationAware revelationAware = (RevelationAware)blockState;
            revelationAware.onCloak();
        }
    }

    public static boolean isCloaked(class_2248 block) {
        return activeBlockStateSwaps.contains(block.method_9564());
    }

    public static boolean isCloaked(class_2680 blockState) {
        return activeBlockStateSwaps.contains(blockState);
    }

    public static class_2680 getCloakTarget(class_2680 blockState) {
        if (ClientRevelationHolder.isCloaked(blockState)) {
            return RevelationRegistry.getCloak(blockState);
        }
        return blockState;
    }

    private static void cloak(class_1792 item) {
        activeItemSwaps.add(item);
        if (item instanceof RevelationAware) {
            RevelationAware revelationAware = (RevelationAware)item;
            revelationAware.onCloak();
        }
    }

    public static boolean isCloaked(class_1792 item) {
        return activeItemSwaps.contains(item);
    }

    public static class_1792 getCloakTarget(class_1792 item) {
        if (ClientRevelationHolder.isCloaked(item)) {
            return RevelationRegistry.getCloak(item);
        }
        return item;
    }

    public static void cloakAll() {
        activeItemSwaps.clear();
        activeBlockStateSwaps.clear();
        for (List<class_2680> list : RevelationRegistry.getBlockStateEntries().values()) {
            for (class_2680 registeredRevelation : list) {
                ClientRevelationHolder.cloak(registeredRevelation);
            }
        }
        for (List<class_2680> list : RevelationRegistry.getItemEntries().values()) {
            for (class_2680 registeredRevelation : list) {
                ClientRevelationHolder.cloak((class_1792)registeredRevelation);
            }
        }
    }
}

