/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScanResultRenderContext;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.renderer.ScannerRenderer;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;

@Environment(value=EnvType.CLIENT)
public final class ScanManager {
    public static final int SCAN_COMPUTE_DURATION = 40;
    private static final int SCAN_INITIAL_RADIUS = 10;
    private static final int SCAN_TIME_OFFSET = 200;
    private static final int SCAN_GROWTH_DURATION = 2000;
    private static final int REFERENCE_RENDER_DISTANCE = 12;
    private static final Set<ScanResultProvider> collectingProviders = new HashSet<ScanResultProvider>();
    private static final Map<ScanResultProvider, List<ScanResult>> collectingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final Map<ScanResultProvider, List<ScanResult>> pendingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final Map<ScanResultProvider, List<ScanResult>> renderingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private static final List<ScanResult> renderingList = new ArrayList<ScanResult>();
    private static int scanningTicks = -1;
    private static long currentStart = -1L;
    @Nullable
    private static class_243 lastScanCenter;
    private static class_4587 worldViewModelStack;
    private static class_1159 worldProjectionMatrix;

    private static float computeTargetRadius() {
        return class_310.method_1551().field_1773.method_3193();
    }

    public static int computeScanGrowthDuration() {
        return 2000 * (Integer)class_310.method_1551().field_1690.method_42503().method_41753() / 12;
    }

    public static float computeRadius(long start, float duration) {
        float r1 = ScanManager.computeTargetRadius();
        float t1 = duration;
        float b = 200.0f;
        float n = 1.0f / ((t1 + 200.0f) * (t1 + 200.0f) - 40000.0f);
        float a = -r1 * 200.0f * 200.0f * n;
        float c = r1 * n;
        float t = System.currentTimeMillis() - start;
        return 10.0f + a + (t + 200.0f) * (t + 200.0f) * c;
    }

    public static void beginScan(class_1657 player, List<class_1799> stacks) {
        ScanManager.cancelScan();
        float scanRadius = CommonConfig.baseScanRadius;
        ArrayList modules = new ArrayList();
        for (class_1799 stack : stacks) {
            Optional<ScannerModule> module = ScannerModuleItem.getModule(stack);
            module.ifPresent(modules::add);
        }
        for (ScannerModule module : modules) {
            ScanResultProvider provider = module.getResultProvider();
            if (provider != null) {
                collectingProviders.add(provider);
            }
            scanRadius = module.adjustGlobalRange(scanRadius);
        }
        if (collectingProviders.isEmpty()) {
            return;
        }
        class_243 center = player.method_19538();
        for (ScanResultProvider provider : collectingProviders) {
            provider.initialize(player, stacks, center, scanRadius, 40);
        }
    }

    public static void updateScan(class_1297 entity, boolean finish) {
        int remaining = 40 - scanningTicks;
        if (!finish) {
            if (remaining <= 0) {
                return;
            }
            for (ScanResultProvider scanResultProvider : collectingProviders) {
                scanResultProvider.computeScanResults();
            }
            ++scanningTicks;
            return;
        }
        for (int i = 0; i < remaining; ++i) {
            for (ScanResultProvider provider : collectingProviders) {
                provider.computeScanResults();
            }
        }
        for (ScanResultProvider scanResultProvider : collectingProviders) {
            scanResultProvider.collectScanResults((class_1922)entity.field_6002, result -> collectingResults.computeIfAbsent(scanResultProvider, p -> new ArrayList()).add(result));
            scanResultProvider.reset();
        }
        ScanManager.clear();
        lastScanCenter = Objects.requireNonNull(entity.method_19538());
        currentStart = System.currentTimeMillis();
        pendingResults.putAll(collectingResults);
        pendingResults.values().forEach(list -> list.sort(Comparator.comparing(result -> -lastScanCenter.method_1022(result.getPosition()))));
        ScannerRenderer.INSTANCE.ping(lastScanCenter);
        ScanManager.cancelScan();
    }

    public static void cancelScan() {
        collectingProviders.clear();
        collectingResults.clear();
        scanningTicks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        if (lastScanCenter == null || currentStart < 0L) {
            return;
        }
        if (CommonConfig.scanStayDuration < (int)(System.currentTimeMillis() - currentStart)) {
            pendingResults.forEach((provider, results) -> results.forEach(ScanResult::close));
            pendingResults.clear();
            Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
            synchronized (map) {
                if (!renderingResults.isEmpty()) {
                    Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = renderingResults.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
                        List<ScanResult> list = entry.getValue();
                        for (int i = class_3532.method_15386((float)((float)list.size() * 0.5f)); i > 0; --i) {
                            list.remove(list.size() - 1).close();
                        }
                        if (!list.isEmpty()) continue;
                        iterator.remove();
                    }
                }
                if (renderingResults.isEmpty()) {
                    ScanManager.clear();
                }
            }
            return;
        }
        if (pendingResults.isEmpty()) {
            return;
        }
        float radius = ScanManager.computeRadius(currentStart, ScanManager.computeScanGrowthDuration());
        float sqRadius = radius * radius;
        Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = pendingResults.entrySet().iterator();
        while (iterator.hasNext()) {
            int index;
            class_243 position;
            Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
            ScanResultProvider provider2 = entry.getKey();
            List<ScanResult> results2 = entry.getValue();
            while (results2.size() > 0 && lastScanCenter.method_1025(position = results2.get(index = results2.size() - 1).getPosition()) <= (double)sqRadius) {
                ScanResult result = results2.remove(index);
                Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
                synchronized (map) {
                    renderingResults.computeIfAbsent(provider2, p -> new ArrayList()).add(result);
                }
            }
            if (!results2.isEmpty()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderLevel(class_4587 poseStack, class_1159 projectionMatrix, float partialTick) {
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            if (renderingResults.isEmpty()) {
                return;
            }
        }
        worldViewModelStack = new class_4587();
        worldViewModelStack.method_23760().method_23761().method_35434(poseStack.method_23760().method_23761());
        worldProjectionMatrix = projectionMatrix;
        ScanManager.render(ScanResultRenderContext.WORLD, partialTick, worldViewModelStack, worldProjectionMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderGui(float partialTick) {
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            if (renderingResults.isEmpty()) {
                return;
            }
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((class_1159)worldProjectionMatrix);
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.getModelViewStack().method_23760().method_23761().method_22668();
            RenderSystem.applyModelViewMatrix();
            ScanManager.render(ScanResultRenderContext.GUI, partialTick, worldViewModelStack, worldProjectionMatrix);
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.restoreProjectionMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(ScanResultRenderContext context, float partialTicks, class_4587 poseStack, class_1159 projectionMatrix) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 pos = camera.method_19326();
        class_4604 frustum = new class_4604(poseStack.method_23760().method_23761(), projectionMatrix);
        frustum.method_23088(pos.method_10216(), pos.method_10214(), pos.method_10215());
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22903();
        poseStack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        class_4597.class_4598 renderTypeBuffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        try {
            for (Map.Entry<ScanResultProvider, List<ScanResult>> entry : renderingResults.entrySet()) {
                for (ScanResult result : entry.getValue()) {
                    class_238 bounds = result.getRenderBounds();
                    if (bounds != null && !frustum.method_23093(bounds)) continue;
                    renderingList.add(result);
                }
                if (renderingList.isEmpty()) continue;
                entry.getKey().render(context, (class_4597)renderTypeBuffer, poseStack, camera, partialTicks, renderingList);
                renderingList.clear();
            }
        }
        finally {
            renderingList.clear();
        }
        renderTypeBuffer.method_22993();
        poseStack.method_22909();
        RenderSystem.enableDepthTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear() {
        pendingResults.clear();
        Map<ScanResultProvider, List<ScanResult>> map = renderingResults;
        synchronized (map) {
            renderingResults.forEach((provider, results) -> {
                provider.reset();
                results.forEach(ScanResult::close);
            });
            renderingResults.clear();
        }
        lastScanCenter = null;
        currentStart = -1L;
    }
}

