/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.fabric.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.utils.Statistics;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlaceHolders {
    private static final Cache<String, String> CACHE = CacheBuilder.newBuilder().expireAfterWrite(50L, TimeUnit.MILLISECONDS).build();

    public static void register() {
        PlaceHolders.registerDynamic();
        PlaceHolders.registerStatistics();
    }

    private static void registerDynamic() {
        PlaceHolders.register("view_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicSetting.VIEW_DISTANCE.get())));
        PlaceHolders.register("simulation_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicSetting.SIMULATION_DISTANCE.get())));
        PlaceHolders.register("chunk_tick_distance", (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DynamicSetting.CHUNK_TICK_DISTANCE.get())));
        PlaceHolders.register("mobcap_percentage", (ctx, arg) -> PlaceholderResult.value((String)DynamicManager.getModifierAsPercentage()));
    }

    private static void registerStatistics() {
        PlaceHolders.register("chunk_count", (ctx, arg) -> {
            Statistics statistics = Statistics.getInstance(ctx.server());
            boolean onlyLoaded = Objects.equals(arg, "loaded");
            return PlaceHolders.cachedValue(onlyLoaded ? "chunk_count_loaded" : "chunk_count", () -> String.valueOf(statistics.getChunkCount(onlyLoaded)));
        });
        PlaceHolders.register("entity_count", (ctx, arg) -> {
            Statistics statistics = Statistics.getInstance(ctx.server());
            class_3222 player = ctx.player();
            if (player != null && Objects.equals(arg, "nearby")) {
                return PlaceholderResult.value((String)String.valueOf(statistics.getEntitiesNear(player).size()));
            }
            return PlaceHolders.cachedValue("entity_count", () -> String.valueOf(statistics.getAllEntities().size()));
        });
        PlaceHolders.register("block_entity_count", (ctx, arg) -> {
            Statistics statistics = Statistics.getInstance(ctx.server());
            class_3222 player = ctx.player();
            if (player != null && Objects.equals(arg, "nearby")) {
                return PlaceholderResult.value((String)String.valueOf(statistics.getBlockEntitiesNear(player).size()));
            }
            return PlaceHolders.cachedValue("block_entity_count", () -> String.valueOf(statistics.getAllBlockEntities().size()));
        });
    }

    private static PlaceholderResult cachedValue(String key, Callable<String> valueLoader) {
        try {
            return PlaceholderResult.value((String)((String)CACHE.get((Object)key, valueLoader)));
        }
        catch (ExecutionException ex) {
            return PlaceholderResult.invalid((String)("Failed to get value for key: " + key));
        }
    }

    private static void register(String name, PlaceholderHandler handler) {
        Placeholders.register((class_2960)new class_2960("servercore", name), (PlaceholderHandler)handler);
    }
}

