/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class GuiHelper {
    public static float zLevel = 0.0f;

    public static void setTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void setRenderSystem(class_2960 texture) {
        GuiHelper.setTexture(texture);
        GuiHelper.setRenderSystem();
    }

    public static void setRenderSystem() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
    }

    public static void resetRenderSystem() {
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    public static void drawTexture(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTexture(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawTexturedQuad(class_4587 matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 renderer = class_289.method_1348().method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        renderer.method_22918(matrix, (float)x0, (float)y1, zLevel).method_22913(u0, v1).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y1, zLevel).method_22913(u1, v1).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y0, zLevel).method_22913(u1, v0).method_1344();
        renderer.method_22918(matrix, (float)x0, (float)y0, zLevel).method_22913(u0, v0).method_1344();
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
    }

    public static void drawTextureMirrored(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureMirrored(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureMirroredAndScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureMirroredAndScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawMirroredTexturedQuad(class_4587 matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 renderer = class_289.method_1348().method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        renderer.method_22918(matrix, (float)x0, (float)y1, zLevel).method_22913(u1, v1).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y1, zLevel).method_22913(u0, v1).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y0, zLevel).method_22913(u0, v0).method_1344();
        renderer.method_22918(matrix, (float)x0, (float)y0, zLevel).method_22913(u1, v0).method_1344();
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
    }

    public static void drawTextureInverted(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureInverted(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureInvertedAndScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureInvertedAndScaled(class_4587 matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawInvertedTexturedQuad(class_4587 matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 renderer = class_289.method_1348().method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        renderer.method_22918(matrix, (float)x0, (float)y1, zLevel).method_22913(u0, v0).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y1, zLevel).method_22913(u1, v0).method_1344();
        renderer.method_22918(matrix, (float)x1, (float)y0, zLevel).method_22913(u1, v1).method_1344();
        renderer.method_22918(matrix, (float)x0, (float)y0, zLevel).method_22913(u0, v1).method_1344();
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
    }

    public static void drawHorizontalGradient(class_4587 matrixStack, double left, double top, double right, double bottom, int colorRight, int colorLeft) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(class_4587 matrixStack, double left, double top, double right, double bottom, int colorTop, int colorBottom) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(class_4587 matrixStack, double left, double top, double right, double bottom, int color) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, color, color, color, color);
    }

    public static void drawGradientRect(class_4587 matrixStack, double left, double top, double right, double bottom, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        class_287 renderer = class_289.method_1348().method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(matrix, (float)right, (float)top, zLevel).method_39415(colorTopRight).method_1344();
        renderer.method_22918(matrix, (float)left, (float)top, zLevel).method_39415(colorTopLeft).method_1344();
        renderer.method_22918(matrix, (float)left, (float)bottom, zLevel).method_39415(colorBottomLeft).method_1344();
        renderer.method_22918(matrix, (float)right, (float)bottom, zLevel).method_39415(colorBottomRight).method_1344();
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
        RenderSystem.enableTexture();
    }

    public static void drawLine(class_4587 matrixStack, double x1, double y1, double x2, double y2, float width, int color) {
        GuiHelper.drawLine(matrixStack, x1, y1, x2, y2, width, color, color);
    }

    public static void drawLine(class_4587 matrixStack, double x1, double y1, double x2, double y2, float width, int color1, int color2) {
        width /= 2.0f;
        class_1159 matrix = matrixStack.method_23760().method_23761();
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        class_287 renderer = class_289.method_1348().method_1349();
        renderer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        if (y1 == y2) {
            renderer.method_22918(matrix, (float)x1, (float)y1 - width, zLevel).method_39415(color1).method_1344();
            renderer.method_22918(matrix, (float)x2, (float)y2 - width, zLevel).method_39415(color2).method_1344();
            renderer.method_22918(matrix, (float)x1, (float)y1 + width, zLevel).method_39415(color1).method_1344();
            renderer.method_22918(matrix, (float)x2, (float)y2 + width, zLevel).method_39415(color2).method_1344();
        } else if (x1 == x2) {
            renderer.method_22918(matrix, (float)x1 - width, (float)y1, zLevel).method_39415(color1).method_1344();
            renderer.method_22918(matrix, (float)x2 - width, (float)y2, zLevel).method_39415(color2).method_1344();
            renderer.method_22918(matrix, (float)x1 + width, (float)y1, zLevel).method_39415(color1).method_1344();
            renderer.method_22918(matrix, (float)x2 + width, (float)y2, zLevel).method_39415(color2).method_1344();
        } else {
            double angle = Math.abs(Math.atan2(y2 - y1, x2 - x1));
            double percentage = angle % 0.7853981633974483 / 0.7853981633974483;
            int sector = (int)(angle / 0.7853981633974483);
            float xWidth = (float)((double)width * (sector == 0 ? percentage : (sector == 3 ? 1.0 - percentage : 1.0)));
            float yWidth = (float)((double)width * (sector == 1 ? 1.0 - percentage : (sector == 2 ? percentage : 1.0)));
            if (y1 < y2 && x1 < x2 || y1 > y2 && x1 > x2) {
                renderer.method_22918(matrix, (float)x1 + xWidth, (float)y1 - yWidth, zLevel).method_39415(color1).method_1344();
                renderer.method_22918(matrix, (float)x2 + xWidth, (float)y2 - yWidth, zLevel).method_39415(color2).method_1344();
                renderer.method_22918(matrix, (float)x1 - xWidth, (float)y1 + yWidth, zLevel).method_39415(color1).method_1344();
                renderer.method_22918(matrix, (float)x2 - xWidth, (float)y2 + yWidth, zLevel).method_39415(color2).method_1344();
            } else {
                renderer.method_22918(matrix, (float)x1 - xWidth, (float)y1 - yWidth, zLevel).method_39415(color1).method_1344();
                renderer.method_22918(matrix, (float)x2 - xWidth, (float)y2 - yWidth, zLevel).method_39415(color2).method_1344();
                renderer.method_22918(matrix, (float)x1 + xWidth, (float)y1 + yWidth, zLevel).method_39415(color1).method_1344();
                renderer.method_22918(matrix, (float)x2 + xWidth, (float)y2 + yWidth, zLevel).method_39415(color2).method_1344();
            }
        }
        class_286.method_43433((class_287.class_7433)renderer.method_1326());
        RenderSystem.enableTexture();
    }
}

