/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class DistExecutor {
    public static final Set<Long> SERVER_THREADS = new HashSet<Long>();

    @Environment(value=EnvType.CLIENT)
    private static boolean isPhysicalClient() {
        return true;
    }

    @Environment(value=EnvType.SERVER)
    private static boolean isPhysicalServer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    private static boolean isLogicalServer() {
        Set<Long> set = SERVER_THREADS;
        synchronized (set) {
            return SERVER_THREADS.contains(Thread.currentThread().getId());
        }
    }

    private static EnvType getEnv(boolean logical) {
        try {
            if (DistExecutor.isPhysicalClient()) {
                return logical && DistExecutor.isLogicalServer() ? EnvType.SERVER : EnvType.CLIENT;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (DistExecutor.isPhysicalServer()) {
                return EnvType.SERVER;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static <T> T callWhenOn(EnvType dist, Supplier<Callable<T>> toRun) {
        return DistExecutor.callWhenOn(true, dist, toRun);
    }

    public static <T> T callWhenOnPhysical(EnvType dist, Supplier<Callable<T>> toRun) {
        return DistExecutor.callWhenOn(false, dist, toRun);
    }

    private static <T> T callWhenOn(boolean logical, EnvType dist, Supplier<Callable<T>> toRun) {
        if (dist == DistExecutor.getEnv(logical)) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void runWhenOn(EnvType dist, Supplier<Runnable> toRun) {
        if (dist == DistExecutor.getEnv(true)) {
            toRun.get().run();
        }
    }

    public static void runWhenOnPhysical(EnvType dist, Supplier<Runnable> toRun) {
        if (dist == DistExecutor.getEnv(false)) {
            toRun.get().run();
        }
    }

    public static <T> T runForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return DistExecutor.runForDist(DistExecutor.getEnv(true), clientTarget, serverTarget);
    }

    public static <T> T runForPhysicalDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return DistExecutor.runForDist(DistExecutor.getEnv(false), clientTarget, serverTarget);
    }

    private static <T> T runForDist(EnvType dist, Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        if (dist != null) {
            return switch (dist) {
                default -> throw new IncompatibleClassChangeError();
                case EnvType.CLIENT -> clientTarget.get().get();
                case EnvType.SERVER -> serverTarget.get().get();
            };
        }
        throw new IllegalArgumentException("UNSIDED?");
    }
}

