/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.mixins.SPC_PoiType_Accessor;

public class RegistryHelper {
    private final String modId;
    private final boolean delayed;
    private final Map<String, class_2248> BLOCKS = new HashMap<String, class_2248>();
    private final Map<String, class_1792> ITEMS = new HashMap<String, class_1792>();
    private final Map<String, class_2591<?>> TILES = new HashMap();
    private final Map<String, class_1320> ATTRIBUTES = new HashMap<String, class_1320>();
    private final Map<String, class_1291> EFFECTS = new HashMap<String, class_1291>();
    private final Map<String, class_1299<?>> ENTITIES = new HashMap();
    private final Map<String, class_4158> POIS = new HashMap<String, class_4158>();
    private final Map<String, class_1842> POTIONS = new HashMap<String, class_1842>();
    private final Map<String, class_3852> PROFESSIONS = new HashMap<String, class_3852>();
    private final Map<String, class_1865<?>> RECIPE_SERIALIZERS = new HashMap();
    private final Map<String, class_3917<?>> SCREEN_HANDLERS = new HashMap();
    private final Map<String, class_3414> SOUNDS = new HashMap<String, class_3414>();
    private final List<Triple<class_5321<class_4158>, Set<class_2680>, Boolean>> POI_STATES = new ArrayList<Triple<class_5321<class_4158>, Set<class_2680>, Boolean>>();

    public RegistryHelper(String modId) {
        this(modId, true);
    }

    public RegistryHelper(String modId, boolean delayedRegistration) {
        this.modId = modId;
        this.delayed = delayedRegistration;
    }

    public <T extends class_2248> T addBlock(String id, T block, ItemSupplier<? extends class_1792, T> supplier) {
        this.addBlock(id, block);
        if (supplier != null) {
            this.addItem(id, supplier.getItem(block));
        }
        return block;
    }

    public <T extends class_2248> T addBlock(String id, T block) {
        if (this.delayed) {
            this.BLOCKS.put(id, block);
        } else {
            this.register((class_2378)class_2378.field_11146, id, block);
        }
        return block;
    }

    public <T extends class_1792> T addItem(String id, T item) {
        if (this.delayed) {
            this.ITEMS.put(id, item);
        } else {
            this.register((class_2378)class_2378.field_11142, id, item);
        }
        return item;
    }

    public <T extends class_2586> class_2591<T> add(String id, class_2591.class_5559<? extends T> supplier, class_2248 ... validBlocks) {
        class_2591 tile = class_2591.class_2592.method_20528(supplier, (class_2248[])validBlocks).method_11034(null);
        if (this.delayed) {
            this.TILES.put(id, tile);
        } else {
            this.register(class_2378.field_11137, id, tile);
        }
        return tile;
    }

    public <T extends class_1320> T addAttribute(String id, T attribute) {
        if (this.delayed) {
            this.ATTRIBUTES.put(id, attribute);
        } else {
            this.register(class_2378.field_23781, id, attribute);
        }
        return attribute;
    }

    public <T extends class_1291> T addEffect(String id, T effect) {
        if (this.delayed) {
            this.EFFECTS.put(id, effect);
        } else {
            this.register(class_2378.field_11159, id, effect);
        }
        return effect;
    }

    public <T extends class_1297> class_1299<T> add(String id, class_1299.class_4049<T> factory, class_1311 group, float width, float height, boolean summonable) {
        return this.addEntity(id, factory, group, builder -> {
            builder.method_17687(width, height);
            if (!summonable) {
                builder.method_5901();
            }
        });
    }

    public <T extends class_1297> class_1299<T> addEntity(String id, class_1299.class_4049<T> factory, class_1311 group) {
        return this.addEntity(id, factory, group, builder -> {});
    }

    public <T extends class_1297> class_1299<T> addEntity(String id, class_1299.class_4049<T> factory, class_1311 group, Consumer<class_1299.class_1300<T>> properties) {
        class_1299.class_1300 builder = class_1299.class_1300.method_5903(factory, (class_1311)group);
        properties.accept(builder);
        class_1299 entity = builder.method_5905(this.modId + ":" + id);
        if (this.delayed) {
            this.ENTITIES.put(id, entity);
        } else {
            this.register((class_2378)class_2378.field_11145, id, (T)entity);
        }
        return entity;
    }

    public class_3545<class_5321<class_4158>, class_4158> addPOI(String id, int ticketCount, int searchDistance, class_2680 ... states) {
        class_4158 pointOfInterestType = new class_4158((Set)ImmutableSet.copyOf((Object[])states), ticketCount, searchDistance);
        class_5321 registryKey = class_5321.method_29179((class_5321)class_2378.field_25090, (class_2960)new class_2960(this.modId, id));
        if (this.delayed) {
            this.POIS.put(id, pointOfInterestType);
        } else {
            this.register(class_2378.field_18792, id, pointOfInterestType);
        }
        this.addStatesToPOI((class_5321<class_4158>)registryKey, (Set<class_2680>)ImmutableSet.copyOf((Object[])states), false);
        return new class_3545((Object)registryKey, (Object)pointOfInterestType);
    }

    public void addStatesToPOI(class_5321<class_4158> poiTypeKey, Set<class_2680> states, boolean overwrite) {
        if (this.delayed) {
            this.POI_STATES.add((Triple<class_5321<class_4158>, Set<class_2680>, Boolean>)Triple.of(poiTypeKey, states, (Object)overwrite));
        } else {
            this.doAddStatesToPOI(poiTypeKey, states, overwrite);
        }
    }

    private void doAddStatesToPOI(class_5321<class_4158> poiTypeKey, Set<class_2680> states, boolean overwrite) {
        try {
            Map<class_2680, class_6880<class_4158>> poimap = SPC_PoiType_Accessor.getPoiMap();
            class_6880 poiTypeEntry = class_2378.field_18792.method_40290(poiTypeKey);
            states.forEach(state -> {
                if (!poimap.containsKey(state)) {
                    poimap.put((class_2680)state, (class_6880<class_4158>)poiTypeEntry);
                } else if (overwrite) {
                    ShetiPhianCore.LOGGER.info(String.format("RegistryHelper.addStatesToPOI: '%s' has changed the PoI of '%s' from '%s' to '%s'", this.modId, state, poimap.get(state), poiTypeEntry));
                    poimap.put((class_2680)state, (class_6880<class_4158>)poiTypeEntry);
                } else {
                    ShetiPhianCore.LOGGER.info(String.format("RegistryHelper.addStatesToPOI: Skipping '%s' from '%s' as its already in the PoI '%s'", state, this.modId, poiTypeKey));
                }
            });
        }
        catch (AssertionError ignored) {
            ShetiPhianCore.LOGGER.error(String.format("RegistryHelper.addStatesToPOI: Could not add blockstates from '%s' into PoI '%s' as the 'SPC_PoiType_Accessor' mixin failed to load", this.modId, poiTypeKey));
        }
    }

    public <T extends class_1842> T addPotion(String id, T potion) {
        if (this.delayed) {
            this.POTIONS.put(id, potion);
        } else {
            this.register((class_2378)class_2378.field_11143, id, potion);
        }
        return potion;
    }

    public class_3852 addProfession(String id, Predicate<class_6880<class_4158>> heldWorkstation, Predicate<class_6880<class_4158>> acquirableWorkstation, ImmutableSet<class_1792> gatherableItems, ImmutableSet<class_2248> secondaryJobSites, @Nullable class_3414 workSound) {
        class_3852 profession = new class_3852(id, heldWorkstation, acquirableWorkstation, gatherableItems, secondaryJobSites, workSound);
        if (this.delayed) {
            this.PROFESSIONS.put(id, profession);
        } else {
            this.register((class_2378)class_2378.field_17167, id, (Object)profession);
        }
        return profession;
    }

    public <T extends class_1860<?>> class_1865<T> add(String id, Function<class_2960, T> function) {
        return this.add(id, (class_1865<T>)new class_1866(function));
    }

    public <T extends class_1860<?>> class_1865<T> add(String id, class_1865<T> serializer) {
        if (this.delayed) {
            this.RECIPE_SERIALIZERS.put(id, serializer);
        } else {
            this.register(class_2378.field_17598, id, serializer);
        }
        return serializer;
    }

    public <T extends class_1703> class_3917<T> add(String id, ExtendedScreenHandlerType.ExtendedFactory<T> factory) {
        ExtendedScreenHandlerType type = new ExtendedScreenHandlerType(factory);
        if (this.delayed) {
            this.SCREEN_HANDLERS.put(id, (class_3917<?>)type);
        } else {
            this.register(class_2378.field_17429, id, type);
        }
        return type;
    }

    public <T extends class_3414> T addSound(String id) {
        return (T)this.addSound(id, new class_3414(new class_2960(this.modId, id)));
    }

    public <T extends class_3414> T addSound(String id, T sound) {
        if (this.delayed) {
            this.SOUNDS.put(id, sound);
        } else {
            this.register(class_2378.field_11156, id, sound);
        }
        return sound;
    }

    public void doRegistration() {
        this.BLOCKS.forEach((id, object) -> this.register((class_2378)class_2378.field_11146, (String)id, (Object)object));
        this.BLOCKS.clear();
        this.ITEMS.forEach((id, object) -> this.register((class_2378)class_2378.field_11142, (String)id, (Object)object));
        this.ITEMS.clear();
        this.TILES.forEach((id, object) -> this.register((class_2378)class_2378.field_11137, (String)id, (Object)object));
        this.TILES.clear();
        this.ATTRIBUTES.forEach((id, object) -> this.register((class_2378)class_2378.field_23781, (String)id, (Object)object));
        this.ATTRIBUTES.clear();
        this.EFFECTS.forEach((id, object) -> this.register((class_2378)class_2378.field_11159, (String)id, (Object)object));
        this.EFFECTS.clear();
        this.ENTITIES.forEach((id, object) -> this.register((class_2378)class_2378.field_11145, (String)id, (Object)object));
        this.ENTITIES.clear();
        this.POIS.forEach((id, object) -> this.register((class_2378)class_2378.field_18792, (String)id, (Object)object));
        this.POIS.clear();
        this.POI_STATES.forEach(values -> this.doAddStatesToPOI((class_5321<class_4158>)((class_5321)values.getLeft()), (Set)values.getMiddle(), (Boolean)values.getRight()));
        this.POI_STATES.clear();
        this.POTIONS.forEach((id, object) -> this.register((class_2378)class_2378.field_11143, (String)id, (Object)object));
        this.POTIONS.clear();
        this.PROFESSIONS.forEach((id, object) -> this.register((class_2378)class_2378.field_17167, (String)id, (Object)object));
        this.PROFESSIONS.clear();
        this.RECIPE_SERIALIZERS.forEach((id, object) -> this.register((class_2378)class_2378.field_17598, (String)id, (Object)object));
        this.RECIPE_SERIALIZERS.clear();
        this.SCREEN_HANDLERS.forEach((id, object) -> this.register((class_2378)class_2378.field_17429, (String)id, (Object)object));
        this.SCREEN_HANDLERS.clear();
        this.SOUNDS.forEach((id, object) -> this.register((class_2378)class_2378.field_11156, (String)id, (Object)object));
        this.SOUNDS.clear();
    }

    public <V, T extends V> T register(class_2378<V> registry, String id, T entry) {
        return (T)class_2378.method_39197(registry, (class_5321)class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)new class_2960(this.modId, id)), entry);
    }

    @FunctionalInterface
    public static interface ItemSupplier<I extends class_1792, B extends class_2248> {
        public I getItem(B var1);
    }
}

