/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.inventory.IContainerCallback;

public class InventoryInternal
implements class_1263,
class_1275 {
    protected final class_1799[] contents;
    private final String saveName;
    private final int stackLimit;
    private final class_2586 invOwner;
    private final String displayNameKey;
    private final class_2561 displayName;
    private final IContainerCallback callback;

    public InventoryInternal(class_2586 invOwner, String saveName, int invSize, String displayName) {
        this(invOwner, saveName, invSize, 0, displayName);
    }

    public InventoryInternal(class_2586 invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        this(invOwner, saveName, invSize, 0, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(class_2586 invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        this(invOwner, saveName, invSize, invStackLimit, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(class_2586 invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        this.contents = new class_1799[invSize];
        this.invOwner = invOwner;
        this.saveName = saveName;
        this.stackLimit = invStackLimit;
        this.displayNameKey = displayName;
        this.displayName = class_2561.method_43471((String)this.displayNameKey);
        this.callback = callback;
        this.method_5448();
    }

    public void writeToNBT(class_2487 nbtTag) {
        this.writeToNBT(nbtTag, this.saveName);
    }

    public void writeToNBT(class_2487 nbtTag, String name) {
        class_2499 listStacks = new class_2499();
        for (int index = 0; index < Math.min(this.contents.length, 256); index = (int)((short)(index + 1))) {
            if (this.contents[index].method_7960()) continue;
            class_2487 entry = new class_2487();
            entry.method_10567("slot", (byte)index);
            this.contents[index].method_7953(entry);
            listStacks.add((Object)entry);
        }
        nbtTag.method_10566(name, (class_2520)listStacks);
    }

    public void readFromNBT(class_2487 nbtTag) {
        this.readFromNBT(nbtTag, this.saveName);
    }

    public void readFromNBT(class_2487 nbtTag, String name) {
        this.method_5448();
        class_2499 listStacks = nbtTag.method_10554(name, 10);
        for (int index = 0; index < listStacks.size(); index = (int)((short)(index + 1))) {
            class_2487 entry = listStacks.method_10602(index);
            int slot = (entry.method_10545("slot") ? entry.method_10571("slot") : entry.method_10571("Slot")) & 0xFF;
            if (!this.okSlotId(index)) continue;
            this.contents[slot] = class_1799.method_7915((class_2487)entry);
        }
    }

    public class_1799[] getContents() {
        return this.contents;
    }

    protected boolean okSlotId(int slotId) {
        return slotId > -1 && slotId < this.contents.length;
    }

    public String getNameKey() {
        return this.displayNameKey;
    }

    public int method_5439() {
        return this.contents.length;
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.contents) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int slotId) {
        return this.okSlotId(slotId) ? this.contents[slotId] : class_1799.field_8037;
    }

    @NotNull
    public class_1799 method_5434(int slotId, int amount) {
        if (this.okSlotId(slotId) && !this.contents[slotId].method_7960()) {
            if (this.contents[slotId].method_7947() > amount) {
                class_1799 result = this.contents[slotId].method_7971(amount);
                this.method_5431();
                return result;
            }
            class_1799 stack = this.contents[slotId];
            this.method_5447(slotId, class_1799.field_8037);
            return stack;
        }
        return class_1799.field_8037;
    }

    @NotNull
    public class_1799 method_5441(int slotId) {
        class_1799 returnStack = this.method_5438(slotId);
        this.method_5447(slotId, class_1799.field_8037);
        return returnStack;
    }

    public void method_5447(int slotId, @NotNull class_1799 stack) {
        if (this.okSlotId(slotId)) {
            this.contents[slotId] = stack;
            if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
            this.method_5431();
        }
    }

    public int method_5444() {
        return this.stackLimit < 1 ? super.method_5444() : this.stackLimit;
    }

    public void method_5431() {
        if (this.invOwner != null) {
            this.invOwner.method_5431();
        }
        if (this.callback != null) {
            this.callback.onInventoryChange(this.invOwner, this);
        }
    }

    public boolean inReachOf(class_1657 player) {
        return this.invOwner == null || player.method_5649((double)this.invOwner.method_11016().method_10263() + 0.5, (double)this.invOwner.method_11016().method_10264() + 0.5, (double)this.invOwner.method_11016().method_10260() + 0.5) <= 64.0;
    }

    public boolean blockUnchanged() {
        if (this.invOwner != null) {
            if (!this.invOwner.method_11015()) {
                class_1937 world = this.invOwner.method_10997();
                return world != null && world.method_8321(this.invOwner.method_11016()) == this.invOwner;
            }
            return false;
        }
        return true;
    }

    public boolean method_5443(class_1657 player) {
        boolean original;
        boolean bl = original = this.invOwner != null && this.blockUnchanged() && this.inReachOf(player);
        if (this.callback != null) {
            return this.callback.canInteractWith(this.invOwner, this, player, original);
        }
        return original;
    }

    public void method_5435(class_1657 player) {
        if (this.callback != null) {
            this.callback.onContainerOpen(this.invOwner, this, player);
        }
    }

    public void method_5432(class_1657 player) {
        if (this.callback != null) {
            this.callback.onContainerClosed(this.invOwner, this, player);
        }
    }

    public boolean method_5437(int slotId, class_1799 stack) {
        return stack != null && this.okSlotId(slotId);
    }

    public void method_5448() {
        Arrays.fill(this.contents, class_1799.field_8037);
    }

    public class_2561 method_5477() {
        return this.displayName;
    }

    public boolean method_16914() {
        return false;
    }

    @Nullable
    public class_2561 method_5797() {
        return null;
    }
}

