/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.class_1657;
import net.minecraft.class_1767;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.internal.Configuration;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.internal.Values;

public class RGB16 {
    private byte vRed = 0;
    private byte vGreen = 0;
    private byte vBlue = 0;

    public RGB16() {
        this(RGB16Helper.getRandomValues());
    }

    public RGB16(int red, int green, int blue) {
        this(new byte[]{(byte)red, (byte)green, (byte)blue});
    }

    public RGB16(short rgbIndex) {
        this(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public RGB16(String colorName) {
        this(RGB16Helper.getBaseValuesFrom(colorName));
    }

    private RGB16(byte[] values) {
        this.setValues(values[0], values[1], values[2]);
    }

    public boolean setRandomValues() {
        return this.setValues(RGB16Helper.getRandomValues());
    }

    public boolean setValues(int red, int green, int blue) {
        return this.setValues(RGB16Helper.clamp(red, green, blue));
    }

    public boolean setValues(short rgbIndex) {
        return this.setValues(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public boolean setValues(String colorName) {
        return this.setValues(RGB16Helper.getBaseValuesFrom(colorName));
    }

    private boolean setValues(byte[] values) {
        if (this.vRed != values[0] || this.vGreen != values[1] || this.vBlue != values[2]) {
            this.vRed = values[0];
            this.vGreen = values[1];
            this.vBlue = values[2];
            return true;
        }
        return false;
    }

    public boolean recolor(class_1657 player, String colorName) {
        if (player != null) {
            int mode;
            int n = mode = player.field_6002.method_8608() ? ShetiPhianCore.CONFIG.CLIENT.color_blend_mode.ordinal() : PlayerConfigs.getConfig(player, Values.CONFIGKEY_COLOR_BLEND_MODE, Configuration.ClientFile.BlendMode.RYB.ordinal()).intValue();
            if (mode == Configuration.ClientFile.BlendMode.RYB.ordinal()) {
                return player.method_5715() ? this.setValues(colorName) : this.blend(colorName);
            }
            return player.method_5715() ? this.subtract(colorName) : this.add(colorName);
        }
        return false;
    }

    public boolean add(int red, int green, int blue) {
        int nRed = this.vRed + red;
        int nGreen = this.vGreen + green;
        int nBlue = this.vBlue + blue;
        if (!(red == green && red == blue || nRed <= 15 && nGreen <= 15 && nBlue <= 15)) {
            int over = Math.max(nRed - 15, Math.max(nGreen - 15, nBlue - 15));
            nRed -= over;
            nGreen -= over;
            nBlue -= over;
        }
        return this.setValues(nRed, nGreen, nBlue);
    }

    public boolean subtract(int red, int green, int blue) {
        return this.setValues(this.vRed - red, this.vGreen - green, this.vBlue - blue);
    }

    public boolean add(String colorName) {
        byte[] values = RGB16Helper.getAdjustValuesFrom(colorName);
        return this.add(values[0], values[1], values[2]);
    }

    public boolean subtract(String colorName) {
        byte[] values = RGB16Helper.getAdjustValuesFrom(colorName);
        return this.subtract(values[0], values[1], values[2]);
    }

    public boolean blend(String colorName) {
        return RGB16Helper.blend(this, colorName);
    }

    public byte[] getValues() {
        return new byte[]{this.vRed, this.vGreen, this.vBlue};
    }

    public short getIndex() {
        return (short)(this.vRed * 256 + this.vGreen * 16 + this.vBlue);
    }

    public int getColor() {
        return -16777216 + (this.vRed * 17 << 16) + (this.vGreen * 17 << 8) + this.vBlue * 17;
    }

    public byte getSimpleColor() {
        return RGB16Helper.getSimpleColor(this.getIndex());
    }

    public class_1767 getDyeColor() {
        return class_1767.method_7791((int)this.getSimpleColor());
    }

    public String getTooltip() {
        return "\u00a7c" + this.vRed + "\u00a7a" + this.vGreen + "\u00a79" + this.vBlue;
    }

    public String toString() {
        return "R:" + this.vRed + "-G:" + this.vGreen + "-B:" + this.vBlue;
    }
}

