/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import shetiphian.core.common.events.BonemealCallback;
import shetiphian.core.common.events.PlayerCraftingCallback;
import shetiphian.core.common.network.PacketPipeline;
import shetiphian.core.internal.Configuration;
import shetiphian.core.internal.EventHandler;
import shetiphian.core.internal.Roster;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.teams.PacketTeamSync;
import shetiphian.core.internal.teams.TeamCommand;
import shetiphian.core.internal.teams.TeamHelper;

public class ShetiPhianCore
implements ModInitializer {
    public static final String MOD_ID = "shetiphiancore";
    public static ShetiPhianCore INSTANCE;
    public static Logger LOGGER;
    public static Configuration CONFIG;
    static boolean loadTeams;

    public ShetiPhianCore() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
    }

    public void onInitialize() {
        Roster.process();
        AutoConfig.register(Configuration.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = (Configuration)AutoConfig.getConfigHolder(Configuration.class).getConfig();
        ServerLifecycleEvents.SERVER_STARTING.register(ShetiPhianCore::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(ShetiPhianCore::serverStopped);
        ServerWorldEvents.LOAD.register(ShetiPhianCore::worldLoaded);
        TeamCommand.registerArguments();
        CommandRegistrationCallback.EVENT.register(EventHandler::registerCommands);
        BonemealCallback.EVENT.register(EventHandler::onApplyBonemeal);
        PlayerCraftingCallback.EVENT.register(EventHandler::onItemCrafted);
        UseBlockCallback.EVENT.register(EventHandler::playerRightClickBlock);
        NetworkHandler.initialise();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> NetworkHandler.sendToPlayer(new PacketTeamSync(TeamHelper.getTeam((class_1657)handler.field_14140), (class_1657)handler.field_14140), handler.field_14140));
    }

    private static void serverStarting(MinecraftServer server) {
        PacketPipeline.ACTIVE_SERVER = server;
        loadTeams = true;
        EventHandler.setupVillagerTradeOffers();
    }

    private static void serverStopped(MinecraftServer server) {
        PacketPipeline.ACTIVE_SERVER = null;
    }

    private static void worldLoaded(MinecraftServer server, class_3218 serverWorld) {
        class_3218 world;
        if (loadTeams && server != null && (world = server.method_3847(class_1937.field_25179)) != null) {
            TeamHelper.load(server, world);
            loadTeams = false;
        }
    }

    static {
        CONFIG = new Configuration();
        loadTeams = false;
    }
}

