/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class HelperMethods {
    public static class_1297 getTargetedEntity(class_1297 user, int range) {
        class_238 searchBox;
        class_243 userView;
        class_243 rayCastEnd;
        class_243 rayCastOrigin = user.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)user, (class_243)rayCastOrigin, (class_243)(rayCastEnd = rayCastOrigin.method_1019(userView = user.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchBox = user.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && target instanceof class_1309, (double)(range * range));
        if (hitResult != null) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static boolean isWalking(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !player.method_29504() && (player.method_5681() || player.method_18798().method_37267() > 0.1);
        }
        return false;
    }

    public static boolean checkFriendlyFire(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, player)) {
            return false;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            if (playerEntity == player) {
                return false;
            }
            return playerEntity.method_7256(player);
        }
        return true;
    }

    public static boolean checkEntityBlacklist(class_1309 livingEntity, class_1657 player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        return !(livingEntity instanceof class_1531) && !(livingEntity instanceof class_1646) && !(livingEntity instanceof BattleStandardEntity) && !(livingEntity instanceof BattleStandardDarkEntity);
    }

    public static void spawnParticle(class_1937 world, class_2394 particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.field_9236) {
            world.method_8406(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.1);
        }
    }

    public static void playHitSounds(class_1309 attacker, class_1309 target) {
        if (!attacker.field_6002.method_8608()) {
            class_3218 world = (class_3218)attacker.field_6002;
            boolean impactsounds_enabled = SimplySwordsConfig.getBooleanValue("enable_weapon_impact_sounds");
            float impactsounds_volume = SimplySwordsConfig.getGeneralSettings("impact_sound_effect_volume");
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
                if (choose_sound <= 40 && choose_sound > 30) {
                    world.method_43129(null, (class_1297)target, (class_3414)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), class_3419.field_15248, impactsounds_volume, 1.1f + choose_pitch);
                }
            }
        }
    }

    public static String chooseRunicPower() {
        List<String> runicList = Arrays.asList("active_defence", "float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "frost_ward", "wildfire", "unstable", "momentum", "greater_momentum", "imbued", "greater_imbued", "pincushion", "greater_pincushion", "ward", "immolation");
        for (int i = 0; i < 100; ++i) {
            Random choose = new Random();
            int randomIndex = choose.nextInt(runicList.size());
            String runicSelection = runicList.get(randomIndex);
            if (!SimplySwordsConfig.getBooleanValue(runicSelection)) continue;
            return runicSelection;
        }
        return "";
    }

    public static String chooseRunefusedPower() {
        List<String> runicList = Arrays.asList("float", "greater_float", "freeze", "shielding", "greater_shielding", "slow", "greater_slow", "stoneskin", "greater_stoneskin", "swiftness", "greater_swiftness", "trailblaze", "greater_trailblaze", "weaken", "greater_weaken", "zephyr", "greater_zephyr", "wildfire", "imbued", "greater_imbued", "pincushion", "greater_pincushion");
        for (int i = 0; i < 100; ++i) {
            Random choose = new Random();
            int randomIndex = choose.nextInt(runicList.size());
            String runicSelection = runicList.get(randomIndex);
            if (!SimplySwordsConfig.getBooleanValue(runicSelection)) continue;
            return runicSelection;
        }
        return "";
    }

    public static String chooseNetherfusedPower() {
        List<String> runicList = Arrays.asList("echo", "berserk", "radiance", "onslaught", "nullification");
        Random choose = new Random();
        int randomIndex = choose.nextInt(runicList.size());
        return runicList.get(randomIndex);
    }

    public static boolean isUniqueTwohanded(class_1799 stack) {
        return stack.method_31574((class_1792)ItemsRegistry.SOULPYRE.get()) || stack.method_31574((class_1792)ItemsRegistry.SOULKEEPER.get()) || stack.method_31574((class_1792)ItemsRegistry.TWISTED_BLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.HEARTHFLAME.get()) || stack.method_31574((class_1792)ItemsRegistry.SOULRENDER.get()) || stack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get()) || stack.method_31574((class_1792)ItemsRegistry.BRIMSTONE_CLAYMORE.get()) || stack.method_31574((class_1792)ItemsRegistry.ICEWHISPER.get()) || stack.method_31574((class_1792)ItemsRegistry.ARCANETHYST.get()) || stack.method_31574((class_1792)ItemsRegistry.THUNDERBRAND.get()) || stack.method_31574((class_1792)ItemsRegistry.WATCHER_CLAYMORE.get());
    }

    public static void createFootfalls(class_1297 entity, class_1799 stack, class_1937 world, int stepMod, class_2400 particle, class_2400 sprintParticle, class_2400 passiveParticle, boolean passiveParticles) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (SimplySwordsConfig.getBooleanValue("enable_weapon_footfalls")) {
                if (player.method_6118(class_1304.field_6173) == stack && HelperMethods.isWalking((class_1297)player) && !player.method_5681() && player.method_24828()) {
                    if (stepMod == 6) {
                        if (player.method_5624()) {
                            world.method_8406((class_2394)sprintParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406((class_2394)particle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    } else if (stepMod == 3) {
                        if (player.method_5624()) {
                            world.method_8406((class_2394)sprintParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        } else {
                            world.method_8406((class_2394)particle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.2, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (player.method_6118(class_1304.field_6173) == stack && passiveParticles && SimplySwordsConfig.getBooleanValue("enable_passive_particles")) {
                    float randomy = (float)Math.random();
                    if (stepMod == 1) {
                        world.method_8406((class_2394)passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)passiveParticle, player.method_23317() - player.method_40123(stack.method_7909()).method_10216() + 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() - player.method_40123(stack.method_7909()).method_10215() - 0.1, 0.0, 0.0, 0.0);
                    } else if (stepMod == 4) {
                        world.method_8406((class_2394)passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216(), player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + 0.4 + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215(), 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)passiveParticle, player.method_23317() + player.method_40123(stack.method_7909()).method_10216() - 0.1, player.method_23318() + player.method_40123(stack.method_7909()).method_10214() + (double)randomy, player.method_23321() + player.method_40123(stack.method_7909()).method_10215() + 0.1, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }
}

