/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import de.dafuqs.revelationary.api.advancements.ClientAdvancementPacketCallback;
import de.dafuqs.revelationary.api.revelations.RevealingCallback;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.patchouli.PatchouliFlags;
import de.dafuqs.spectrum.compat.patchouli.PatchouliPages;
import de.dafuqs.spectrum.entity.SpectrumEntityRenderers;
import de.dafuqs.spectrum.helpers.TooltipHelper;
import de.dafuqs.spectrum.inventories.SpectrumContainers;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketReceiver;
import de.dafuqs.spectrum.particle.SpectrumParticleFactories;
import de.dafuqs.spectrum.progression.UnlockToastManager;
import de.dafuqs.spectrum.progression.toast.RevelationToast;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumModelLayers;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumTooltipComponents;
import de.dafuqs.spectrum.registries.client.SpectrumArmorRenderers;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import de.dafuqs.spectrum.registries.client.SpectrumItemPredicates;
import de.dafuqs.spectrum.render.HudRenderers;
import de.dafuqs.spectrum.render.SkyLerper;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SpectrumClient
implements ClientModInitializer,
RevealingCallback,
ClientAdvancementPacketCallback {
    @Environment(value=EnvType.CLIENT)
    public static final SkyLerper skyLerper = new SkyLerper();
    public static boolean foodEffectsTooltipsModLoaded = FabricLoader.getInstance().isModLoaded("foodeffecttooltips");

    public void onInitializeClient() {
        SpectrumCommon.logInfo("Starting Client Startup");
        SpectrumCommon.logInfo("Registering Model Layers...");
        SpectrumModelLayers.register();
        SpectrumCommon.logInfo("Setting up Block Rendering...");
        SpectrumBlocks.registerClient();
        SpectrumCommon.logInfo("Setting up Fluid Rendering...");
        SpectrumFluids.registerClient();
        SpectrumCommon.logInfo("Setting up GUIs...");
        SpectrumContainers.register();
        SpectrumScreenHandlerTypes.registerClient();
        SpectrumCommon.logInfo("Setting up ItemPredicates...");
        SpectrumItemPredicates.registerClient();
        SpectrumCommon.logInfo("Setting up Block Entity Renderers...");
        SpectrumBlockEntities.registerClient();
        SpectrumCommon.logInfo("Setting up Entity Renderers...");
        SpectrumEntityRenderers.registerClient();
        SpectrumCommon.logInfo("Registering Server to Client Package Receivers...");
        SpectrumS2CPacketReceiver.registerS2CReceivers();
        SpectrumCommon.logInfo("Registering Particle Factories...");
        SpectrumParticleFactories.register();
        SpectrumCommon.logInfo("Registering Overlays...");
        HudRenderers.register();
        SpectrumCommon.logInfo("Registering Item Tooltips...");
        SpectrumTooltipComponents.registerTooltipComponents();
        SpectrumCommon.logInfo("Registering custom Patchouli Pages & Flags...");
        PatchouliPages.register();
        PatchouliFlags.register();
        SpectrumCommon.logInfo("Registering Event Listeners...");
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraftClient -> SpectrumColorProviders.registerClient());
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            if (!foodEffectsTooltipsModLoaded && stack.method_19267() && class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836().equals("spectrum")) {
                TooltipHelper.addFoodComponentEffectTooltip(stack, lines);
            }
            if (stack.method_31573(SpectrumItemTags.COMING_SOON_TOOLTIP)) {
                lines.add(class_2561.method_43471((String)"spectrum.tooltip.coming_soon"));
            }
        });
        SpectrumCommon.logInfo("Registering Armor Renderers...");
        SpectrumArmorRenderers.register();
        RevealingCallback.register((RevealingCallback)this);
        ClientAdvancementPacketCallback.registerCallback((ClientAdvancementPacketCallback)this);
        SpectrumCommon.logInfo("Client startup completed!");
    }

    public void trigger(Set<class_2960> advancements, Set<class_2248> blocks, Set<class_1792> items, boolean isJoinPacket) {
        if (!isJoinPacket) {
            for (class_2248 block : blocks) {
                if (!class_2378.field_11146.method_10221((Object)block).method_12836().equals("spectrum")) continue;
                RevelationToast.showRevelationToast(class_310.method_1551(), new class_1799((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST.method_8389()), SpectrumSoundEvents.NEW_REVELATION);
                break;
            }
        }
    }

    public void onClientAdvancementPacket(Set<class_2960> gottenAdvancements, Set<class_2960> removedAdvancements, boolean isJoinPacket) {
        if (!isJoinPacket) {
            UnlockToastManager.processAdvancements(gottenAdvancements);
        }
    }
}

