/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum;

import com.google.common.collect.ImmutableMap;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.blocks.mob_blocks.FirestarterMobBlock;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlock;
import de.dafuqs.spectrum.config.SpectrumConfig;
import de.dafuqs.spectrum.data_loaders.EntityFishingDataLoader;
import de.dafuqs.spectrum.data_loaders.ResonanceDropsDataLoader;
import de.dafuqs.spectrum.deeper_down.DDDimension;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.SpectrumPositionSources;
import de.dafuqs.spectrum.inventories.SpectrumContainers;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.items.magic_items.BottomlessBundleItem;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.magic_items.RadianceStaffItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.items.trinkets.WhispyCircletItem;
import de.dafuqs.spectrum.loot.SpectrumLootConditionTypes;
import de.dafuqs.spectrum.loot.SpectrumLootPoolModifiers;
import de.dafuqs.spectrum.mixin.accessors.RecipeManagerAccessor;
import de.dafuqs.spectrum.networking.SpectrumC2SPacketReceiver;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipeSerializer;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockSoundGroups;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumCommands;
import de.dafuqs.spectrum.registries.SpectrumComposting;
import de.dafuqs.spectrum.registries.SpectrumCustomRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumFlammableBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumItemGroups;
import de.dafuqs.spectrum.registries.SpectrumItemStackDamageImmunities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumMusicType;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import de.dafuqs.spectrum.registries.SpectrumResourceConditions;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.spells.InkSpellEffects;
import de.dafuqs.spectrum.worldgen.SpectrumConfiguredFeatures;
import de.dafuqs.spectrum.worldgen.SpectrumFeatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2746;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpectrumCommon
implements ModInitializer {
    public static final String MOD_ID = "spectrum";
    public static final class_2746 LIQUID_CRYSTAL_LOGGED = class_2746.method_11825((String)"liquidcrystallogged");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Spectrum");
    public static SpectrumConfig CONFIG;
    public static class_5321<class_1937> DEEPER_DOWN;
    public static MinecraftServer minecraftServer;
    public static HashMap<class_3611, Integer> fluidLuminance;

    public static void logInfo(String message) {
        LOGGER.info("[Spectrum] " + message);
    }

    public static void logWarning(String message) {
        LOGGER.warn("[Spectrum] " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[Spectrum] " + message);
    }

    public static class_2960 locate(String name) {
        return new class_2960(MOD_ID, name);
    }

    public void onInitialize() {
        SpectrumCommon.logInfo("Starting Common Startup");
        SpectrumCommon.logInfo("Loading config file...");
        AutoConfig.register(SpectrumConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SpectrumConfig)AutoConfig.getConfigHolder(SpectrumConfig.class).getConfig();
        SpectrumCommon.logInfo("Finished loading config file.");
        InkColors.register();
        SpectrumCommon.logInfo("Registering Banner Patterns...");
        SpectrumBannerPatterns.register();
        SpectrumCommon.logInfo("Registering Block / Item Color Registries...");
        ColorRegistry.registerColorRegistries();
        SpectrumCommon.logInfo("Registering Status Effects...");
        SpectrumStatusEffects.register();
        SpectrumStatusEffectTags.register();
        SpectrumCommon.logInfo("Registering Advancement Criteria...");
        SpectrumAdvancementCriteria.register();
        SpectrumCommon.logInfo("Registering Particle Types...");
        SpectrumParticleTypes.register();
        SpectrumCommon.logInfo("Registering Sound Events...");
        SpectrumSoundEvents.register();
        SpectrumCommon.logInfo("Registering Music...");
        SpectrumMusicType.register();
        SpectrumCommon.logInfo("Registering BlockSound Groups...");
        SpectrumBlockSoundGroups.register();
        SpectrumCommon.logInfo("Registering Fluids...");
        SpectrumFluids.register();
        SpectrumCommon.logInfo("Registering Blocks...");
        SpectrumBlocks.register();
        SpectrumCommon.logInfo("Registering Items...");
        SpectrumPotions.register();
        SpectrumItems.register();
        SpectrumCommon.logInfo("Registering Block Entities...");
        SpectrumBlockEntities.register();
        SpectrumCommon.logInfo("Registering Worldgen Features...");
        SpectrumFeatures.register();
        SpectrumCommon.logInfo("Registering Configured and Placed Features...");
        SpectrumConfiguredFeatures.register();
        SpectrumCommon.logInfo("Registering Dimension...");
        DDDimension.register();
        SpectrumCommon.logInfo("Registering Recipe Types...");
        SpectrumRecipeTypes.registerSerializer();
        SpectrumCommon.logInfo("Registering Loot Conditions...");
        SpectrumLootConditionTypes.register();
        SpectrumCommon.logInfo("Registering Containers...");
        SpectrumContainers.register();
        SpectrumCommon.logInfo("Registering Screen Handler Types...");
        SpectrumScreenHandlerTypes.register();
        SpectrumCommon.logInfo("Registering Default Item Stack Damage Immunities...");
        SpectrumItemStackDamageImmunities.registerDefaultItemStackImmunities();
        SpectrumCommon.logInfo("Registering Enchantment Drops...");
        SpectrumLootPoolModifiers.setup();
        SpectrumCommon.logInfo("Registering Items to Fuel Registry...");
        SpectrumItems.registerFuelRegistry();
        SpectrumCommon.logInfo("Registering Enchantments...");
        SpectrumEnchantments.register();
        SpectrumCommon.logInfo("Registering Entity Types...");
        SpectrumEntityTypes.register();
        SpectrumCommon.logInfo("Registering Commands...");
        SpectrumCommands.register();
        SpectrumCommon.logInfo("Registering Client To ServerPackage Receivers...");
        SpectrumC2SPacketReceiver.registerC2SReceivers();
        SpectrumCommon.logInfo("Registering Data Loaders...");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)ResonanceDropsDataLoader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)EntityFishingDataLoader.INSTANCE);
        SpectrumCommon.logInfo("Registering Flammable Blocks...");
        SpectrumFlammableBlocks.register();
        SpectrumCommon.logInfo("Registering Compostable Blocks...");
        SpectrumComposting.register();
        SpectrumCommon.logInfo("Registering Game Events...");
        SpectrumGameEvents.register();
        SpectrumPositionSources.register();
        SpectrumCommon.logInfo("Registering Spell Effects...");
        InkSpellEffects.register();
        SpectrumCommon.logInfo("Initializing Item Groups...");
        SpectrumItemGroups.ITEM_GROUP_GENERAL.initialize();
        SpectrumItemGroups.ITEM_GROUP_BLOCKS.initialize();
        SpectrumCommon.logInfo("Registering Special Recipes...");
        SpectrumCustomRecipeSerializers.registerRecipeSerializers();
        SpectrumCommon.logInfo("Registering Dispenser Behaviors...");
        class_2315.method_10009((class_1935)SpectrumItems.BOTTOMLESS_BUNDLE, (class_2357)new BottomlessBundleItem.BottomlessBundlePlacementDispenserBehavior());
        class_2315.method_10009((class_1935)SpectrumBlocks.COLORFUL_SHOOTING_STAR.method_8389(), (class_2357)new ShootingStarBlock.ShootingStarBlockDispenserBehavior());
        class_2315.method_10009((class_1935)SpectrumBlocks.FIERY_SHOOTING_STAR.method_8389(), (class_2357)new ShootingStarBlock.ShootingStarBlockDispenserBehavior());
        class_2315.method_10009((class_1935)SpectrumBlocks.GEMSTONE_SHOOTING_STAR.method_8389(), (class_2357)new ShootingStarBlock.ShootingStarBlockDispenserBehavior());
        class_2315.method_10009((class_1935)SpectrumBlocks.GLISTERING_SHOOTING_STAR.method_8389(), (class_2357)new ShootingStarBlock.ShootingStarBlockDispenserBehavior());
        class_2315.method_10009((class_1935)SpectrumBlocks.PRISTINE_SHOOTING_STAR.method_8389(), (class_2357)new ShootingStarBlock.ShootingStarBlockDispenserBehavior());
        SpectrumCommon.logInfo("Registering Resource Conditions...");
        SpectrumResourceConditions.register();
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!world.field_9236 && !player.method_7325()) {
                class_1799 mainHandStack = player.method_6047();
                if (mainHandStack.method_31574(SpectrumItems.EXCHANGING_STAFF)) {
                    Optional<class_2248> blockTarget = ExchangeStaffItem.getBlockTarget(player.method_6047());
                    blockTarget.ifPresent(block -> ExchangeStaffItem.exchange(world, pos, player, block, player.method_6047(), true));
                    return class_1269.field_5812;
                }
                if (mainHandStack.method_31574(SpectrumItems.RADIANCE_STAFF) && !world.method_8320(pos).method_27852(SpectrumBlocks.WAND_LIGHT_BLOCK)) {
                    class_2338 targetPos = pos.method_10093(direction);
                    if (((RadianceStaffItem)mainHandStack.method_7909()).placeLight(world, targetPos, (class_3222)player)) {
                        player.method_7357().method_7906(SpectrumItems.RADIANCE_STAFF, 10);
                        RadianceStaffItem.playSoundAndParticles(world, targetPos, (class_3222)player, world.field_9229.method_43048(5), world.field_9229.method_43048(5));
                    } else {
                        RadianceStaffItem.playDenySound(world, player);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                SpectrumAdvancementCriteria.BLOCK_BROKEN.trigger(serverPlayerEntity, state);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SpectrumCommon.logInfo("Fetching server instance...");
            minecraftServer = server;
            SpectrumCommon.logInfo("Registering MultiBlocks...");
            SpectrumMultiblocks.register();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            minecraftServer = null;
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            long timeOfDay;
            if (world.method_8510() % 100L == 0L && (timeOfDay = world.method_8532() % 24000L) > 13000L && timeOfDay < 22000L && SpectrumCommon.CONFIG.ShootingStarWorlds.contains(world.method_27983().method_29177().toString())) {
                ShootingStarEntity.doShootingStarSpawnsForPlayers(world);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SpectrumCommon.logInfo("Querying fluid luminance...");
            Iterator it = class_2378.field_11146.method_10220().iterator();
            while (it.hasNext()) {
                class_2248 block = (class_2248)it.next();
                if (!(block instanceof class_2404)) continue;
                class_2404 fluidBlock = (class_2404)block;
                fluidLuminance.put(fluidBlock.method_9545(fluidBlock.method_9564()).method_15772(), fluidBlock.method_9564().method_26213());
            }
            SpectrumCommon.logInfo("Injecting additional recipes...");
            FirestarterMobBlock.addBlockSmeltingRecipes(server.method_3772());
            this.injectEnchantmentUpgradeRecipes(server);
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && (serverPlayerEntity = (class_3222)entity).method_7297() == 100 && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.WHISPY_CIRCLET)) {
                entity.method_6033(entity.method_6063());
                WhispyCircletItem.removeNegativeStatusEffects(entity);
            }
        });
        SpectrumCommon.logInfo("Registering RecipeCache reload listener");
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = SpectrumCommon.locate("compacting_cache_clearer");

            public void method_14491(class_3300 manager) {
                CompactingChestBlockEntity.clearCache();
                if (minecraftServer != null) {
                    SpectrumCommon.this.injectEnchantmentUpgradeRecipes(minecraftServer);
                    FirestarterMobBlock.addBlockSmeltingRecipes(minecraftServer.method_3772());
                }
            }

            public class_2960 getFabricId() {
                return this.id;
            }
        });
        SpectrumCommon.logInfo("Common startup completed!");
    }

    public void injectEnchantmentUpgradeRecipes(MinecraftServer minecraftServer) {
        if (!EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.isEmpty()) {
            ImmutableMap collectedRecipes = (ImmutableMap)EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.stream().collect(ImmutableMap.toImmutableMap(GatedSpectrumRecipe::method_8114, enchantmentUpgradeRecipe -> enchantmentUpgradeRecipe));
            Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes = ((RecipeManagerAccessor)minecraftServer.method_3772()).getRecipes();
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Map<class_2960, class_1860<?>> r : recipes.values()) {
                newList.addAll(r.values());
            }
            for (class_1860 recipe : collectedRecipes.values()) {
                if (newList.contains(recipe)) continue;
                newList.add(recipe);
            }
            minecraftServer.method_3772().method_20702(newList);
        }
    }

    static {
        DEEPER_DOWN = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(MOD_ID, "deeper_down"));
        fluidLuminance = new HashMap();
    }
}

