/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks;

import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4970;

public abstract class InWorldInteractionBlock
extends class_2237 {
    protected InWorldInteractionBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        InWorldInteractionBlock.scatterContents(world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!world.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            class_1799 remainingStack = this.inputStack(world, pos, itemEntity.method_6983());
            if (remainingStack.method_7960()) {
                itemEntity.method_5650(class_1297.class_5529.field_26999);
            } else {
                itemEntity.method_6979(remainingStack);
            }
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public static void scatterContents(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_1263) {
            class_1263 inventory = (class_1263)blockEntity;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)inventory);
            world.method_8455(pos, block);
        }
    }

    public class_1799 inputStack(class_1937 world, class_2338 pos, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof InWorldInteractionBlockEntity) {
            InWorldInteractionBlockEntity inWorldInteractionBlockEntity = (InWorldInteractionBlockEntity)blockEntity;
            int previousCount = itemStack.method_7947();
            class_1799 remainingStack = InventoryHelper.smartAddToInventory(itemStack, inWorldInteractionBlockEntity, null);
            if (remainingStack.method_7947() != previousCount) {
                inWorldInteractionBlockEntity.method_5431();
                inWorldInteractionBlockEntity.updateInClientWorld(world, pos);
                world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
            }
            return remainingStack;
        }
        return itemStack;
    }

    public boolean exchangeStack(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 handStack, InWorldInteractionBlockEntity blockEntity) {
        return this.exchangeStack(world, pos, player, hand, handStack, blockEntity, 0);
    }

    public boolean exchangeStack(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 handStack, InWorldInteractionBlockEntity blockEntity, int slot) {
        boolean itemsChanged = false;
        if (player.method_5715()) {
            class_1799 retrievedStack = blockEntity.method_5441(slot);
            if (!retrievedStack.method_7960()) {
                player.method_7270(retrievedStack);
                itemsChanged = true;
            }
        } else {
            class_1799 currentStack = blockEntity.method_5438(slot);
            if (!handStack.method_7960() && !currentStack.method_7960()) {
                blockEntity.method_5447(slot, handStack);
                player.method_6122(hand, currentStack);
                itemsChanged = true;
            } else {
                if (!handStack.method_7960()) {
                    class_1799 remainingStack = InventoryHelper.setOrCombineStack(blockEntity, slot, handStack);
                    player.method_6122(hand, remainingStack);
                    itemsChanged = true;
                }
                if (!currentStack.method_7960()) {
                    blockEntity.method_5447(slot, class_1799.field_8037);
                    player.method_7270(currentStack);
                    itemsChanged = true;
                }
            }
        }
        if (itemsChanged) {
            world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
        }
        return itemsChanged;
    }

    public boolean retrieveStack(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 handStack, InWorldInteractionBlockEntity blockEntity, int slot) {
        class_1799 retrievedStack = blockEntity.method_5441(slot);
        if (retrievedStack.method_7960()) {
            return false;
        }
        if (player.method_5998(hand).method_7960()) {
            player.method_6122(hand, retrievedStack);
        } else {
            Support.givePlayer(player, retrievedStack);
        }
        world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
        return true;
    }

    public boolean retrieveLastStack(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 handStack, InWorldInteractionBlockEntity blockEntity) {
        for (int i = blockEntity.method_5439() - 1; i >= 0; --i) {
            if (!this.retrieveStack(world, pos, player, hand, handStack, blockEntity, i)) continue;
            return true;
        }
        return false;
    }

    public boolean inputHandStack(class_1937 world, class_1657 player, class_1268 hand, class_1799 handStack, InWorldInteractionBlockEntity blockEntity) {
        int previousCount = handStack.method_7947();
        class_1799 remainingStack = InventoryHelper.smartAddToInventory(handStack, blockEntity, null);
        if (remainingStack.method_7947() != previousCount) {
            player.method_6122(hand, remainingStack);
            world.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
            return true;
        }
        return false;
    }
}

