/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.block_flooder;

import com.google.common.collect.ImmutableList;
import de.dafuqs.spectrum.blocks.block_flooder.BlockFlooderBlockEntity;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_4864;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BlockFlooderBlock
extends class_2237 {
    public static final HashMap<class_6862<class_2248>, class_2248> exchangeableBlocks = new HashMap<class_6862<class_2248>, class_2248>(){
        {
            this.put(class_3481.field_29822, class_2246.field_10566);
            this.put(class_3481.field_25806, class_2246.field_10340);
            this.put(class_3481.field_25807, class_2246.field_10515);
            this.put(class_3481.field_15466, class_2246.field_10102);
        }
    };
    public static final List<class_6862<class_2248>> exchangeBlockTags = ImmutableList.copyOf(exchangeableBlocks.keySet());
    public short MAX_DISTANCE = (short)10;
    public class_2680 DEFAULT_BLOCK_STATE = class_2246.field_10445.method_9564();

    public BlockFlooderBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public static boolean isReplaceableBlock(class_1937 world, class_2338 blockPos) {
        class_2680 state = world.method_8320(blockPos);
        class_2248 block = state.method_26204();
        return world.method_8321(blockPos) == null && !(block instanceof BlockFlooderBlock) && (state.method_26215() || block instanceof class_2404 || state.method_26207().method_15800() || block instanceof class_4864 || block instanceof class_2356);
    }

    public static boolean isValidCornerBlock(class_1937 world, class_2338 blockPos) {
        class_2680 state = world.method_8320(blockPos);
        class_2248 block = state.method_26204();
        return state.method_26212((class_1922)world, blockPos) || block instanceof class_2404 || block instanceof BlockFlooderBlock;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            world.method_39279(pos, state.method_26204(), 4);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockFlooderBlockEntity(pos, state);
    }

    private boolean calculateTargetBlockAndPropagate(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BlockFlooderBlockEntity) {
            BlockFlooderBlockEntity blockFlooderBlockEntity = (BlockFlooderBlockEntity)blockEntity;
            class_1657 owner = PlayerOwned.getPlayerEntityIfOnline(blockFlooderBlockEntity.getOwnerUUID());
            if (owner == null) {
                world.method_8652(pos, this.DEFAULT_BLOCK_STATE, 3);
                return false;
            }
            HashMap<class_2248, Integer> neighboringBlockAmounts = new HashMap<class_2248, Integer>();
            for (class_2350 direction : class_2350.values()) {
                class_2338 targetBlockPos = pos.method_10093(direction);
                class_2680 currentBlockState = world.method_8320(targetBlockPos);
                class_2586 currentBlockEntity = world.method_8321(targetBlockPos);
                if (currentBlockState.method_27852((class_2248)this) || currentBlockEntity != null) continue;
                if (BlockFlooderBlock.isReplaceableBlock(world, targetBlockPos)) {
                    class_2382 nextPos = new class_2382(targetBlockPos.method_10093(direction).method_10263(), targetBlockPos.method_10093(direction).method_10264(), targetBlockPos.method_10093(direction).method_10260());
                    if (!blockFlooderBlockEntity.getSourcePos().method_19771(nextPos, (double)this.MAX_DISTANCE) || !this.shouldPropagateTo(world, targetBlockPos)) continue;
                    world.method_8652(targetBlockPos, state, 3);
                    class_2586 class_25862 = world.method_8321(targetBlockPos);
                    if (!(class_25862 instanceof BlockFlooderBlockEntity)) continue;
                    BlockFlooderBlockEntity neighboringBlockFlooderBlockEntity = (BlockFlooderBlockEntity)class_25862;
                    neighboringBlockFlooderBlockEntity.setOwnerUUID(blockFlooderBlockEntity.getOwnerUUID());
                    neighboringBlockFlooderBlockEntity.setSourcePos(blockFlooderBlockEntity.getSourcePos());
                    continue;
                }
                class_2248 currentBlock = currentBlockState.method_26204();
                if (!currentBlockState.method_26212((class_1922)world, targetBlockPos)) continue;
                if (neighboringBlockAmounts.containsKey(currentBlock)) {
                    neighboringBlockAmounts.put(currentBlock, (Integer)neighboringBlockAmounts.get(currentBlock) + 1);
                    continue;
                }
                neighboringBlockAmounts.put(currentBlock, 1);
            }
            if (neighboringBlockAmounts.size() > 0) {
                int max = 0;
                class_2248 maxBlock = null;
                for (Map.Entry entry : neighboringBlockAmounts.entrySet()) {
                    class_2248 currentBlock = (class_2248)entry.getKey();
                    int currentOccurrences = (Integer)entry.getValue();
                    class_1792 blockItem = currentBlock.method_8389();
                    if (blockItem == class_1802.field_8162 || currentOccurrences <= max && (currentOccurrences != max || !random.method_43056())) continue;
                    class_1799 currentItemStack = new class_1799((class_1935)blockItem);
                    if (owner.method_7337() || owner.method_31548().method_7379(currentItemStack) && currentBlock.method_9558(currentBlock.method_9564(), (class_4538)world, pos)) {
                        maxBlock = currentBlock;
                        continue;
                    }
                    Optional<class_6862<class_2248>> tag = Support.getFirstMatchingBlockTag(currentBlock.method_9564(), exchangeBlockTags);
                    if (!tag.isPresent() || (blockItem = (currentBlock = exchangeableBlocks.get(tag.get())).method_8389()) == class_1802.field_8162) continue;
                    currentItemStack = new class_1799((class_1935)blockItem);
                    if (!owner.method_7337() && (!owner.method_31548().method_7379(currentItemStack) || !currentBlock.method_9558(currentBlock.method_9564(), (class_4538)world, pos))) continue;
                    maxBlock = currentBlock;
                }
                if (maxBlock != null) {
                    blockFlooderBlockEntity.setTargetBlockState(maxBlock.method_9564());
                } else {
                    blockFlooderBlockEntity.setTargetBlockState(this.DEFAULT_BLOCK_STATE);
                }
            }
        }
        return true;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        super.method_9588(state, world, pos, random);
        if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof BlockFlooderBlockEntity) {
            BlockFlooderBlockEntity blockFlooderBlockEntity = (BlockFlooderBlockEntity)class_25862;
            class_2680 targetState = blockFlooderBlockEntity.getTargetBlockState();
            if (targetState == null || targetState.method_26215()) {
                boolean scheduleUpdate = this.calculateTargetBlockAndPropagate(state, (class_1937)world, pos, world.method_8409());
                if (scheduleUpdate) {
                    world.method_39279(pos, state.method_26204(), 2 + random.method_43048(5));
                }
            } else {
                world.method_8652(pos, targetState, 3);
                class_1657 owner = PlayerOwned.getPlayerEntityIfOnline(blockFlooderBlockEntity.getOwnerUUID());
                if (!owner.method_7337()) {
                    List<class_1799> remainders = InventoryHelper.removeFromInventoryWithRemainders(new class_1799((class_1935)targetState.method_26204().method_8389()), (class_1263)owner.method_31548());
                    for (class_1799 remainder : remainders) {
                        owner.method_7270(remainder);
                    }
                }
            }
        }
    }

    private boolean shouldPropagateTo(class_1937 world, class_2338 targetBlockPos) {
        if (BlockFlooderBlock.isReplaceableBlock(world, targetBlockPos)) {
            int count = 0;
            block0: for (class_2350 direction : class_2350.values()) {
                for (int i = 1; i < this.MAX_DISTANCE / 2; ++i) {
                    class_2338 offsetPos = targetBlockPos.method_10079(direction, i);
                    if (!BlockFlooderBlock.isValidCornerBlock(world, offsetPos)) continue;
                    ++count;
                    continue block0;
                }
            }
            return count >= 4;
        }
        return false;
    }
}

