/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.crystallarieum;

import de.dafuqs.spectrum.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumBlockEntity
extends class_2621
implements PlayerOwned,
InkStorageBlockEntity<IndividualCappedInkStorage> {
    protected static final int INVENTORY_SIZE = 2;
    protected static final int INK_PROVIDER_STACK_SLOT_ID = 0;
    protected static final int CATALYST_SLOT_ID = 1;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    public static final long INK_STORAGE_SIZE = 409600L;
    protected IndividualCappedInkStorage inkStorage = new IndividualCappedInkStorage(409600L);
    protected boolean inkDirty;
    @Nullable
    protected UUID ownerUUID;
    @Nullable
    protected CrystallarieumRecipe currentRecipe;
    protected CrystallarieumCatalyst currentCatalyst;
    protected int currentGrowthStageDuration;
    protected boolean canWork = true;

    public CrystallarieumBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.CRYSTALLARIEUM, pos, state);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, CrystallarieumBlockEntity crystallarieum) {
        int amount;
        if (crystallarieum.canWork && crystallarieum.currentRecipe != null && (amount = crystallarieum.currentRecipe.getInkPerSecond()) > 0) {
            class_2394 particleEffect = SpectrumParticleTypes.getSparkleRisingParticle(crystallarieum.currentRecipe.getInkColor().getDyeColor());
            if (amount > 199 || Support.getIntFromDecimalWithChance((double)amount / 200.0, world.field_9229) > 0) {
                double randomX = world.method_8409().method_43058() * 0.8;
                double randomZ = world.method_8409().method_43058() * 0.8;
                world.method_8406(particleEffect, (double)blockPos.method_10263() + 0.1 + randomX, (double)(blockPos.method_10264() + 1), (double)blockPos.method_10260() + 0.1 + randomZ, 0.0, 0.03, 0.0);
            }
        }
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, CrystallarieumBlockEntity crystallarieum) {
        if (world.method_8510() % 20L == 0L && crystallarieum.canWork && crystallarieum.currentRecipe != null) {
            if (crystallarieum.currentCatalyst == null) {
                if (!crystallarieum.currentRecipe.growsWithoutCatalyst()) {
                    return;
                }
                consumedInk = crystallarieum.currentRecipe.getInkPerSecond();
                if (crystallarieum.inkStorage.drainEnergy(crystallarieum.currentRecipe.getInkColor(), consumedInk) < (long)consumedInk) {
                    crystallarieum.canWork = false;
                    crystallarieum.setInkDirty();
                    crystallarieum.updateInClientWorld();
                    return;
                }
                crystallarieum.setInkDirty();
                crystallarieum.currentGrowthStageDuration += 20;
            } else {
                consumedInk = (int)Math.ceil((float)crystallarieum.currentRecipe.getInkPerSecond() * crystallarieum.currentCatalyst.inkConsumptionMod);
                if (crystallarieum.inkStorage.drainEnergy(crystallarieum.currentRecipe.getInkColor(), consumedInk) < (long)consumedInk) {
                    crystallarieum.canWork = false;
                    crystallarieum.setInkDirty();
                    crystallarieum.updateInClientWorld();
                    return;
                }
                crystallarieum.setInkDirty();
                crystallarieum.currentGrowthStageDuration = (int)((float)crystallarieum.currentGrowthStageDuration + 20.0f * crystallarieum.currentCatalyst.growthAccelerationMod);
                if (world.field_9229.method_43057() < crystallarieum.currentCatalyst.consumeChancePerSecond) {
                    class_1799 catalystStack = crystallarieum.method_5438(1);
                    catalystStack.method_7934(1);
                    if (catalystStack.method_7960()) {
                        crystallarieum.currentCatalyst = null;
                        if (!crystallarieum.currentRecipe.growsWithoutCatalyst()) {
                            crystallarieum.canWork = false;
                        }
                    }
                }
            }
            if (crystallarieum.currentGrowthStageDuration >= crystallarieum.currentRecipe.getSecondsPerGrowthStage() * 20) {
                class_2338 topPos = blockPos.method_10084();
                class_2680 topState = world.method_8320(topPos);
                Iterator<class_2680> it = crystallarieum.currentRecipe.getGrowthStages().iterator();
                while (it.hasNext()) {
                    class_2680 state = it.next();
                    if (!state.equals(topState) || !it.hasNext()) continue;
                    class_2680 targetState = it.next();
                    world.method_8501(topPos, targetState);
                    if (targetState.method_26164(SpectrumBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE)) {
                        world.method_33596(null, SpectrumGameEvents.CRYSTAL_APOTHECARY_HARVESTABLE_GROWN, topPos);
                    }
                    if (it.hasNext()) continue;
                    crystallarieum.canWork = false;
                    crystallarieum.updateInClientWorld();
                }
                crystallarieum.currentGrowthStageDuration = 0;
            }
        }
    }

    public void method_11014(class_2487 nbt) {
        Object t;
        Optional optionalRecipe;
        String recipeString;
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        if (nbt.method_10573("InkStorage", 10)) {
            this.inkStorage = IndividualCappedInkStorage.fromNbt(nbt.method_10562("InkStorage"));
        }
        this.currentGrowthStageDuration = nbt.method_10568("CraftingTime");
        this.canWork = nbt.method_10577("CanWork");
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        this.currentRecipe = null;
        if (nbt.method_10545("CurrentRecipe") && !(recipeString = nbt.method_10558("CurrentRecipe")).isEmpty() && this.field_11863 != null && (optionalRecipe = this.field_11863.method_8433().method_8130(new class_2960(recipeString))).isPresent() && (t = optionalRecipe.get()) instanceof CrystallarieumRecipe) {
            CrystallarieumRecipe crystallarieumRecipe;
            this.currentRecipe = crystallarieumRecipe = (CrystallarieumRecipe)t;
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10566("InkStorage", (class_2520)this.inkStorage.toNbt());
        nbt.method_10575("CraftingTime", (short)this.currentGrowthStageDuration);
        nbt.method_10556("CanWork", this.canWork);
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.spectrum.crystallarieum");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    public int method_5439() {
        return 2;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    @Nullable
    public CrystallarieumRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void acceptStack(class_1799 itemStack, boolean creative) {
        CrystallarieumRecipe recipe;
        if (this.field_11863.method_8320(this.field_11867.method_10084()).method_26215() && (recipe = CrystallarieumRecipe.getRecipeForStack(itemStack)) != null) {
            if (!creative) {
                itemStack.method_7934(1);
            }
            class_2680 placedState = recipe.getGrowthStages().get(0);
            this.field_11863.method_8501(this.field_11867.method_10084(), placedState);
            this.onTopBlockChange(placedState, recipe);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + this.field_11863.field_9229.method_43057() * 0.6f);
            return;
        }
        if (this.currentRecipe != null) {
            class_1799 currentCatalystStack = this.method_5438(1);
            if (currentCatalystStack.method_7960()) {
                Optional<CrystallarieumCatalyst> optionalCatalyst = this.currentRecipe.getCatalyst(itemStack);
                if (optionalCatalyst.isPresent()) {
                    this.method_5447(1, itemStack.method_7972());
                    if (!creative) {
                        itemStack.method_7939(0);
                    }
                    this.currentCatalyst = optionalCatalyst.get();
                    this.canWork = true;
                    this.updateInClientWorld();
                    this.method_5431();
                }
            } else if (class_1799.method_31577((class_1799)currentCatalystStack, (class_1799)itemStack)) {
                InventoryHelper.combineStacks(currentCatalystStack, itemStack);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.8f + this.field_11863.field_9229.method_43057() * 0.6f);
                this.canWork = true;
                this.updateInClientWorld();
                this.method_5431();
            }
        }
    }

    public class_1799 popCatalyst() {
        class_1799 catalystStack = this.method_5438(1);
        this.method_5447(1, class_1799.field_8037);
        this.currentCatalyst = null;
        this.updateInClientWorld();
        return catalystStack;
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    public void onTopBlockChange(class_2680 newState, @Nullable CrystallarieumRecipe recipe) {
        if (newState.method_26215()) {
            this.currentRecipe = null;
            this.canWork = false;
            this.method_5431();
            this.updateInClientWorld();
        } else {
            this.currentRecipe = recipe == null ? CrystallarieumRecipe.getRecipeForState(newState) : recipe;
            class_1799 catalystStack = this.method_5438(1);
            if (!catalystStack.method_7960()) {
                Optional<CrystallarieumCatalyst> newCatalyst = this.currentRecipe.getCatalyst(catalystStack);
                if (newCatalyst.isPresent()) {
                    this.currentCatalyst = newCatalyst.get();
                } else {
                    this.currentCatalyst = null;
                    class_1542 itemEntity = new class_1542(this.field_11863, (double)this.method_11016().method_10263() + 0.5, (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260() + 0.5, catalystStack);
                    this.method_5447(1, class_1799.field_8037);
                    this.field_11863.method_8649((class_1297)itemEntity);
                }
            }
            this.canWork = true;
            this.method_5431();
            this.updateInClientWorld();
        }
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }
}

