/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.decay;

import de.dafuqs.spectrum.blocks.decay.DecayAwayBlock;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

public abstract class DecayBlock
extends class_2248 {
    protected final List<class_6862<class_2248>> decayConversionsList = new ArrayList<class_6862<class_2248>>();
    protected final HashMap<class_6862<class_2248>, class_2680> decayConversions = new HashMap();
    protected final class_6862<class_2248> whiteListBlockTag;
    protected final class_6862<class_2248> blackListBlockTag;
    protected final float damageOnTouching;
    protected final int tier;

    public DecayBlock(class_4970.class_2251 settings, class_6862<class_2248> whiteListBlockTag, class_6862<class_2248> blackListBlockTag, int tier, float damageOnTouching) {
        super(settings);
        this.whiteListBlockTag = whiteListBlockTag;
        this.blackListBlockTag = blackListBlockTag;
        this.damageOnTouching = damageOnTouching;
        this.tier = tier;
    }

    public void addDecayConversion(class_6862<class_2248> sourceBlockTag, class_2680 conversionState) {
        this.decayConversionsList.add(sourceBlockTag);
        this.decayConversions.put(sourceBlockTag, conversionState);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (entity instanceof class_1309 && !entity.method_5753() && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(SpectrumDamageSources.DECAY, this.damageOnTouching);
        }
        super.method_9591(world, pos, state, entity);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return super.method_9558(state, world, pos) && pos.method_10264() > world.method_31607();
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.canSpread(state)) {
            float spreadChance = this.getSpreadChance();
            if (spreadChance < 1.0f && random.method_43057() > spreadChance) {
                return;
            }
            class_2350 randomDirection = class_2350.method_10162((class_5819)random);
            this.tryConvert((class_1937)world, state, pos, randomDirection);
        }
    }

    protected boolean tryConvert(@NotNull class_1937 world, class_2680 state, @NotNull class_2338 originPos, class_2350 direction) {
        class_2586 blockEntity;
        class_2338 targetBlockPos = originPos.method_10093(direction);
        class_2680 targetBlockState = world.method_8320(targetBlockPos);
        if (this.method_9558(targetBlockState, (class_4538)world, targetBlockPos) && (blockEntity = world.method_8321(targetBlockPos)) == null && !targetBlockState.method_26164(SpectrumBlockTags.DECAY) && (this.whiteListBlockTag == null || targetBlockState.method_26164(this.whiteListBlockTag)) && (this.blackListBlockTag == null || !targetBlockState.method_26164(this.blackListBlockTag)) && (targetBlockState.method_26204() == class_2246.field_9987 || targetBlockState.method_26204().method_36555() > -1.0f && targetBlockState.method_26204().method_9520() < 10000.0f)) {
            class_2680 destinationBlockState = this.getSpreadState(state);
            for (class_6862<class_2248> currentCheckTag : this.decayConversionsList) {
                class_2680 targetState = this.decayConversions.get(currentCheckTag);
                if (!targetBlockState.method_26164(currentCheckTag)) continue;
                destinationBlockState = targetState;
                break;
            }
            world.method_8501(targetBlockPos, destinationBlockState);
            return true;
        }
        return false;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 previousBlock, class_2338 fromPos, boolean notify) {
        class_2680 updatedBlockState;
        class_2248 updatedBlock;
        super.method_9612(state, world, pos, previousBlock, fromPos, notify);
        if (previousBlock == class_2246.field_10124 && !((updatedBlock = (updatedBlockState = world.method_8320(fromPos)).method_26204()) instanceof DecayBlock) && !(updatedBlock instanceof DecayAwayBlock) && this.canSpread(state)) {
            for (class_6862<class_2248> blockTag : this.decayConversionsList) {
                if (!updatedBlockState.method_26164(blockTag)) continue;
                world.method_39280(pos, (class_2248)this, 40 + world.field_9229.method_43048(200), class_1953.field_9311);
            }
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        block1: {
            class_2350 direction;
            boolean converted;
            this.method_9514(state, world, pos, random);
            if (!this.canSpread(state)) break block1;
            ArrayList<class_2350> directions = new ArrayList<class_2350>(List.of(class_2350.values()));
            Collections.shuffle(directions);
            Iterator iterator = directions.iterator();
            while (iterator.hasNext() && !(converted = this.tryConvert((class_1937)world, state, pos, direction = (class_2350)iterator.next()))) {
            }
        }
    }

    protected abstract float getSpreadChance();

    protected abstract boolean canSpread(class_2680 var1);

    protected abstract class_2680 getSpreadState(class_2680 var1);
}

