/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.energy;

import de.dafuqs.spectrum.enums.ProgressionStage;
import de.dafuqs.spectrum.events.SpectrumGameEvents;
import de.dafuqs.spectrum.events.listeners.BlockPosEventQueue;
import de.dafuqs.spectrum.events.listeners.EventQueue;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.interfaces.PlayerOwnedWithName;
import de.dafuqs.spectrum.inventories.GenericSpectrumContainerScreenHandler;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3737;
import net.minecraft.class_47;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;

public class CrystalApothecaryBlockEntity
extends class_2621
implements PlayerOwnedWithName,
EventQueue.Callback {
    public static final Map<class_2680, class_3545<class_1792, Integer>> UNLOADED_COMPENSATION_MAP = new HashMap<class_2680, class_3545<class_1792, Integer>>(){
        {
            this.put(class_2246.field_27160.method_9564(), new class_3545((Object)class_1802.field_27063, (Object)2));
            this.put(SpectrumBlocks.BUDDING_TOPAZ.method_9564(), new class_3545((Object)SpectrumItems.TOPAZ_SHARD, (Object)2));
            this.put(SpectrumBlocks.BUDDING_CITRINE.method_9564(), new class_3545((Object)SpectrumItems.CITRINE_SHARD, (Object)2));
            this.put(SpectrumBlocks.BUDDING_ONYX.method_9564(), new class_3545((Object)SpectrumItems.ONYX_SHARD, (Object)2));
            this.put(SpectrumBlocks.BUDDING_MOONSTONE.method_9564(), new class_3545((Object)SpectrumItems.MOONSTONE_SHARD, (Object)2));
        }
    };
    private static final int RANGE = 12;
    private static final class_1799 HARVEST_ITEMSTACK = class_1799.field_8037;
    private final BlockPosEventQueue blockPosEventTransferListener;
    protected long compensationWorldTime;
    private class_2371<class_1799> inventory;
    private boolean listenerPaused;
    private UUID ownerUUID;
    private String ownerName;

    public CrystalApothecaryBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SpectrumBlockEntities.CRYSTAL_APOTHECARY, blockPos, blockState);
        this.blockPosEventTransferListener = new BlockPosEventQueue((class_5716)new class_5707(this.field_11867), 12, (EventQueue.Callback)this);
        this.inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
        this.listenerPaused = false;
        this.compensationWorldTime = -1L;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CrystalApothecaryBlockEntity blockEntity) {
        if (!world.field_9236) {
            blockEntity.blockPosEventTransferListener.tick(world);
            if (world.method_8510() % 1000L == 0L) {
                blockEntity.listenerPaused = false;
            }
            if (blockEntity.compensationWorldTime > 0L) {
                long compensationTicks = world.method_8510() - blockEntity.compensationWorldTime;
                if (compensationTicks > 1200L) {
                    CrystalApothecaryBlockEntity.compensateGemstoneClusterDropsForUnloadedTicks(world, pos, blockEntity, compensationTicks);
                }
                blockEntity.compensationWorldTime = -1L;
            }
        }
    }

    private static void compensateGemstoneClusterDropsForUnloadedTicks(class_1937 world, class_2338 blockPos, CrystalApothecaryBlockEntity blockEntity, long ticksToCompensate) {
        HashMap<class_2680, Integer> matches = new HashMap<class_2680, Integer>();
        Set<class_2680> compensationBlocks = UNLOADED_COMPENSATION_MAP.keySet();
        for (class_2338 pos : class_2338.method_25996((class_2338)blockPos, (int)12, (int)12, (int)12)) {
            class_2680 state = world.method_8320(pos);
            if (!compensationBlocks.contains(state)) continue;
            int validBlocks = CrystalApothecaryBlockEntity.countValidGemstoneClusterBlocksAroundBlockPos(world, pos);
            if (matches.containsKey(state)) {
                matches.put(state, (Integer)matches.get(state) + validBlocks);
                continue;
            }
            matches.put(state, validBlocks);
        }
        float theoreticallyGrownClustersPerBlock = (float)((class_1928.class_4312)world.method_8450().method_20746(class_1928.field_19399)).method_20763() / 4096.0f * 0.05f * (float)ticksToCompensate;
        for (Map.Entry match : matches.entrySet()) {
            class_3545<class_1792, Integer> drop = UNLOADED_COMPENSATION_MAP.get(match.getKey());
            float theoreticallyGrownClusters = theoreticallyGrownClustersPerBlock * (float)((Integer)match.getValue()).intValue();
            float compensatedItemsCount = theoreticallyGrownClusters * (float)((Integer)drop.method_15441()).intValue() * (0.8f + world.field_9229.method_43057() * 0.4f);
            if (!(compensatedItemsCount >= 1.0f)) continue;
            class_1799 compensatedStack = ((class_1792)drop.method_15442()).method_7854();
            compensatedStack.method_7939((int)compensatedItemsCount);
            class_1799 remainingStack = InventoryHelper.smartAddToInventory(compensatedStack, (class_1263)blockEntity, null);
            if (remainingStack.method_7960()) continue;
            break;
        }
    }

    public static int countValidGemstoneClusterBlocksAroundBlockPos(class_1937 world, class_2338 blockPos) {
        int count = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2680 offsetState = world.method_8320(blockPos.method_10093(direction));
            if (!offsetState.method_26215() && offsetState.method_26204() != class_2246.field_10382 && !offsetState.method_26164(SpectrumBlockTags.GEMSTONE_BUDS)) continue;
            ++count;
        }
        return count;
    }

    protected class_2561 method_17823() {
        if (this.hasOwner()) {
            return class_2561.method_43471((String)"block.spectrum.crystal_apothecary").method_10852((class_2561)class_2561.method_43469((String)"container.spectrum.owned_by_player", (Object[])new Object[]{this.ownerName}));
        }
        return class_2561.method_43471((String)"block.spectrum.crystal_apothecary");
    }

    public BlockPosEventQueue getEventListener() {
        return this.blockPosEventTransferListener;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inventory);
        }
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        if (nbt.method_10545("ListenerPaused")) {
            this.listenerPaused = nbt.method_10577("ListenerPaused");
        }
        this.ownerName = nbt.method_10545("OwnerName") ? nbt.method_10558("OwnerName") : null;
        if (nbt.method_10545("LastWorldTime")) {
            this.compensationWorldTime = nbt.method_10537("LastWorldTime");
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.method_11286(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inventory);
        }
        nbt.method_10556("ListenerPaused", this.listenerPaused);
        if (this.field_11863 != null) {
            nbt.method_10544("LastWorldTime", this.field_11863.method_8510());
        }
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            nbt.method_10582("OwnerName", this.ownerName);
        }
    }

    public int method_5439() {
        return 27;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (stack.method_7960() && this.listenerPaused) {
            this.listenerPaused = false;
            this.harvestExistingClusters();
        }
        super.method_5447(slot, stack);
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return GenericSpectrumContainerScreenHandler.createGeneric9x3(syncId, playerInventory, (class_1263)this, ProgressionStage.MIDGAME);
    }

    @Override
    public boolean canAcceptEvent(class_1937 world, class_5714 listener, class_5712.class_7447 message, class_243 sourcePos) {
        return message.method_43724() == SpectrumGameEvents.CRYSTAL_APOTHECARY_HARVESTABLE_GROWN && !this.listenerPaused;
    }

    public void triggerEvent(class_1937 world, class_5714 listener, Object entry) {
        class_2338 eventPos;
        class_2680 eventState;
        if (listener instanceof BlockPosEventQueue && this.field_11863 != null && (eventState = world.method_8320(eventPos = ((BlockPosEventQueue.EventEntry)entry).eventSourceBlockPos)).method_26164(SpectrumBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE)) {
            class_2586 blockEntity = eventState.method_31709() ? this.field_11863.method_8321(eventPos) : null;
            class_47.class_48 builder = new class_47.class_48((class_3218)this.field_11863).method_311(this.field_11863.field_9229).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)eventPos)).method_312(class_181.field_1229, (Object)HARVEST_ITEMSTACK).method_306(class_181.field_1228, (Object)blockEntity);
            List drops = eventState.method_26189(builder);
            boolean anyDropsUsed = drops.size() == 0;
            for (class_1799 drop : drops) {
                class_1799 remainingStack;
                class_1657 owner;
                if (this.hasOwner() && (owner = this.getOwnerIfOnline()) instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)owner;
                    SpectrumAdvancementCriteria.CRYSTAL_APOTHECARY_COLLECTING.trigger(serverPlayerEntity, drop);
                }
                if (!(remainingStack = InventoryHelper.smartAddToInventory(drop, (class_1263)this, null)).method_7960() && drop.method_7947() == remainingStack.method_7947()) continue;
                anyDropsUsed = true;
            }
            if (anyDropsUsed) {
                world.method_20290(2001, eventPos, class_2248.method_9507((class_2680)eventState));
                if (eventState.method_26204() instanceof class_3737 && ((Boolean)eventState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    world.method_8501(eventPos, class_2246.field_10382.method_9564());
                } else {
                    world.method_8501(eventPos, class_2246.field_10124.method_9564());
                }
            } else {
                this.listenerPaused = true;
            }
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.ownerName = playerEntity.method_5477().getString();
    }

    public void harvestExistingClusters() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_2338 currPos : class_2338.method_25996((class_2338)this.field_11867, (int)12, (int)12, (int)12)) {
                if (!this.field_11863.method_8320(currPos).method_26164(SpectrumBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE)) continue;
                this.blockPosEventTransferListener.acceptEvent((class_1937)serverWorld, new class_5712.class_7447(SpectrumGameEvents.CRYSTAL_APOTHECARY_HARVESTABLE_GROWN, class_243.method_24953((class_2382)currPos), class_5712.class_7397.method_43287((class_2680)this.field_11863.method_8320(currPos)), (class_5714)this.blockPosEventTransferListener, class_243.method_24953((class_2382)this.field_11867)), class_243.method_24953((class_2382)this.field_11867));
            }
        }
    }
}

