/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fluid;

import de.dafuqs.spectrum.blocks.BlackMateriaBlock;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterBlockEntity;
import de.dafuqs.spectrum.blocks.fluid.SpectrumFluidBlock;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.fluid_converting.MidnightSolutionConvertingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumFluidTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class MidnightSolutionFluidBlock
extends SpectrumFluidBlock {
    public static final class_2680 SPREAD_BLOCKSTATE = (class_2680)SpectrumBlocks.BLACK_MATERIA.method_9564().method_11657((class_2769)BlackMateriaBlock.AGE, (Comparable)Integer.valueOf(0));
    private static final int EXPERIENCE_DISENCHANT_RETURN_DIV = 3;

    public MidnightSolutionFluidBlock(class_3609 fluid, class_4970.class_2251 settings) {
        super(fluid, settings);
    }

    @Override
    public class_2400 getSplashParticle() {
        return SpectrumParticleTypes.MIDNIGHT_SOLUTION_SPLASH;
    }

    @Override
    public class_3545<class_2400, class_2400> getFishingParticles() {
        return new class_3545((Object)SpectrumParticleTypes.GRAY_SPARKLE_RISING, (Object)SpectrumParticleTypes.MIDNIGHT_SOLUTION_FISHING);
    }

    public static boolean tryConvertNeighbor(@NotNull class_1937 world, class_2338 pos, class_2338 fromPos) {
        class_3610 fluidState = world.method_8316(fromPos);
        if (!fluidState.method_15769() && fluidState.method_15767(SpectrumFluidTags.MIDNIGHT_SOLUTION_CONVERTED)) {
            world.method_8501(fromPos, SpectrumBlocks.MIDNIGHT_SOLUTION.method_9564());
            MidnightSolutionFluidBlock.playExtinguishSound((class_1936)world, fromPos);
            return true;
        }
        return false;
    }

    public static void playExtinguishSound(@NotNull class_1936 world, class_2338 pos) {
        world.method_20290(1501, pos, 0);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (this.receiveNeighborFluids(world, pos, state)) {
            world.method_39281(pos, state.method_26227().method_15772(), this.field_11279.method_15789((class_4538)world));
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (this.receiveNeighborFluids(world, pos, state)) {
            world.method_39281(pos, state.method_26227().method_15772(), this.field_11279.method_15789((class_4538)world));
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (!world.field_9236) {
            class_1542 itemEntity;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!livingEntity.method_29504()) {
                    if (livingEntity.method_5777(SpectrumFluidTags.MIDNIGHT_SOLUTION) && world.method_8510() % 20L == 0L) {
                        livingEntity.method_6092(new class_1293(class_1294.field_5919, 50, 0));
                        livingEntity.method_5643(SpectrumDamageSources.MIDNIGHT_SOLUTION, 2.0f);
                    } else {
                        livingEntity.method_5643(SpectrumDamageSources.MIDNIGHT_SOLUTION, 1.0f);
                    }
                    if (livingEntity.method_29504()) {
                        livingEntity.method_5775(SpectrumItems.MIDNIGHT_CHIP.method_7854());
                    }
                }
            } else if (entity instanceof class_1542 && !(itemEntity = (class_1542)entity).method_6977()) {
                MidnightSolutionConvertingRecipe recipe;
                Map enchantments;
                class_1799 itemStack = itemEntity.method_6983();
                if ((itemStack.method_7942() || itemStack.method_31574(class_1802.field_8598)) && (enchantments = class_1890.method_8222((class_1799)itemStack)).size() > 0) {
                    int randomEnchantmentIndex = world.field_9229.method_43048(enchantments.size());
                    class_1887 enchantmentToRemove = (class_1887)enchantments.keySet().toArray()[randomEnchantmentIndex];
                    int experience = EnchanterBlockEntity.getEnchantingPrice(itemStack, enchantmentToRemove, (Integer)enchantments.get(enchantmentToRemove));
                    if ((experience /= 3) > 0) {
                        class_1303 experienceOrbEntity = new class_1303(world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), experience);
                        world.method_8649((class_1297)experienceOrbEntity);
                    }
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_16865, class_3419.field_15254, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, itemEntity.method_19538(), (class_2394)SpectrumParticleTypes.GRAY_SPARKLE_RISING, 10, class_243.field_1353, new class_243(0.2, 0.4, 0.2));
                    itemEntity.method_6979(SpectrumEnchantmentHelper.removeEnchantment(itemStack, enchantmentToRemove));
                    itemEntity.method_6988();
                    return;
                }
                if (!MidnightSolutionConvertingRecipe.isExistingOutputItem(itemStack) && (recipe = this.getConversionRecipeFor(SpectrumRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING, world, itemStack)) != null) {
                    world.method_8396(null, itemEntity.method_24515(), class_3417.field_14983, class_3419.field_15254, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
                    MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, itemEntity.method_19538(), recipe.method_8110(), recipe.method_8110().method_7947() * itemStack.method_7947(), class_243.field_1353);
                    itemEntity.method_31472();
                }
            }
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (!world.method_8320(pos.method_10084()).method_26212((class_1922)world, pos.method_10084()) && random.method_43057() < 0.03f) {
            world.method_8406((class_2394)SpectrumParticleTypes.VOID_FOG, (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), 0.0, random.method_43058() * 0.1, 0.0);
        }
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    private boolean receiveNeighborFluids(class_1937 world, class_2338 pos, class_2680 state) {
        for (class_2350 direction : class_2350.values()) {
            boolean neighborIsOtherFluid;
            class_2338 neighborPos = pos.method_10093(direction);
            if (world.method_8316(neighborPos).method_15767(class_3486.field_15518)) {
                world.method_8501(pos, class_2246.field_10415.method_9564());
                MidnightSolutionFluidBlock.playExtinguishSound((class_1936)world, pos);
                return false;
            }
            class_3610 neighborFluidState = world.method_8316(neighborPos);
            boolean bl = neighborIsOtherFluid = !neighborFluidState.method_15769() && !neighborFluidState.method_39360((class_3611)this.field_11279);
            if (!neighborIsOtherFluid || neighborFluidState.method_15767(SpectrumFluidTags.MIDNIGHT_SOLUTION_CONVERTED) || world.method_8320(neighborPos).method_27852((class_2248)this)) continue;
            world.method_8501(neighborPos, SPREAD_BLOCKSTATE);
            MidnightSolutionFluidBlock.playExtinguishSound((class_1936)world, neighborPos);
        }
        return true;
    }
}

