/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlock;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class FusionShrineBlock
extends InWorldInteractionBlock {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("collect_all_basic_pigments_besides_brown");
    public static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);
    protected static final class_265 SHAPE;

    public FusionShrineBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static void clearCurrentlyRenderedMultiBlock(class_1937 world) {
        IMultiblock currentlyRenderedMultiBlock;
        if (world.field_9236 && (currentlyRenderedMultiBlock = PatchouliAPI.get().getCurrentMultiblock()) != null && currentlyRenderedMultiBlock.getID().equals((Object)SpectrumMultiblocks.FUSION_SHRINE_IDENTIFIER)) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    public static boolean verifyStructureWithSkyAccess(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        if (!world.method_8320(blockPos.method_10084()).method_26215()) {
            world.method_8396(null, blockPos, SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
            return false;
        }
        if (!world.method_8311(blockPos)) {
            if (world.field_9236) {
                world.method_8406((class_2394)SpectrumParticleTypes.RED_SPARKLE_RISING, (double)blockPos.method_10263() + 0.5, (double)(blockPos.method_10264() + 1), (double)blockPos.method_10260() + 0.5, 0.0, 0.5, 0.0);
                class_310.method_1551().field_1724.method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
            }
            return false;
        }
        return FusionShrineBlock.verifyStructure(world, blockPos, serverPlayerEntity);
    }

    private static boolean verifyStructure(class_1937 world, class_2338 blockPos, @Nullable class_3222 serverPlayerEntity) {
        IMultiblock multiblock = SpectrumMultiblocks.MULTIBLOCKS.get(SpectrumMultiblocks.FUSION_SHRINE_IDENTIFIER);
        boolean valid = multiblock.validate(world, blockPos.method_10074(), class_2470.field_11467);
        if (valid) {
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.COMPLETED_MULTIBLOCK.trigger(serverPlayerEntity, multiblock);
            }
        } else if (world.field_9236) {
            IMultiblock currentMultiBlock = PatchouliAPI.get().getCurrentMultiblock();
            if (currentMultiBlock == multiblock) {
                PatchouliAPI.get().clearMultiblock();
            } else {
                PatchouliAPI.get().showMultiblock(multiblock, (class_2561)class_2561.method_43471((String)"multiblock.spectrum.fusion_shrine.structure"), blockPos.method_10087(2), class_2470.field_11467);
            }
        } else {
            FusionShrineBlock.scatterContents(world, blockPos);
        }
        return valid;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT_LEVEL});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FusionShrineBlockEntity(pos, state);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            FusionShrineBlock.clearCurrentlyRenderedMultiBlock((class_1937)world);
        }
    }

    @Override
    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (!world.field_9236 && entity.method_19538().field_1352 % 0.5 != 0.0 && entity.method_19538().field_1350 % 0.5 != 0.0) {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            FusionShrineBlock.verifyStructureWithSkyAccess(world, pos, null);
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof FusionShrineBlockEntity) {
            FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
            class_1799 handStack = player.method_5998(hand);
            class_1792 class_17922 = handStack.method_7909();
            if (class_17922 instanceof class_1755) {
                class_1755 bucketItem = (class_1755)class_17922;
                fusionShrineBlockEntity.setOwner(player);
                class_3611 storedFluid = fusionShrineBlockEntity.getFluid();
                class_3611 bucketFluid = ((BucketItemAccessor)bucketItem).fabric_getFluid();
                if (storedFluid == class_3612.field_15906 && bucketFluid != class_3612.field_15906) {
                    fusionShrineBlockEntity.setFluid(bucketFluid);
                    if (!player.method_7337()) {
                        handStack.method_7934(1);
                        player.method_6122(hand, handStack);
                        class_1792 remainderItem = bucketItem.method_7858();
                        if (remainderItem != null) {
                            player.method_7270(remainderItem.method_7854());
                        }
                    }
                    fusionShrineBlockEntity.inventoryChanged();
                    if (bucketFluid.method_32359().isPresent()) {
                        world.method_8396(null, player.method_24515(), (class_3414)bucketFluid.method_32359().get(), class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
                    }
                } else if (storedFluid != class_3612.field_15906 && bucketFluid == class_3612.field_15906) {
                    fusionShrineBlockEntity.setFluid(class_3612.field_15906);
                    if (!player.method_7337()) {
                        handStack.method_7934(1);
                        player.method_6122(hand, handStack);
                        player.method_7270(new class_1799((class_1935)storedFluid.method_15774()));
                    }
                    fusionShrineBlockEntity.inventoryChanged();
                    if (storedFluid.method_32359().isPresent()) {
                        world.method_8396(null, player.method_24515(), (class_3414)storedFluid.method_32359().get(), class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f);
                    }
                }
            } else if (player.method_5715() || handStack.method_7960()) {
                if (this.retrieveLastStack(world, pos, player, hand, handStack, fusionShrineBlockEntity)) {
                    fusionShrineBlockEntity.setOwner(player);
                }
            } else if (FusionShrineBlock.verifyStructure(world, pos, (class_3222)player) && !handStack.method_7960() && this.inputHandStack(world, player, hand, handStack, fusionShrineBlockEntity)) {
                fusionShrineBlockEntity.setOwner(player);
            }
        }
        return class_1269.field_21466;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return FusionShrineBlock.method_31618(type, SpectrumBlockEntities.FUSION_SHRINE, FusionShrineBlockEntity::clientTick);
        }
        return FusionShrineBlock.method_31618(type, SpectrumBlockEntities.FUSION_SHRINE, FusionShrineBlockEntity::serverTick);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_26204().equals((Object)this)) {
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    static {
        class_265 neck = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
        class_265 head = class_2248.method_9541((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        class_265 crystal = class_2248.method_9541((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)23.0, (double)9.5);
        neck = class_259.method_1084((class_265)neck, (class_265)head);
        SHAPE = class_259.method_1084((class_265)neck, (class_265)crystal);
    }
}

