/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlockEntity
extends InWorldInteractionBlockEntity
implements PlayerOwned,
Upgradeable {
    protected static final int INVENTORY_SIZE = 7;
    @NotNull
    protected class_3611 storedFluid = class_3612.field_15906;
    private UUID ownerUUID;
    private Map<Upgradeable.UpgradeType, Float> upgrades;
    private FusionShrineRecipe currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private boolean inventoryChanged = true;

    public FusionShrineBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.FUSION_SHRINE, pos, state, 7);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipe recipe;
        class_2400 particleEffect;
        Optional<class_1767> optionalItemColor;
        int randomSlot;
        class_1799 randomStack;
        if (!fusionShrineBlockEntity.method_5442() && !(randomStack = fusionShrineBlockEntity.method_5438(randomSlot = world.method_8409().method_43048(fusionShrineBlockEntity.method_5439()))).method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(randomStack.method_7909())).isPresent()) {
            particleEffect = SpectrumParticleTypes.getCraftingParticle(optionalItemColor.get());
            int particleAmount = (int)StrictMath.ceil((float)randomStack.method_7947() / 8.0f);
            for (int i = 0; i < particleAmount; ++i) {
                float randomX = 3.0f - world.method_8409().method_43057() * 7.0f;
                float randomZ = 3.0f - world.method_8409().method_43057() * 7.0f;
                world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.0, 0.0);
            }
        }
        if ((recipe = fusionShrineBlockEntity.currentRecipe) != null) {
            Optional<class_1767> optionalFluidColor;
            class_3611 fluid = fusionShrineBlockEntity.getFluid();
            if (recipe.getFluidInput().equals(fluid) && recipe.areConditionMetCurrently(world) && (optionalFluidColor = ColorRegistry.FLUID_COLORS.getMapping(fluid)).isPresent()) {
                particleEffect = SpectrumParticleTypes.getFluidRisingParticle(optionalFluidColor.get());
                float randomX = 0.25f + world.method_8409().method_43057() * 0.5f;
                float randomZ = 0.25f + world.method_8409().method_43057() * 0.5f;
                world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)(blockPos.method_10264() + 1), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.1, 0.0);
            }
        }
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipe recipe;
        if (fusionShrineBlockEntity.upgrades == null) {
            fusionShrineBlockEntity.calculateUpgrades();
        }
        if (fusionShrineBlockEntity.inventoryChanged) {
            FusionShrineRecipe previousRecipe = fusionShrineBlockEntity.currentRecipe;
            fusionShrineBlockEntity.currentRecipe = FusionShrineBlockEntity.calculateRecipe(world, fusionShrineBlockEntity);
            if (fusionShrineBlockEntity.currentRecipe != previousRecipe) {
                fusionShrineBlockEntity.craftingTime = 0;
                if (fusionShrineBlockEntity.currentRecipe == null) {
                    SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)world, fusionShrineBlockEntity.field_11867);
                } else {
                    fusionShrineBlockEntity.craftingTimeTotal = (int)Math.ceil((float)fusionShrineBlockEntity.currentRecipe.getCraftingTime() / fusionShrineBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.SPEED).floatValue());
                }
                fusionShrineBlockEntity.updateInClientWorld(world, blockPos);
            }
            fusionShrineBlockEntity.inventoryChanged = false;
        }
        if ((recipe = fusionShrineBlockEntity.currentRecipe) != null && recipe.getFluidInput().equals(fusionShrineBlockEntity.storedFluid)) {
            FusionShrineRecipeWorldEffect effect;
            if (fusionShrineBlockEntity.craftingTime % 60 == 0) {
                class_1657 lastInteractedPlayer = fusionShrineBlockEntity.getOwnerIfOnline();
                boolean recipeConditionsMet = recipe.canPlayerCraft(lastInteractedPlayer) && recipe.areConditionMetCurrently(world);
                boolean structureCompleteWithSky = FusionShrineBlock.verifyStructureWithSkyAccess(world, blockPos, null);
                if (!recipeConditionsMet || !structureCompleteWithSky) {
                    if (!structureCompleteWithSky) {
                        SpectrumS2CPacketSender.playParticleWithExactOffsetAndVelocity((class_3218)world, class_243.method_24953((class_2382)blockPos), (class_2394)SpectrumParticleTypes.RED_CRAFTING, 1, class_243.field_1353, new class_243(0.0, -0.5, 0.0));
                        world.method_8396(null, fusionShrineBlockEntity.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
                        world.method_8396(null, fusionShrineBlockEntity.method_11016(), class_3417.field_15197, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.5f + world.field_9229.method_43057() * 0.2f);
                        FusionShrineBlock.scatterContents(world, blockPos);
                        fusionShrineBlockEntity.inventoryChanged();
                    }
                    fusionShrineBlockEntity.craftingTime = 0;
                    return;
                }
            }
            ++fusionShrineBlockEntity.craftingTime;
            if (fusionShrineBlockEntity.craftingTime == 1 && fusionShrineBlockEntity.craftingTimeTotal > 1) {
                SpectrumS2CPacketSender.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING, (class_3218)world, fusionShrineBlockEntity.method_11016(), fusionShrineBlockEntity.craftingTimeTotal - fusionShrineBlockEntity.craftingTime);
            }
            if ((effect = recipe.getWorldEffectForTick(fusionShrineBlockEntity.craftingTime, fusionShrineBlockEntity.craftingTimeTotal)) != null) {
                effect.doEffect((class_3218)world, blockPos);
            }
            if (fusionShrineBlockEntity.craftingTime == fusionShrineBlockEntity.craftingTimeTotal) {
                FusionShrineBlockEntity.craft(world, blockPos, fusionShrineBlockEntity, recipe);
                fusionShrineBlockEntity.inventoryChanged();
            }
            fusionShrineBlockEntity.method_5431();
        }
    }

    @Nullable
    private static FusionShrineRecipe calculateRecipe(@NotNull class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        if (fusionShrineBlockEntity.currentRecipe != null && fusionShrineBlockEntity.currentRecipe.method_8115(fusionShrineBlockEntity, world)) {
            return fusionShrineBlockEntity.currentRecipe;
        }
        return world.method_8433().method_8132(SpectrumRecipeTypes.FUSION_SHRINE, (class_1263)fusionShrineBlockEntity, world).orElse(null);
    }

    private static void craft(class_1937 world, class_2338 blockPos, FusionShrineBlockEntity fusionShrineBlockEntity, FusionShrineRecipe recipe) {
        recipe.craft(world, fusionShrineBlockEntity);
        fusionShrineBlockEntity.setFluid(class_3612.field_15906);
        FusionShrineBlockEntity.scatterContents(world, blockPos.method_10084(), fusionShrineBlockEntity);
        SpectrumS2CPacketSender.sendPlayFusionCraftingFinishedParticles(world, blockPos, recipe.method_8110());
        fusionShrineBlockEntity.playSound(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING_FINISHED, 1.4f);
    }

    public Map<Upgradeable.UpgradeType, Float> getUpgrades() {
        return this.upgrades;
    }

    public static void scatterContents(class_1937 world, class_2338 pos, FusionShrineBlockEntity blockEntity) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.getItems());
        world.method_8455(pos, world.method_8320(pos).method_26204());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        Object t;
        Optional optionalRecipe;
        String recipeString;
        super.method_11014(nbt);
        this.storedFluid = (class_3611)class_2378.field_11154.method_10223(class_2960.method_12829((String)nbt.method_10558("fluid")));
        this.craftingTime = nbt.method_10568("CraftingTime");
        this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        this.currentRecipe = null;
        if (nbt.method_10545("CurrentRecipe") && !(recipeString = nbt.method_10558("CurrentRecipe")).isEmpty() && this.field_11863 != null && (optionalRecipe = this.field_11863.method_8433().method_8130(new class_2960(recipeString))).isPresent() && (t = optionalRecipe.get()) instanceof FusionShrineRecipe) {
            FusionShrineRecipe optionalFusionRecipe;
            this.currentRecipe = optionalFusionRecipe = (FusionShrineRecipe)t;
        }
        if (nbt.method_10573("Upgrades", 9)) {
            this.upgrades = Upgradeable.fromNbt(nbt.method_10554("Upgrades", 10));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("fluid", class_2378.field_11154.method_10221((Object)this.storedFluid).toString());
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)Upgradeable.toNbt(this.upgrades));
        }
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    public void playSound(class_3414 soundEvent, float volume) {
        class_5819 random = this.field_11863.field_9229;
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, volume, 0.9f + random.method_43057() * 0.15f);
    }

    public void grantPlayerFusionCraftingAdvancement(FusionShrineRecipe recipe, int experience) {
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.FUSION_SHRINE_CRAFTING.trigger(serverPlayerEntity, recipe.method_8110(), experience);
        }
    }

    @NotNull
    public class_3611 getFluid() {
        return this.storedFluid;
    }

    public void setFluid(@NotNull class_3611 fluid) {
        this.storedFluid = fluid;
        this.setLightForFluid(this.field_11863, this.field_11867, fluid);
        this.inventoryChanged();
    }

    public void setLightForFluid(class_1937 world, class_2338 blockPos, class_3611 fluid) {
        if (SpectrumCommon.fluidLuminance.containsKey(fluid)) {
            int light = SpectrumCommon.fluidLuminance.get(fluid);
            world.method_8652(blockPos, (class_2680)world.method_8320(blockPos).method_11657((class_2769)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 3);
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 2, 0, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public float getUpgradeValue(Upgradeable.UpgradeType upgradeType) {
        return this.upgrades.get((Object)upgradeType).floatValue();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.inventoryChanged = true;
        this.craftingTime = 0;
    }
}

