/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.memory;

import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.mixin.accessors.FoxEntityAccessor;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_3737;
import net.minecraft.class_4019;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MemoryBlockEntity
extends class_2586
implements PlayerOwned {
    protected class_1799 memoryItemStack = class_1799.field_8037;
    protected UUID ownerUUID;
    private int tint1 = -1;
    private int tint2 = -1;

    public MemoryBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.MEMORY, pos, state);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static class_3545<Integer, Integer> getEggColorsForEntity(class_1299 entityType) {
        class_1826 spawnEggItem = class_1826.method_8019((class_1299)entityType);
        if (spawnEggItem != null) {
            return new class_3545((Object)spawnEggItem.method_8016(0), (Object)spawnEggItem.method_8016(1));
        }
        return new class_3545((Object)0x222222, (Object)0xDDDDDD);
    }

    public static int getManifestAdvanceSteps(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2680 belowBlockState = world.method_8320(blockPos.method_10074());
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_NEVER_MANIFESTERS)) {
            return 0;
        }
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_VERY_FAST_MANIFESTERS)) {
            return 8;
        }
        if (belowBlockState.method_26164(SpectrumBlockTags.MEMORY_FAST_MANIFESTERS)) {
            return 3;
        }
        return 1;
    }

    public void setData(class_1309 livingEntity, @NotNull class_1799 creatureSpawnItemStack) {
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)livingEntity;
            this.setOwner(playerEntity);
        }
        if (creatureSpawnItemStack.method_7909() instanceof MemoryItem) {
            this.memoryItemStack = creatureSpawnItemStack.method_7972();
        }
        if (!livingEntity.field_6002.field_9236) {
            this.updateInClientWorld();
        }
        this.method_5431();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        if (nbt.method_10573("MemoryItem", 10)) {
            class_2487 creatureSpawnCompound = nbt.method_10562("MemoryItem");
            this.memoryItemStack = class_1799.method_7915((class_2487)creatureSpawnCompound);
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.memoryItemStack != null) {
            class_2487 creatureSpawnCompound = new class_2487();
            this.memoryItemStack.method_7953(creatureSpawnCompound);
            nbt.method_10566("MemoryItem", (class_2520)creatureSpawnCompound);
        }
    }

    public void advanceManifesting(class_3218 world, class_2338 blockPos) {
        int additionalManifestAdvanceSteps;
        int ticksToManifest = MemoryItem.getTicksToManifest(this.memoryItemStack.method_7969());
        if (ticksToManifest > 0 && (additionalManifestAdvanceSteps = MemoryBlockEntity.getManifestAdvanceSteps((class_1937)world, blockPos)) > 0) {
            int newTicksToManifest = ticksToManifest - additionalManifestAdvanceSteps;
            if (newTicksToManifest <= 0) {
                this.manifest(world, blockPos);
            } else {
                Optional<class_1299<?>> entityTypeOptional = MemoryItem.getEntityType(this.memoryItemStack.method_7969());
                if (entityTypeOptional.isPresent()) {
                    MemoryItem.setTicksToManifest(this.memoryItemStack, newTicksToManifest);
                    SpectrumS2CPacketSender.playMemoryManifestingParticles(world, blockPos, entityTypeOptional.get(), 3);
                    world.method_8396(null, this.field_11867, SpectrumSoundEvents.BLOCK_MEMORY_ADVANCE, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
                }
            }
        }
    }

    public void manifest(@NotNull class_3218 world, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26204() instanceof class_3737 && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_8501(blockPos, class_2246.field_10382.method_9564());
        } else {
            world.method_8501(blockPos, class_2246.field_10124.method_9564());
        }
        Optional<class_1297> hatchedEntity = this.hatchEntity(world, blockPos, this.memoryItemStack);
        if (hatchedEntity.isPresent()) {
            SpectrumS2CPacketSender.playMemoryManifestingParticles(world, blockPos, hatchedEntity.get().method_5864(), 10);
            class_1297 class_12972 = hatchedEntity.get();
            if (class_12972 instanceof class_1308) {
                class_1308 hatchedMobEntity = (class_1308)class_12972;
                hatchedMobEntity.method_5966();
                hatchedMobEntity.method_5990();
            }
            if (this.ownerUUID != null) {
                class_4019 foxEntity;
                class_1297 class_12973 = hatchedEntity.get();
                if (class_12973 instanceof class_1496) {
                    class_1496 horseBaseEntity = (class_1496)class_12973;
                    horseBaseEntity.method_6732(this.ownerUUID);
                } else {
                    class_12973 = hatchedEntity.get();
                    if (class_12973 instanceof class_4019) {
                        foxEntity = (class_4019)class_12973;
                        ((FoxEntityAccessor)foxEntity).invokeAddTrustedUuid(this.ownerUUID);
                    }
                }
                foxEntity = hatchedEntity.get();
                if (foxEntity instanceof class_1429) {
                    class_1429 animalEntity = (class_1429)foxEntity;
                    class_1657 player = this.getOwnerIfOnline();
                    if (player != null) {
                        animalEntity.method_6480(player);
                        animalEntity.method_6477();
                    }
                }
            }
            this.triggerManifestingAdvancementCriterion(hatchedEntity.get());
        }
    }

    protected void triggerManifestingAdvancementCriterion(class_1297 hatchedEntity) {
        class_1657 owner = this.getOwnerIfOnline();
        if (owner instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)owner;
            SpectrumAdvancementCriteria.MEMORY_MANIFESTING.trigger(serverPlayerEntity, hatchedEntity);
        }
    }

    public int getEggColor(int tintIndex) {
        if (this.tint1 == -1) {
            if (this.memoryItemStack == null) {
                this.tint1 = 0x222222;
                this.tint2 = 0xDDDDDD;
            } else {
                this.tint1 = MemoryItem.getEggColor(this.memoryItemStack.method_7969(), 0);
                this.tint2 = MemoryItem.getEggColor(this.memoryItemStack.method_7969(), 1);
            }
        }
        if (tintIndex == 0) {
            return this.tint1;
        }
        return this.tint2;
    }

    public void updateInClientWorld() {
        ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        this.method_11007(nbtCompound);
        return nbtCompound;
    }

    protected Optional<class_1297> hatchEntity(class_3218 world, class_2338 blockPos, class_1799 itemStack) {
        class_1297 entity;
        Optional<class_1299<?>> entityType;
        if (this.memoryItemStack.method_7909() instanceof MemoryItem && (entityType = MemoryItem.getEntityType(this.memoryItemStack.method_7969())).isPresent() && (entity = entityType.get().method_5894(world, this.memoryItemStack, null, blockPos, class_3730.field_16465, true, false)) != null) {
            if (entity instanceof class_1308) {
                class_1308 mobEntity = (class_1308)entity;
                mobEntity.method_7217(true);
                if (itemStack.method_7938()) {
                    mobEntity.method_5665(itemStack.method_7964());
                }
            }
            world.method_30771(entity);
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(@NotNull class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    public class_1799 getMemoryItemStack() {
        return this.memoryItemStack;
    }
}

