/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.memory;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryItem
extends class_1747 {
    private static final HashMap<class_1299, class_3545<Integer, Integer>> customColors = new HashMap<class_1299, class_3545<Integer, Integer>>(){
        {
            this.put(class_1299.field_6108, new class_3545((Object)4603179, (Object)1643271));
            this.put(class_1299.field_6047, new class_3545((Object)13224911, (Object)10645032));
            this.put(class_1299.field_6119, new class_3545((Object)0x101211, (Object)4079936));
            this.put(class_1299.field_6065, new class_3545((Object)2709389, (Object)4935247));
            this.put(class_1299.field_6116, new class_3545((Object)0x111111, (Object)8744079));
            this.put(class_1299.field_6147, new class_3545((Object)0x9A9A9A, (Object)9139300));
        }
    };

    public MemoryItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public static Optional<class_1299<?>> getEntityType(@Nullable class_2487 nbt) {
        class_2487 nbtCompound;
        if (nbt != null && nbt.method_10573("EntityTag", 10) && (nbtCompound = nbt.method_10562("EntityTag")).method_10573("id", 8)) {
            return class_1299.method_5898((String)nbtCompound.method_10558("id"));
        }
        return Optional.empty();
    }

    public static int getTicksToManifest(@Nullable class_2487 nbtCompound) {
        if (nbtCompound != null && nbtCompound.method_10573("TicksToManifest", 3)) {
            return nbtCompound.method_10550("TicksToManifest");
        }
        return -1;
    }

    public static void setTicksToManifest(@NotNull class_1799 itemStack, int newTicksToManifest) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null) {
            nbtCompound.method_10569("TicksToManifest", newTicksToManifest);
            itemStack.method_7980(nbtCompound);
        }
    }

    public static int getEggColor(class_2487 nbtCompound, int tintIndex) {
        if (nbtCompound == null || MemoryItem.isEntityTypeUnrecognizable(nbtCompound)) {
            if (tintIndex == 0) {
                return 0x222222;
            }
            return 0xDDDDDD;
        }
        Optional<class_1299<?>> entityType = MemoryItem.getEntityType(nbtCompound);
        if (entityType.isPresent()) {
            class_1299<?> type = entityType.get();
            if (customColors.containsKey(type)) {
                return tintIndex == 0 ? (Integer)customColors.get(type).method_15442() : (Integer)customColors.get(type).method_15441();
            }
            class_1826 spawnEggItem = class_1826.method_8019(entityType.get());
            if (spawnEggItem != null) {
                return spawnEggItem.method_8016(tintIndex);
            }
        }
        if (tintIndex == 0) {
            return 0x222222;
        }
        return 0xDDDDDD;
    }

    public static boolean isEntityTypeUnrecognizable(@Nullable class_2487 nbtCompound) {
        if (nbtCompound != null && nbtCompound.method_10545("Unrecognizable")) {
            return nbtCompound.method_10577("Unrecognizable");
        }
        return false;
    }

    public static void makeUnrecognizable(@NotNull class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7948();
        nbtCompound.method_10556("Unrecognizable", true);
        itemStack.method_7980(nbtCompound);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2487 nbt = stack.method_7969();
        Optional<class_1299<?>> entityType = MemoryItem.getEntityType(nbt);
        int ticksToHatch = MemoryItem.getTicksToManifest(nbt);
        if (entityType.isPresent()) {
            if (MemoryItem.isEntityTypeUnrecognizable(nbt)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.unrecognizable_entity_type").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.memory.tooltip.entity_type", (Object[])new Object[]{entityType.get().method_5897()}));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.unset_entity_type").method_27692(class_124.field_1080));
            return;
        }
        if (ticksToHatch <= 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.does_not_manifest").method_27692(class_124.field_1080));
        } else if (ticksToHatch > 100) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.extra_long_time_to_manifest").method_27692(class_124.field_1080));
        } else if (ticksToHatch > 20) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.long_time_to_manifest").method_27692(class_124.field_1080));
        } else if (ticksToHatch > 5) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.medium_time_to_manifest").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.memory.tooltip.short_time_to_manifest").method_27692(class_124.field_1080));
        }
    }
}

