/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network;

import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkConnectionNode;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkProviderNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkPullerNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkPusherNodeBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNetworkStorageNodeBlockEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1937;

public class PastelNetwork {
    protected static List<PastelNetwork> networks = new ArrayList<PastelNetwork>();
    protected HashSet<PastelNetworkConnectionNode> pastelNetworkConnectionNodes = new HashSet();
    protected HashSet<PastelNetworkStorageNodeBlockEntity> pastelNetworkStorageNodes = new HashSet();
    protected HashSet<PastelNetworkProviderNodeBlockEntity> pastelNetworkProviderNodeBlockEntities = new HashSet();
    protected HashSet<PastelNetworkPusherNodeBlockEntity> pastelNetworkPusherNodes = new HashSet();
    protected HashSet<PastelNetworkPullerNodeBlockEntity> pastelNetworkPullerNodes = new HashSet();
    protected String name;
    List<String> networkNames = List.of("Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "My", "Ny", "Xi", "Omikron", "Pi", "Rho", "Sigma", "Tau", "Ypsilon", "Phi", "Chi", "Psi", "Omeg");

    public PastelNetwork(class_1937 world) {
        this.name = this.networkNames.get(world.field_9229.method_43048(this.networkNames.size()));
    }

    public static PastelNetwork getNetworkForNewNode(PastelNetworkNodeBlockEntity pastelNetworkNodeBlockEntity) {
        for (PastelNetwork network : networks) {
            if (!network.canConnect(pastelNetworkNodeBlockEntity)) continue;
            return network;
        }
        return new PastelNetwork(pastelNetworkNodeBlockEntity.method_10997());
    }

    public void removeNode(PastelNetworkNodeBlockEntity pastelNetworkNodeBlockEntity) {
        if (pastelNetworkNodeBlockEntity instanceof PastelNetworkConnectionNode) {
            this.pastelNetworkConnectionNodes.remove((Object)pastelNetworkNodeBlockEntity);
        } else if (pastelNetworkNodeBlockEntity instanceof PastelNetworkProviderNodeBlockEntity) {
            this.pastelNetworkProviderNodeBlockEntities.remove((Object)pastelNetworkNodeBlockEntity);
        } else if (pastelNetworkNodeBlockEntity instanceof PastelNetworkPullerNodeBlockEntity) {
            this.pastelNetworkPullerNodes.remove((Object)pastelNetworkNodeBlockEntity);
        } else if (pastelNetworkNodeBlockEntity instanceof PastelNetworkPusherNodeBlockEntity) {
            this.pastelNetworkPusherNodes.remove((Object)pastelNetworkNodeBlockEntity);
        } else if (pastelNetworkNodeBlockEntity instanceof PastelNetworkStorageNodeBlockEntity) {
            this.pastelNetworkStorageNodes.remove((Object)pastelNetworkNodeBlockEntity);
        }
    }

    public boolean canConnect(PastelNetworkNodeBlockEntity newNode) {
        ArrayList<PastelNetworkNodeBlockEntity> allNodes = new ArrayList<PastelNetworkNodeBlockEntity>();
        allNodes.addAll(this.pastelNetworkConnectionNodes);
        allNodes.addAll(this.pastelNetworkProviderNodeBlockEntities);
        allNodes.addAll(this.pastelNetworkPullerNodes);
        allNodes.addAll(this.pastelNetworkPusherNodes);
        allNodes.addAll(this.pastelNetworkStorageNodes);
        for (PastelNetworkNodeBlockEntity currentNode : allNodes) {
            if (!currentNode.canSee(newNode)) continue;
            return true;
        }
        return false;
    }

    public void join(PastelNetwork network) {
        this.pastelNetworkConnectionNodes.addAll(network.pastelNetworkConnectionNodes);
        this.pastelNetworkProviderNodeBlockEntities.addAll(network.pastelNetworkProviderNodeBlockEntities);
        this.pastelNetworkPullerNodes.addAll(network.pastelNetworkPullerNodes);
        this.pastelNetworkPusherNodes.addAll(network.pastelNetworkPusherNodes);
        this.pastelNetworkStorageNodes.addAll(network.pastelNetworkStorageNodes);
        networks.remove(network);
    }

    public void split() {
    }
}

