/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.nodes;

import de.dafuqs.spectrum.blocks.pastel_network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.SchedulerMap;
import de.dafuqs.spectrum.blocks.pastel_network.TickLooper;
import java.util.HashSet;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class PastelNetworkNodeBlockEntity
extends class_2586 {
    public static int RANGE = 16;
    final HashSet<class_2338> receivers = new HashSet();
    private final TickLooper tickTimer = new TickLooper(40);
    private final SchedulerMap<class_2338> particleCooldowns = new SchedulerMap();
    private final HashSet<class_2338> senders = new HashSet();
    protected PastelNetwork network;
    protected class_1263 connectedInventory;

    public PastelNetworkNodeBlockEntity(class_2591 blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void tick() {
        this.tickTimer.tick();
        if (this.field_11863.field_9236) {
            this.particleCooldowns.tick();
        }
    }

    public boolean canSee(PastelNetworkNodeBlockEntity node) {
        return node.field_11867.method_19771((class_2382)this.field_11867, (double)RANGE);
    }

    public void transfer(class_1799 itemStack, PastelNetworkNodeBlockEntity node) {
    }

    public void updateConnectedInventory(class_1937 world, class_2338 blockPos, class_2350 facingDirection) {
        class_2586 connectedBlockEntity = world.method_8321(blockPos.method_10093(facingDirection.method_10153()));
        if (connectedBlockEntity instanceof class_1263) {
            class_1263 connectedInventory;
            this.connectedInventory = connectedInventory = (class_1263)connectedBlockEntity;
        }
    }

    public void initialize(class_1937 world, class_2338 pos, class_2350 facingDirection) {
        this.tickTimer.checkCap();
        this.updateConnectedInventory(world, pos, facingDirection);
        if (this.network != null) {
            this.network = PastelNetwork.getNetworkForNewNode(this);
        }
        int range = this.getRange();
        int range2 = range / 2;
        for (int xOffset = -range; xOffset <= range; ++xOffset) {
            for (int yOffset = -range2; yOffset <= 0; ++yOffset) {
                for (int zOffset = -range; zOffset <= range; ++zOffset) {
                    class_2586 te = world.method_8321(pos.method_10069(xOffset, yOffset, zOffset));
                    if (!this.canTransferTo(te)) continue;
                    this.receivers.add(te.method_11016());
                }
            }
        }
    }

    private boolean canTransferTo(class_2586 blockEntity) {
        return blockEntity instanceof PastelNetworkNodeBlockEntity;
    }

    public void remove() {
        if (this.network != null) {
            this.network.removeNode(this);
        }
    }

    public int getRange() {
        return 16;
    }

    protected final boolean queueParticle(class_2338 blockPos) {
        if (!this.particleCooldowns.containsKey(blockPos)) {
            this.particleCooldowns.put(blockPos, 3);
            return true;
        }
        return false;
    }
}

