/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.potion_workshop;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.interfaces.PotionFillable;
import de.dafuqs.spectrum.inventories.PotionWorkshopScreenHandler;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopBrewingRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopCraftingRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBlockEntity
extends class_2586
implements class_3908,
class_1737,
class_1278,
PlayerOwned {
    public static final int INVENTORY_SIZE = 22;
    public static final class_2960 FOURTH_BREWING_SLOT_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("milestones/unlock_fourth_potion_workshop_reagent_slot");
    public static final int MERMAIDS_GEM_INPUT_SLOT_ID = 0;
    public static final int BASE_INPUT_SLOT_ID = 1;
    public static final int FIRST_INGREDIENT_SLOT = 2;
    public static final int FIRST_REAGENT_SLOT = 5;
    public static final int FIRST_INVENTORY_SLOT = 9;
    public static final int[] REGENT_SLOTS = new int[]{5, 6, 7, 8};
    protected static final int BASE_POTION_COUNT_ON_BREWING = 3;
    protected static final int BASE_ARROW_COUNT_ON_BREWING = 12;
    protected final class_3913 propertyDelegate;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)22, (Object)class_1799.field_8037);
    protected boolean inventoryChanged;
    protected PotionWorkshopRecipe currentRecipe;
    protected int brewTime;
    protected int brewTimeTotal;
    protected int potionColor;
    protected UUID ownerUUID;
    protected class_1291 lastBrewedStatusEffect;

    public PotionWorkshopBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.POTION_WORKSHOP, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> PotionWorkshopBlockEntity.this.brewTime;
                    case 1 -> PotionWorkshopBlockEntity.this.brewTimeTotal;
                    default -> PotionWorkshopBlockEntity.this.potionColor;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        PotionWorkshopBlockEntity.this.brewTime = value;
                        break;
                    }
                    case 1: {
                        PotionWorkshopBlockEntity.this.brewTimeTotal = value;
                        break;
                    }
                    case 2: {
                        PotionWorkshopBlockEntity.this.potionColor = value;
                    }
                }
            }

            public int method_17389() {
                return 3;
            }
        };
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        boolean shouldMarkDirty = false;
        PotionWorkshopRecipe calculatedRecipe = PotionWorkshopBlockEntity.calculateRecipe(world, potionWorkshopBlockEntity);
        potionWorkshopBlockEntity.inventoryChanged = false;
        if (potionWorkshopBlockEntity.currentRecipe != calculatedRecipe) {
            potionWorkshopBlockEntity.currentRecipe = calculatedRecipe;
            potionWorkshopBlockEntity.brewTime = 0;
            if (potionWorkshopBlockEntity.currentRecipe != null) {
                potionWorkshopBlockEntity.brewTimeTotal = calculatedRecipe.getCraftingTime();
                potionWorkshopBlockEntity.potionColor = calculatedRecipe.getColor();
            }
            shouldMarkDirty = true;
        }
        if (calculatedRecipe != null && (potionWorkshopBlockEntity.brewTime > 0 || PotionWorkshopBlockEntity.hasRoomInOutputInventoryFor(potionWorkshopBlockEntity, calculatedRecipe.getMinOutputCount((class_1799)potionWorkshopBlockEntity.inventory.get(1))))) {
            if (potionWorkshopBlockEntity.brewTime == potionWorkshopBlockEntity.brewTimeTotal) {
                if (calculatedRecipe instanceof PotionWorkshopBrewingRecipe) {
                    PotionWorkshopBrewingRecipe brewingRecipe = (PotionWorkshopBrewingRecipe)calculatedRecipe;
                    class_1792 baseItem = ((class_1799)potionWorkshopBlockEntity.inventory.get(1)).method_7909();
                    if (baseItem instanceof PotionFillable) {
                        PotionWorkshopBlockEntity.fillPotionFillable(potionWorkshopBlockEntity, brewingRecipe);
                    } else if (baseItem.equals(class_1802.field_8107)) {
                        PotionWorkshopBlockEntity.createTippedArrows(potionWorkshopBlockEntity, brewingRecipe);
                    } else {
                        PotionWorkshopBlockEntity.brewRecipe(potionWorkshopBlockEntity, brewingRecipe);
                    }
                } else {
                    PotionWorkshopBlockEntity.craftRecipe(potionWorkshopBlockEntity, (PotionWorkshopCraftingRecipe)calculatedRecipe);
                }
                potionWorkshopBlockEntity.brewTime = 0;
                potionWorkshopBlockEntity.inventoryChanged = true;
                potionWorkshopBlockEntity.playSound(class_3417.field_14978);
            } else {
                ++potionWorkshopBlockEntity.brewTime;
            }
            shouldMarkDirty = true;
        }
        if (shouldMarkDirty) {
            PotionWorkshopBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
        }
    }

    public static boolean hasRoomInOutputInventoryFor(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, int outputStacks) {
        for (int slotID : potionWorkshopBlockEntity.method_5494(class_2350.field_11033)) {
            if (!potionWorkshopBlockEntity.method_5438(slotID).method_7960() || --outputStacks != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PotionWorkshopRecipe calculateRecipe(class_1937 world, @NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        if (!potionWorkshopBlockEntity.inventoryChanged) {
            return potionWorkshopBlockEntity.currentRecipe;
        }
        PotionWorkshopRecipe newRecipe = null;
        PotionWorkshopRecipe potionWorkshopRecipe = potionWorkshopBlockEntity.currentRecipe;
        if (potionWorkshopRecipe instanceof PotionWorkshopBrewingRecipe) {
            PotionWorkshopBrewingRecipe potionWorkshopBrewingRecipe = (PotionWorkshopBrewingRecipe)potionWorkshopRecipe;
            if (potionWorkshopBlockEntity.currentRecipe.method_8115((class_1263)potionWorkshopBlockEntity, world)) {
                if (!PotionWorkshopBlockEntity.isBrewingRecipeApplicable(potionWorkshopBrewingRecipe, potionWorkshopBlockEntity.method_5438(1), potionWorkshopBlockEntity)) return newRecipe;
                return potionWorkshopBlockEntity.currentRecipe;
            }
        }
        if (potionWorkshopBlockEntity.currentRecipe instanceof PotionWorkshopCraftingRecipe && potionWorkshopBlockEntity.currentRecipe.method_8115((class_1263)potionWorkshopBlockEntity, world)) {
            return potionWorkshopBlockEntity.currentRecipe;
        }
        PotionWorkshopBrewingRecipe newPotionWorkshopBrewingRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.POTION_WORKSHOP_BREWING, (class_1263)potionWorkshopBlockEntity, world).orElse(null);
        if (newPotionWorkshopBrewingRecipe != null) {
            if (!newPotionWorkshopBrewingRecipe.canPlayerCraft(potionWorkshopBlockEntity.getOwnerIfOnline())) return newRecipe;
            if (!PotionWorkshopBlockEntity.isBrewingRecipeApplicable(newPotionWorkshopBrewingRecipe, potionWorkshopBlockEntity.method_5438(1), potionWorkshopBlockEntity)) return newRecipe;
            return newPotionWorkshopBrewingRecipe;
        }
        PotionWorkshopCraftingRecipe newPotionWorkshopCraftingRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING, (class_1263)potionWorkshopBlockEntity, world).orElse(null);
        if (newPotionWorkshopCraftingRecipe == null) return newRecipe;
        if (!newPotionWorkshopCraftingRecipe.canPlayerCraft(potionWorkshopBlockEntity.getOwnerIfOnline())) return newRecipe;
        return newPotionWorkshopCraftingRecipe;
    }

    private static boolean hasUniqueReagents(PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        ArrayList<class_1792> reagentItems = new ArrayList<class_1792>();
        for (int i = 5; i < 9; ++i) {
            class_1799 reagentStack = potionWorkshopBlockEntity.method_5438(i);
            if (reagentStack.method_7960()) continue;
            if (reagentItems.contains(reagentStack.method_7909())) {
                return false;
            }
            reagentItems.add(reagentStack.method_7909());
        }
        return true;
    }

    private static boolean isBrewingRecipeApplicable(PotionWorkshopBrewingRecipe recipe, class_1799 baseIngredient, PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        if (PotionWorkshopBlockEntity.hasUniqueReagents(potionWorkshopBlockEntity)) {
            if (baseIngredient.method_31574(class_1802.field_8107)) {
                if (recipe.isApplicableToTippedArrows()) {
                    PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
                    return potionMod.makeSplashing && potionMod.makeLingering;
                }
                return false;
            }
            class_1792 class_17922 = baseIngredient.method_7909();
            if (class_17922 instanceof PotionFillable) {
                PotionFillable potionFillable = (PotionFillable)class_17922;
                return recipe.isApplicableToPotionFillabes() && !potionFillable.isFull(baseIngredient);
            }
            if (recipe.method_8110().method_31574(class_1802.field_8574)) {
                return recipe.isApplicableToPotions();
            }
            return true;
        }
        return false;
    }

    private static void craftRecipe(PotionWorkshopBlockEntity potionWorkshopBlockEntity, PotionWorkshopCraftingRecipe recipe) {
        PotionWorkshopBlockEntity.decreaseIngredientSlots(potionWorkshopBlockEntity);
        if (recipe.consumesBaseIngredient()) {
            PotionWorkshopBlockEntity.decreaseBaseIngredientSlot(potionWorkshopBlockEntity, 1);
        }
        if (recipe.getRequiredExperience() > 0) {
            for (int i : new int[]{1, 2, 3, 4}) {
                class_1799 slotStack = potionWorkshopBlockEntity.method_5438(i);
                if (!(slotStack.method_7909() instanceof ExperienceStorageItem)) continue;
                ExperienceStorageItem.removeStoredExperience(slotStack, recipe.getRequiredExperience());
                potionWorkshopBlockEntity.inventoryChanged = true;
                break;
            }
        }
        InventoryHelper.addToInventory(potionWorkshopBlockEntity.inventory, recipe.method_8110().method_7972(), 9, 21);
    }

    private static void brewRecipe(PotionWorkshopBlockEntity potionWorkshopBlockEntity, PotionWorkshopBrewingRecipe brewingRecipe) {
        PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
        int maxBrewedPotionsAmount = Support.getIntFromDecimalWithChance(3.0f + potionMod.flatYieldBonus, potionWorkshopBlockEntity.field_11863.field_9229);
        int brewedAmount = Math.min(((class_1799)potionWorkshopBlockEntity.inventory.get(1)).method_7947(), maxBrewedPotionsAmount);
        PotionWorkshopBlockEntity.decreaseIngredientSlots(potionWorkshopBlockEntity);
        PotionWorkshopBlockEntity.decreaseBaseIngredientSlot(potionWorkshopBlockEntity, brewedAmount);
        PotionWorkshopBlockEntity.decreaseReagentSlots(potionWorkshopBlockEntity);
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (int i = 0; i < brewedAmount; ++i) {
            results.add(brewingRecipe.brewRandomPotion(potionMod, potionWorkshopBlockEntity.lastBrewedStatusEffect, potionWorkshopBlockEntity.field_11863.field_9229));
        }
        class_3222 serverPlayerEntity = (class_3222)potionWorkshopBlockEntity.getOwnerIfOnline();
        for (class_1799 potion : results) {
            InventoryHelper.addToInventory(potionWorkshopBlockEntity.inventory, potion, 9, 21);
            if (serverPlayerEntity == null) continue;
            SpectrumAdvancementCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, potion);
            class_1842 potionStack = class_1844.method_8063((class_1799)potion);
            class_174.field_1213.method_8784(serverPlayerEntity, potionStack);
        }
        potionWorkshopBlockEntity.lastBrewedStatusEffect = brewingRecipe.getStatusEffect();
    }

    private static void createTippedArrows(PotionWorkshopBlockEntity potionWorkshopBlockEntity, PotionWorkshopBrewingRecipe brewingRecipe) {
        PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
        int maxTippedArrowsAmount = Support.getIntFromDecimalWithChance(12.0f + potionMod.flatYieldBonus * 4.0f, potionWorkshopBlockEntity.field_11863.field_9229);
        int tippedAmount = Math.min(((class_1799)potionWorkshopBlockEntity.inventory.get(1)).method_7947(), maxTippedArrowsAmount);
        PotionWorkshopBlockEntity.decreaseIngredientSlots(potionWorkshopBlockEntity);
        PotionWorkshopBlockEntity.decreaseBaseIngredientSlot(potionWorkshopBlockEntity, tippedAmount);
        PotionWorkshopBlockEntity.decreaseReagentSlots(potionWorkshopBlockEntity);
        class_1799 tippedArrows = brewingRecipe.getTippedArrows(potionMod, potionWorkshopBlockEntity.lastBrewedStatusEffect, tippedAmount, potionWorkshopBlockEntity.field_11863.field_9229);
        class_3222 serverPlayerEntity = (class_3222)potionWorkshopBlockEntity.getOwnerIfOnline();
        InventoryHelper.addToInventory(potionWorkshopBlockEntity.inventory, tippedArrows, 9, 21);
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, tippedArrows);
        }
        potionWorkshopBlockEntity.lastBrewedStatusEffect = brewingRecipe.getStatusEffect();
    }

    private static void fillPotionFillable(PotionWorkshopBlockEntity potionWorkshopBlockEntity, PotionWorkshopBrewingRecipe brewingRecipe) {
        class_1799 potionFillableStack = (class_1799)potionWorkshopBlockEntity.inventory.get(1);
        if (potionFillableStack.method_7909() instanceof PotionFillable) {
            PotionMod potionMod = PotionWorkshopBlockEntity.getPotionModFromReagents(potionWorkshopBlockEntity);
            PotionWorkshopBlockEntity.decreaseIngredientSlots(potionWorkshopBlockEntity);
            PotionWorkshopBlockEntity.decreaseReagentSlots(potionWorkshopBlockEntity);
            potionWorkshopBlockEntity.inventory.set(1, (Object)class_1799.field_8037);
            brewingRecipe.fillPotionFillable(potionFillableStack, potionMod, potionWorkshopBlockEntity.lastBrewedStatusEffect, potionWorkshopBlockEntity.field_11863.field_9229);
            class_3222 serverPlayerEntity = (class_3222)potionWorkshopBlockEntity.getOwnerIfOnline();
            InventoryHelper.addToInventory(potionWorkshopBlockEntity.inventory, potionFillableStack, 9, 21);
            if (serverPlayerEntity != null) {
                SpectrumAdvancementCriteria.POTION_WORKSHOP_BREWING.trigger(serverPlayerEntity, potionFillableStack);
            }
            potionWorkshopBlockEntity.lastBrewedStatusEffect = brewingRecipe.getStatusEffect();
        }
    }

    private static PotionMod getPotionModFromReagents(PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        PotionMod potionMod = new PotionMod();
        for (int i : REGENT_SLOTS) {
            class_1799 itemStack = potionWorkshopBlockEntity.method_5438(i);
            if (itemStack.method_7960() || !PotionWorkshopReactingRecipe.isReagent(itemStack.method_7909())) continue;
            potionMod = PotionWorkshopReactingRecipe.modify(itemStack.method_7909(), potionMod, potionWorkshopBlockEntity.field_11863.field_9229);
        }
        return potionMod;
    }

    public static void decreaseBaseIngredientSlot(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity, int baseIngredientAmount) {
        potionWorkshopBlockEntity.method_5438(1).method_7934(baseIngredientAmount);
    }

    public static void decreaseIngredientSlots(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        potionWorkshopBlockEntity.method_5438(0).method_7934(1);
        for (int i : new int[]{2, 3, 4}) {
            class_1799 currentStack = potionWorkshopBlockEntity.method_5438(i);
            if (currentStack.method_7960() || currentStack.method_7909() instanceof ExperienceStorageItem) continue;
            currentStack.method_7934(1);
        }
    }

    public static void decreaseReagentSlots(@NotNull PotionWorkshopBlockEntity potionWorkshopBlockEntity) {
        for (int i : new int[]{5, 6, 7, 8}) {
            class_1799 currentStack = potionWorkshopBlockEntity.method_5438(i);
            if (currentStack.method_7960()) continue;
            currentStack.method_7934(1);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)22, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        this.lastBrewedStatusEffect = nbt.method_10545("LastBrewedStatusEffect") ? (class_1291)class_2378.field_11159.method_10223(class_2960.method_12829((String)nbt.method_10558("LastBrewedStatusEffect"))) : null;
    }

    public void method_11007(class_2487 nbt) {
        class_2960 lastBrewedStatusEffectIdentifier;
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.lastBrewedStatusEffect != null && (lastBrewedStatusEffectIdentifier = class_2378.field_11159.method_10221((Object)this.lastBrewedStatusEffect)) != null) {
            nbt.method_10582("LastBrewedStatusEffect", lastBrewedStatusEffectIdentifier.toString());
        }
    }

    private void playSound(class_3414 soundEvent) {
        class_5819 random = this.field_11863.field_9229;
        this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, 0.9f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 9;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack = class_1262.method_5428(this.inventory, (int)slot);
        this.inventoryChanged = true;
        this.method_5431();
        return removedStack;
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_7683(class_1662 recipeMatcher) {
        recipeMatcher.method_7400((class_1799)this.inventory.get(2));
        recipeMatcher.method_7400((class_1799)this.inventory.get(3));
        recipeMatcher.method_7400((class_1799)this.inventory.get(4));
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
    }

    public void method_5448() {
        this.inventory.clear();
        this.inventoryChanged = true;
        this.method_5431();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return stack.method_31574((class_1792)SpectrumItems.MERMAIDS_GEM);
        }
        if (slot == 1) {
            return true;
        }
        if (slot < 5) {
            return true;
        }
        if (slot < 9) {
            return PotionWorkshopReactingRecipe.isReagent(stack.method_7909());
        }
        return false;
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        boolean isSameItem = !stack.method_7960() && stack.method_7962(itemStack) && class_1799.method_7975((class_1799)stack, (class_1799)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!isSameItem) {
            this.inventoryChanged = true;
        }
        this.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        }
        if (side == class_2350.field_11036) {
            return new int[]{0, 1, 2, 3, 4};
        }
        if (this.hasFourthReagentSlotUnlocked()) {
            return new int[]{5, 6, 7};
        }
        return new int[]{5, 6, 7, 8};
    }

    public boolean method_5492(int slot, @NotNull class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    private boolean hasFourthReagentSlotUnlocked(class_1657 playerEntity) {
        if (playerEntity == null) {
            return false;
        }
        return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)FOURTH_BREWING_SLOT_ADVANCEMENT_IDENTIFIER);
    }

    private boolean hasFourthReagentSlotUnlocked() {
        if (this.ownerUUID == null) {
            return false;
        }
        return this.hasFourthReagentSlotUnlocked(this.getOwnerIfOnline());
    }

    public void inventoryChanged() {
        this.inventoryChanged = true;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.spectrum.potion_workshop");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new PotionWorkshopScreenHandler(syncId, inv, this, this.propertyDelegate);
    }
}

