/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.present;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.present.PresentBlockEntity;
import de.dafuqs.spectrum.blocks.present.PresentItem;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.effect.ParticleSpawnerParticleEffect;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1160;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresentBlock
extends class_2237 {
    public static final int TICKS_PER_OPENING_STEP = 20;
    public static final int OPENING_STEPS = 6;
    private static final class_2960 PARTICLE_SPRITE_IDENTIFIER = SpectrumCommon.locate("particle/shooting_star");
    public static final class_2746 OPENING = class_2746.method_11825((String)"opening");
    private static final class_2754<Variant> VARIANT = class_2754.method_11850((String)"variant", Variant.class);
    protected static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public PresentBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)OPENING, (Comparable)Boolean.valueOf(false))).method_11657(VARIANT, (Comparable)((Object)Variant.RED)));
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{OPENING, VARIANT});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public boolean method_9558(@NotNull class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 downState = world.method_8320(pos.method_10074());
        return downState.method_26206((class_1922)world, pos, class_2350.field_11036);
    }

    public void method_9567(@NotNull class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        world.method_8501(pos, (class_2680)state.method_11657(VARIANT, (Comparable)((Object)PresentItem.getVariant(itemStack.method_7969()))));
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            presentBlockEntity.setDataFromPresentStack(itemStack);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_31549().field_7476) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            if (player.method_5715()) {
                presentBlockEntity.setOpenerUUID(player);
                state = (class_2680)state.method_11657((class_2769)OPENING, (Comparable)Boolean.valueOf(true));
                world.method_8652(pos, state, 3);
                world.method_39279(pos, state.method_26204(), 20);
            } else if (presentBlockEntity.getOwnerName() != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"block.spectrum.present.tooltip.wrapped_placed.giver", (Object[])new Object[]{presentBlockEntity.getOwnerName()}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.wrapped_placed"), false);
            }
        }
        return class_1269.field_21466;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        class_2586 blockEntity = (class_2586)builder.method_305(class_181.field_1228);
        if (blockEntity instanceof PresentBlockEntity) {
            PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
            return List.of(presentBlockEntity.retrievePresent((Variant)((Object)state.method_11654(VARIANT))));
        }
        return super.method_9560(state, builder);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)OPENING)).booleanValue() && !world.field_9236) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof PresentBlockEntity) {
                PresentBlockEntity presentBlockEntity = (PresentBlockEntity)blockEntity;
                int openingTick = presentBlockEntity.openingTick();
                class_243 posVec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + 0.5);
                if (openingTick == 6) {
                    PresentBlock.spawnParticles(world, pos, presentBlockEntity.colors);
                    presentBlockEntity.triggerAdvancement();
                    if (presentBlockEntity.isEmpty()) {
                        world.method_43128(null, posVec.field_1352, posVec.field_1351, posVec.field_1350, class_3417.field_15102, class_3419.field_15245, 0.5f, 0.8f);
                        SpectrumS2CPacketSender.playParticleWithExactOffsetAndVelocity(world, posVec, (class_2394)class_2398.field_11251, 5);
                    } else {
                        world.method_43128(null, posVec.field_1352, posVec.field_1351, posVec.field_1350, class_3417.field_15152, class_3419.field_15245, 0.5f, 4.0f);
                        SpectrumS2CPacketSender.playParticleWithExactOffsetAndVelocity(world, posVec, (class_2394)class_2398.field_11236, 1);
                        class_1264.method_17349((class_1937)world, (class_2338)pos, presentBlockEntity.stacks);
                    }
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                } else {
                    world.method_43128(null, posVec.field_1352, posVec.field_1351, posVec.field_1350, class_3417.field_15144, class_3419.field_15245, 0.8f + (float)openingTick * 0.1f, 1.0f);
                    PresentBlock.spawnParticles(world, pos, presentBlockEntity.colors);
                }
            }
            world.method_39279(pos, state.method_26204(), 20);
        }
    }

    public static void spawnParticles(class_3218 world, class_2338 pos, Map<class_1767, Integer> colors) {
        SpectrumS2CPacketSender.playPresentOpeningParticles(world, pos, colors);
    }

    public static void spawnParticles(class_638 world, class_2338 pos, Map<class_1767, Integer> colors) {
        if (colors.isEmpty()) {
            class_1767 randomColor = class_1767.method_7791((int)world.field_9229.method_43048(class_1767.values().length));
            PresentBlock.spawnParticles(world, pos, randomColor, 15);
        } else {
            for (Map.Entry<class_1767, Integer> color : colors.entrySet()) {
                PresentBlock.spawnParticles(world, pos, color.getKey(), color.getValue() * 10);
            }
        }
    }

    private static void spawnParticles(class_638 world, class_2338 pos, class_1767 color, int amount) {
        double posX = (double)pos.method_10263() + 0.5;
        double posY = (double)pos.method_10264() + 0.25;
        double posZ = (double)pos.method_10260() + 0.5;
        class_5819 random = world.field_9229;
        class_1160 colorVec = ColorHelper.getVec(color);
        for (int i = 0; i < amount; ++i) {
            double randX = 0.35 - (double)random.method_43057() * 0.7;
            double randY = (double)random.method_43057() * 0.7;
            double randZ = 0.35 - (double)random.method_43057() * 0.7;
            float randomScale = 0.5f + random.method_43057();
            int randomLifetime = 20 + random.method_43048(20);
            ParticleSpawnerParticleEffect particleEffect = new ParticleSpawnerParticleEffect(PARTICLE_SPRITE_IDENTIFIER, 0.98f, colorVec, randomScale, randomLifetime, true, false);
            world.method_8406((class_2394)particleEffect, posX, posY, posZ, randX, randY, randZ);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PresentBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public static enum Variant implements class_3542
    {
        RED,
        BLUE,
        CYAN,
        GREEN,
        PURPLE,
        CAKE,
        STRIPED,
        STARRY,
        WINTER,
        PRIDE;


        public String method_15434() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

