/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.shooting_star;

import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlock;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShootingStarItem
extends class_1747 {
    private final ShootingStarBlock.Type type;

    public ShootingStarItem(ShootingStarBlock block, class_1792.class_1793 settings) {
        super((class_2248)block, settings);
        this.type = block.shootingStarType;
    }

    public static int getRemainingHits(@NotNull class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound == null || !nbtCompound.method_10573("remaining_hits", 3)) {
            return 5;
        }
        return nbtCompound.method_10550("remaining_hits");
    }

    @NotNull
    public static class_1799 getWithRemainingHits(@NotNull ShootingStarItem shootingStarItem, int remainingHits, boolean hardened) {
        class_1799 stack = shootingStarItem.method_7854();
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10569("remaining_hits", remainingHits);
        if (hardened) {
            nbtCompound.method_10556("Hardened", true);
        }
        stack.method_7980(nbtCompound);
        return stack;
    }

    public class_1269 method_7884(@NotNull class_1838 context) {
        if (context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        class_1937 world = context.method_8045();
        if (!world.field_9236) {
            class_1799 itemStack = context.method_8041();
            class_243 hitPos = context.method_17698();
            class_1657 user = context.method_8036();
            ShootingStarEntity shootingStarEntity = new ShootingStarEntity(context.method_8045(), hitPos.field_1352, hitPos.field_1351, hitPos.field_1350);
            shootingStarEntity.setShootingStarType(this.type, true, ShootingStarItem.isHardened(itemStack));
            shootingStarEntity.setAvailableHits(ShootingStarItem.getRemainingHits(context.method_8041()));
            shootingStarEntity.method_36456(user.method_36454());
            if (!world.method_8587((class_1297)shootingStarEntity, shootingStarEntity.method_5829())) {
                return class_1269.field_5814;
            }
            world.method_8649((class_1297)shootingStarEntity);
            world.method_33596((class_1297)user, class_5712.field_28738, context.method_8037());
            if (!user.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        if (ShootingStarItem.isHardened(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.shooting_star.tooltip.hardened").method_27692(class_124.field_1080));
        }
    }

    public ShootingStarBlock.Type getType() {
        return this.type;
    }

    public static boolean isHardened(class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        return nbtCompound != null && nbtCompound.method_10577("Hardened");
    }

    public static void setHardened(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7948();
        nbt.method_10556("Hardened", true);
        itemStack.method_7980(nbt);
    }
}

