/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.spirit_instiller;

import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.decoration.GemstoneChimeBlock;
import de.dafuqs.spectrum.blocks.item_bowl.ItemBowlBlockEntity;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.color.ItemColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class SpiritInstillerBlockEntity
extends InWorldInteractionBlockEntity
implements MultiblockCrafter {
    protected static final int INVENTORY_SIZE = 1;
    public static final List<class_2382> itemBowlOffsetsHorizontal = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(0, 0, 2));
            this.add(new class_2382(0, 0, -2));
        }
    };
    public static final List<class_2382> itemBowlOffsetsVertical = new ArrayList<class_2382>(){
        {
            this.add(new class_2382(2, 0, 0));
            this.add(new class_2382(-2, 0, 0));
        }
    };
    private final class_1263 autoCraftingInventory;
    private boolean inventoryChanged;
    private UUID ownerUUID;
    private Map<Upgradeable.UpgradeType, Float> upgrades;
    private class_2470 multiblockRotation = class_2470.field_11467;
    private SpiritInstillerRecipe currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private boolean canCraft;

    public SpiritInstillerBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.SPIRIT_INSTILLER, pos, state, 1);
        this.autoCraftingInventory = new class_1277(3);
    }

    public static void clientTick(class_1937 world, class_2338 blockPos, class_2680 blockState, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        if (spiritInstillerBlockEntity.currentRecipe != null) {
            spiritInstillerBlockEntity.doInstillerParticles(world);
            if (world.method_8510() % 40L == 0L) {
                spiritInstillerBlockEntity.doChimeParticles(world);
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 blockPos, class_2680 blockState, SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        if (spiritInstillerBlockEntity.upgrades == null) {
            spiritInstillerBlockEntity.calculateUpgrades();
        }
        if (spiritInstillerBlockEntity.inventoryChanged) {
            SpiritInstillerBlockEntity.calculateCurrentRecipe(world, spiritInstillerBlockEntity);
            spiritInstillerBlockEntity.inventoryChanged = false;
        }
        if (spiritInstillerBlockEntity.currentRecipe != null && spiritInstillerBlockEntity.canCraft) {
            if (spiritInstillerBlockEntity.craftingTime % 60 == 1 && !SpiritInstillerBlockEntity.checkRecipeRequirements(world, blockPos, spiritInstillerBlockEntity)) {
                spiritInstillerBlockEntity.craftingTime = 0;
                SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)spiritInstillerBlockEntity.field_11863, spiritInstillerBlockEntity.field_11867);
                return;
            }
            if (spiritInstillerBlockEntity.currentRecipe != null) {
                ++spiritInstillerBlockEntity.craftingTime;
                if (spiritInstillerBlockEntity.craftingTime == 1) {
                    SpectrumS2CPacketSender.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.SPIRIT_INSTILLER_CRAFTING, (class_3218)spiritInstillerBlockEntity.field_11863, spiritInstillerBlockEntity.field_11867, Integer.MAX_VALUE);
                } else if ((double)spiritInstillerBlockEntity.craftingTime == (double)spiritInstillerBlockEntity.craftingTimeTotal * 0.01 || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.25) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.5) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.75) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.83) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.9) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.95) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.98) || (double)spiritInstillerBlockEntity.craftingTime == Math.floor((double)spiritInstillerBlockEntity.craftingTimeTotal * 0.99)) {
                    spiritInstillerBlockEntity.doItemBowlOrbs(world);
                } else if (spiritInstillerBlockEntity.craftingTime == spiritInstillerBlockEntity.craftingTimeTotal) {
                    SpiritInstillerBlockEntity.craftSpiritInstillerRecipe(world, spiritInstillerBlockEntity, spiritInstillerBlockEntity.currentRecipe);
                }
                spiritInstillerBlockEntity.method_5431();
            }
        } else {
            SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)spiritInstillerBlockEntity.field_11863, spiritInstillerBlockEntity.field_11867);
        }
    }

    private static void calculateCurrentRecipe(@NotNull class_1937 world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        if (spiritInstillerBlockEntity.currentRecipe != null && !spiritInstillerBlockEntity.autoCraftingInventory.method_5442() && spiritInstillerBlockEntity.currentRecipe.method_8115(spiritInstillerBlockEntity.autoCraftingInventory, world)) {
            return;
        }
        spiritInstillerBlockEntity.craftingTime = 0;
        spiritInstillerBlockEntity.currentRecipe = null;
        class_1799 instillerStack = spiritInstillerBlockEntity.method_5438(0);
        if (!instillerStack.method_7960()) {
            ItemBowlBlockEntity itemBowlBlockEntity;
            spiritInstillerBlockEntity.autoCraftingInventory.method_5447(0, instillerStack);
            class_2586 class_25862 = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
            if (class_25862 instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)class_25862;
                spiritInstillerBlockEntity.autoCraftingInventory.method_5447(1, itemBowlBlockEntity.method_5438(0));
            } else {
                spiritInstillerBlockEntity.autoCraftingInventory.method_5447(1, class_1799.field_8037);
            }
            class_25862 = world.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
            if (class_25862 instanceof ItemBowlBlockEntity) {
                itemBowlBlockEntity = (ItemBowlBlockEntity)class_25862;
                spiritInstillerBlockEntity.autoCraftingInventory.method_5447(2, itemBowlBlockEntity.method_5438(0));
            } else {
                spiritInstillerBlockEntity.autoCraftingInventory.method_5447(2, class_1799.field_8037);
            }
            SpiritInstillerRecipe spiritInstillerRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.SPIRIT_INSTILLING, spiritInstillerBlockEntity.autoCraftingInventory, world).orElse(null);
            if (spiritInstillerRecipe != null) {
                spiritInstillerBlockEntity.currentRecipe = spiritInstillerRecipe;
                spiritInstillerBlockEntity.craftingTimeTotal = (int)Math.ceil((float)spiritInstillerRecipe.getCraftingTime() / spiritInstillerBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.SPEED).floatValue());
            }
        }
        spiritInstillerBlockEntity.canCraft = spiritInstillerBlockEntity.currentRecipe == null ? false : spiritInstillerBlockEntity.currentRecipe.canCraftWithStacks(instillerStack, spiritInstillerBlockEntity.autoCraftingInventory.method_5438(1), spiritInstillerBlockEntity.autoCraftingInventory.method_5438(2));
        spiritInstillerBlockEntity.updateInClientWorld(world, spiritInstillerBlockEntity.field_11867);
    }

    public static class_2338 getItemBowlPos(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, boolean right) {
        class_2338 blockPos = spiritInstillerBlockEntity.field_11867;
        switch (spiritInstillerBlockEntity.multiblockRotation) {
            case field_11467: 
            case field_11464: {
                if (right) {
                    return blockPos.method_10084().method_10076(2);
                }
                return blockPos.method_10084().method_10077(2);
            }
        }
        if (right) {
            return blockPos.method_10084().method_10089(2);
        }
        return blockPos.method_10084().method_10088(2);
    }

    private static boolean checkRecipeRequirements(class_1937 world, class_2338 blockPos, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        class_1657 lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(spiritInstillerBlockEntity.ownerUUID);
        if (lastInteractedPlayer == null) {
            return false;
        }
        boolean playerCanCraft = true;
        if (spiritInstillerBlockEntity.currentRecipe != null) {
            playerCanCraft = spiritInstillerBlockEntity.currentRecipe.canPlayerCraft(lastInteractedPlayer);
        }
        boolean structureComplete = SpiritInstillerBlock.verifyStructure(world, blockPos, null, spiritInstillerBlockEntity);
        boolean canCraft = true;
        if (!playerCanCraft || !structureComplete) {
            if (!structureComplete) {
                world.method_8396(null, spiritInstillerBlockEntity.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + spiritInstillerBlockEntity.field_11863.field_9229.method_43057() * 0.2f, 0.9f + spiritInstillerBlockEntity.field_11863.field_9229.method_43057() * 0.2f);
            }
            canCraft = false;
        }
        if (lastInteractedPlayer instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)lastInteractedPlayer;
            SpiritInstillerBlockEntity.testAndUnlockUnlockBossMemoryAdvancement(serverPlayerEntity, spiritInstillerBlockEntity.currentRecipe, canCraft);
        }
        spiritInstillerBlockEntity.canCraft = canCraft & spiritInstillerBlockEntity.currentRecipe.canPlayerCraft(lastInteractedPlayer);
        return canCraft;
    }

    public static void testAndUnlockUnlockBossMemoryAdvancement(class_3222 player, SpiritInstillerRecipe spiritInstillerRecipe, boolean canActuallyCraft) {
        boolean isBossMemory;
        boolean bl = isBossMemory = spiritInstillerRecipe.method_8112() != null && spiritInstillerRecipe.method_8112().equals("boss_memories");
        if (isBossMemory) {
            if (canActuallyCraft) {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_success", "succeed_crafting_boss_memory");
            } else {
                Support.grantAdvancementCriterion(player, "midgame/craft_blacklisted_memory_fail", "fail_to_craft_boss_memory");
            }
        }
    }

    public static void craftSpiritInstillerRecipe(class_1937 world, @NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity, @NotNull SpiritInstillerRecipe spiritInstillerRecipe) {
        class_1799 resultStack = spiritInstillerRecipe.method_8116(spiritInstillerBlockEntity);
        SpiritInstillerBlockEntity.decrementItemsInInstillerAndBowls(spiritInstillerBlockEntity);
        if (!resultStack.method_7960()) {
            if (spiritInstillerBlockEntity.method_5438(0).method_7960()) {
                spiritInstillerBlockEntity.method_5447(0, resultStack);
            } else {
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, spiritInstillerBlockEntity.field_11867, resultStack, resultStack.method_7947(), MultiblockCrafter.RECIPE_STACK_VELOCITY);
            }
        }
        SpiritInstillerBlockEntity.playCraftingFinishedEffects(spiritInstillerBlockEntity);
        spiritInstillerBlockEntity.craftingTime = 0;
        spiritInstillerBlockEntity.inventoryChanged();
    }

    public static void decrementItemsInInstillerAndBowls(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        SpiritInstillerRecipe recipe = spiritInstillerBlockEntity.currentRecipe;
        double efficiencyModifier = 1.0;
        if (!recipe.areYieldAndEfficiencyUpgradesDisabled() && (double)spiritInstillerBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EFFICIENCY).floatValue() != 1.0) {
            efficiencyModifier = 1.0 / (double)spiritInstillerBlockEntity.upgrades.get((Object)Upgradeable.UpgradeType.EFFICIENCY).floatValue();
        }
        class_2586 leftBowlBlockEntity = spiritInstillerBlockEntity.field_11863.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, false));
        class_2586 rightBowlBlockEntity = spiritInstillerBlockEntity.field_11863.method_8321(SpiritInstillerBlockEntity.getItemBowlPos(spiritInstillerBlockEntity, true));
        if (leftBowlBlockEntity instanceof ItemBowlBlockEntity) {
            ItemBowlBlockEntity leftBowl = (ItemBowlBlockEntity)leftBowlBlockEntity;
            if (rightBowlBlockEntity instanceof ItemBowlBlockEntity) {
                ItemBowlBlockEntity rightBowl = (ItemBowlBlockEntity)rightBowlBlockEntity;
                int decreasedAmountAfterEfficiencyMod = Support.getIntFromDecimalWithChance((double)recipe.getIngredientStacks().get(0).getCount() * efficiencyModifier, spiritInstillerBlockEntity.field_11863.field_9229);
                if (decreasedAmountAfterEfficiencyMod > 0) {
                    spiritInstillerBlockEntity.method_5438(0).method_7934(decreasedAmountAfterEfficiencyMod);
                }
                List<IngredientStack> ingredientStacks = recipe.getIngredientStacks();
                int amountAfterEfficiencyModFirst = Support.getIntFromDecimalWithChance((double)ingredientStacks.get(1).getCount() * efficiencyModifier, spiritInstillerBlockEntity.field_11863.field_9229);
                int amountAfterEfficiencyModSecond = Support.getIntFromDecimalWithChance((double)ingredientStacks.get(2).getCount() * efficiencyModifier, spiritInstillerBlockEntity.field_11863.field_9229);
                boolean leftIsFirstIngredient = ingredientStacks.get(1).test(leftBowl.method_5438(0));
                class_243 particlePos = new class_243((double)spiritInstillerBlockEntity.field_11867.method_10263() + 0.5, (double)(spiritInstillerBlockEntity.field_11867.method_10264() + 1), (double)spiritInstillerBlockEntity.field_11867.method_10260() + 0.5);
                if (leftIsFirstIngredient) {
                    if (amountAfterEfficiencyModFirst > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                } else {
                    if (amountAfterEfficiencyModFirst > 0) {
                        rightBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModFirst, true);
                    }
                    if (amountAfterEfficiencyModSecond > 0) {
                        leftBowl.decrementBowlStack(particlePos, amountAfterEfficiencyModSecond, true);
                    }
                }
            }
        }
    }

    public static void playCraftingFinishedEffects(@NotNull SpiritInstillerBlockEntity spiritInstillerBlockEntity) {
        spiritInstillerBlockEntity.field_11863.method_8396(null, spiritInstillerBlockEntity.field_11867, SpectrumSoundEvents.SPIRIT_INSTILLER_CRAFTING_FINISHED, class_3419.field_15245, 1.0f, 1.0f);
        SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)spiritInstillerBlockEntity.field_11863, new class_243((double)spiritInstillerBlockEntity.field_11867.method_10263() + 0.5, (double)spiritInstillerBlockEntity.field_11867.method_10264() + 0.5, (double)spiritInstillerBlockEntity.field_11867.method_10260() + 0.5), (class_2394)SpectrumParticleTypes.LIGHT_BLUE_CRAFTING, 75, new class_243(0.5, 0.5, 0.5), new class_243(0.1, -0.1, 0.1));
    }

    @Override
    public void method_11014(class_2487 nbt) {
        Object t;
        Optional optionalRecipe;
        String recipeString;
        super.method_11014(nbt);
        this.craftingTime = nbt.method_10568("CraftingTime");
        this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.inventoryChanged = nbt.method_10577("InventoryChanged");
        this.canCraft = nbt.method_10577("CanCraft");
        this.ownerUUID = nbt.method_10545("OwnerUUID") ? nbt.method_25926("OwnerUUID") : null;
        if (nbt.method_10545("MulitblockRotation")) {
            try {
                this.multiblockRotation = class_2470.valueOf((String)nbt.method_10558("MultiblockRotation").toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.multiblockRotation = class_2470.field_11467;
            }
        }
        this.currentRecipe = null;
        if (nbt.method_10545("CurrentRecipe") && !(recipeString = nbt.method_10558("CurrentRecipe")).isEmpty() && this.field_11863 != null && (optionalRecipe = this.field_11863.method_8433().method_8130(new class_2960(recipeString))).isPresent() && (t = optionalRecipe.get()) instanceof SpiritInstillerRecipe) {
            SpiritInstillerRecipe spiritInstillerRecipe;
            this.currentRecipe = spiritInstillerRecipe = (SpiritInstillerRecipe)t;
        }
        if (nbt.method_10573("Upgrades", 9)) {
            this.upgrades = Upgradeable.fromNbt(nbt.method_10554("Upgrades", 10));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbt.method_10556("CanCraft", this.canCraft);
        nbt.method_10556("InventoryChanged", this.inventoryChanged);
        nbt.method_10582("MulitblockRotation", this.multiblockRotation.toString());
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)Upgradeable.toNbt(this.upgrades));
        }
        if (this.ownerUUID != null) {
            nbt.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    private void doInstillerParticles(@NotNull class_1937 world) {
        Optional<class_1767> stackColor = ItemColors.ITEM_COLORS.getMapping(this.method_5438(0).method_7909());
        if (stackColor.isPresent()) {
            class_5819 random = world.field_9229;
            class_2394 particleEffect = SpectrumParticleTypes.getSparkleRisingParticle(stackColor.get());
            world.method_8406(particleEffect, (double)this.field_11867.method_10263() + 0.25 + random.method_43058() * 0.5, (double)this.field_11867.method_10264() + 0.75, (double)this.field_11867.method_10260() + 0.25 + random.method_43058() * 0.5, 0.02 - random.method_43058() * 0.04, 0.01 + random.method_43058() * 0.05, 0.02 - random.method_43058() * 0.04);
        }
    }

    private void doChimeParticles(@NotNull class_1937 world) {
        this.doChimeInstillingParticles(world, this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(false).method_30930(3)));
        this.doChimeInstillingParticles(world, this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(true).method_30930(3)));
    }

    public void doChimeInstillingParticles(@NotNull class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof GemstoneChimeBlock) {
            GemstoneChimeBlock gemstoneChimeBlock = (GemstoneChimeBlock)class_22482;
            class_5819 random = world.field_9229;
            class_2394 particleEffect = gemstoneChimeBlock.getParticleEffect();
            for (int i = 0; i < 16; ++i) {
                world.method_8406(particleEffect, (double)pos.method_10263() + 0.25 + random.method_43058() * 0.5, (double)pos.method_10264() + 0.15 + random.method_43058() * 0.5, (double)pos.method_10260() + 0.25 + random.method_43058() * 0.5, 0.06 - random.method_43058() * 0.12, -0.1 - random.method_43058() * 0.05, 0.06 - random.method_43058() * 0.12);
            }
        }
    }

    private void doItemBowlOrbs(@NotNull class_1937 world) {
        ItemBowlBlockEntity itemBowlBlockEntity;
        class_2338 itemBowlPos = this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(false).method_30931());
        class_2586 blockEntity = world.method_8321(itemBowlPos);
        if (blockEntity instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5));
        }
        if ((blockEntity = world.method_8321(itemBowlPos = this.field_11867.method_10081(this.getItemBowlHorizontalPositionOffset(true).method_30931()))) instanceof ItemBowlBlockEntity) {
            itemBowlBlockEntity = (ItemBowlBlockEntity)blockEntity;
            itemBowlBlockEntity.spawnOrbParticles(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5));
        }
    }

    public class_2382 getItemBowlHorizontalPositionOffset(boolean right) {
        if (this.multiblockRotation == class_2470.field_11467 || this.multiblockRotation == class_2470.field_11464) {
            return itemBowlOffsetsHorizontal.get(right ? 1 : 0);
        }
        return itemBowlOffsetsVertical.get(right ? 1 : 0);
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods2(this.field_11863, this.field_11867, this.multiblockRotation, 4, 1, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public float getUpgradeValue(Upgradeable.UpgradeType upgradeType) {
        return this.upgrades.get((Object)upgradeType).floatValue();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5426((class_2487)nbtCompound, this.getItems());
        nbtCompound.method_10575("CraftingTime", (short)this.craftingTime);
        nbtCompound.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        nbtCompound.method_10582("MulitblockRotation", this.multiblockRotation.method_15434());
        if (this.currentRecipe != null && this.canCraft) {
            nbtCompound.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
        return nbtCompound;
    }

    public class_2470 getMultiblockRotation() {
        return this.multiblockRotation;
    }

    public void setMultiblockRotation(class_2470 blockRotation) {
        this.multiblockRotation = blockRotation;
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.inventoryChanged = true;
        this.autoCraftingInventory.method_5448();
        this.method_5431();
    }

    public Map<Upgradeable.UpgradeType, Float> getUpgrades() {
        return this.upgrades;
    }
}

