/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.structure;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.blocks.structure.PreservationControllerBlock;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;

public class PreservationControllerBlockEntity
extends class_2586 {
    private class_2382 entranceOffset;
    private class_2382 checkRange;
    private class_2960 requiredAdvancement;
    private class_1291 requiredEffect;
    private class_2960 unlockedAdvancement;
    private String unlockedAdvancementCriterion;
    private class_238 checkBox;
    private class_2382 checkBoxOffset;
    private class_2338 destinationPos;
    private boolean spawnParticles;

    public PreservationControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.PRESERVATION_CONTROLLER, pos, state);
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, PreservationControllerBlockEntity blockEntity) {
        if (world.method_8510() % 20L == 0L && blockEntity.entranceOffset != null && blockEntity.checkRange != null && blockEntity.requiredAdvancement != null) {
            if (blockEntity.checkBox == null) {
                PreservationControllerBlockEntity.calculateLocationData(world, blockPos, blockState, blockEntity);
            }
            if (blockEntity.spawnParticles) {
                blockEntity.spawnParticles();
            }
            if (blockEntity.requiredAdvancement != null) {
                blockEntity.yeetUnworthyPlayersAndGrantAdvancement();
            }
        }
    }

    private static void calculateLocationData(class_1937 world, class_2338 blockPos, @NotNull class_2680 blockState, @NotNull PreservationControllerBlockEntity blockEntity) {
        class_2350 facing = (class_2350)world.method_8320(blockPos).method_11654((class_2769)PreservationControllerBlock.FACING);
        class_2338 centerPos = blockPos;
        if (blockEntity.checkBoxOffset != null) {
            centerPos = Support.directionalOffset(blockEntity.field_11867, blockEntity.checkBoxOffset, (class_2350)blockState.method_11654((class_2769)PreservationControllerBlock.FACING));
        }
        blockEntity.checkBox = facing == class_2350.field_11043 || facing == class_2350.field_11035 ? class_238.method_30048((class_243)class_243.method_24953((class_2382)centerPos), (double)(blockEntity.checkRange.method_10263() * 2), (double)(blockEntity.checkRange.method_10264() * 2), (double)(blockEntity.checkRange.method_10260() * 2)) : class_238.method_30048((class_243)class_243.method_24953((class_2382)centerPos), (double)(blockEntity.checkRange.method_10260() * 2), (double)(blockEntity.checkRange.method_10264() * 2), (double)(blockEntity.checkRange.method_10263() * 2));
        blockEntity.destinationPos = Support.directionalOffset(blockEntity.field_11867, blockEntity.entranceOffset, (class_2350)blockState.method_11654((class_2769)PreservationControllerBlock.FACING));
    }

    public void method_11007(class_2487 tag) {
        class_2960 effectIdentifier;
        super.method_11007(tag);
        if (this.entranceOffset != null) {
            tag.method_10569("EntranceOffsetX", this.entranceOffset.method_10263());
            tag.method_10569("EntranceOffsetY", this.entranceOffset.method_10264());
            tag.method_10569("EntranceOffsetZ", this.entranceOffset.method_10260());
        }
        if (this.checkBoxOffset != null) {
            tag.method_10569("CheckBoxOffsetX", this.checkBoxOffset.method_10263());
            tag.method_10569("CheckBoxOffsetY", this.checkBoxOffset.method_10264());
            tag.method_10569("CheckBoxOffsetZ", this.checkBoxOffset.method_10260());
        }
        if (this.checkRange != null) {
            tag.method_10569("CheckRangeX", this.checkRange.method_10263());
            tag.method_10569("CheckRangeY", this.checkRange.method_10264());
            tag.method_10569("CheckRangeZ", this.checkRange.method_10260());
        }
        if (this.requiredAdvancement != null) {
            tag.method_10582("RequiredAdvancement", this.requiredAdvancement.toString());
        }
        if (this.requiredEffect != null && (effectIdentifier = class_2378.field_11159.method_10221((Object)this.requiredEffect)) != null) {
            tag.method_10582("RequiredStatusEffect", effectIdentifier.toString());
        }
        if (this.unlockedAdvancement != null && this.unlockedAdvancementCriterion != null) {
            tag.method_10582("UnlockedAdvancement", this.unlockedAdvancement.toString());
            tag.method_10582("UnlockedAdvancementCriterion", this.unlockedAdvancementCriterion);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("EntranceOffsetX") && tag.method_10545("EntranceOffsetY") && tag.method_10545("EntranceOffsetZ")) {
            this.entranceOffset = new class_2382(tag.method_10550("EntranceOffsetX"), tag.method_10550("EntranceOffsetY"), tag.method_10550("EntranceOffsetZ"));
        }
        if (tag.method_10545("CheckBoxOffsetX") && tag.method_10545("CheckBoxOffsetY") && tag.method_10545("CheckBoxOffsetZ")) {
            this.checkBoxOffset = new class_2382(tag.method_10550("CheckBoxOffsetX"), tag.method_10550("CheckBoxOffsetY"), tag.method_10550("CheckBoxOffsetZ"));
        }
        if (tag.method_10545("CheckRangeX")) {
            this.checkRange = new class_2382(tag.method_10550("CheckRangeX"), tag.method_10550("CheckRangeY"), tag.method_10550("CheckRangeZ"));
        }
        if (tag.method_10573("RequiredStatusEffect", 8)) {
            class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(new class_2960(tag.method_10558("RequiredStatusEffect")));
            if (this.requiredEffect != null) {
                this.requiredEffect = statusEffect;
            }
        }
        if (tag.method_10573("RequiredAdvancement", 8)) {
            this.requiredAdvancement = new class_2960(tag.method_10558("RequiredAdvancement"));
        }
        if (tag.method_10573("UnlockedAdvancement", 8) && tag.method_10573("UnlockedAdvancementCriterion", 8)) {
            this.unlockedAdvancement = class_2960.method_12829((String)tag.method_10558("UnlockedAdvancement"));
            this.unlockedAdvancementCriterion = tag.method_10558("UnlockedAdvancementCriterion");
        }
    }

    public void spawnParticles() {
        if (this.spawnParticles) {
            if (this.checkBox != null) {
                class_2338 centerPos = this.field_11867;
                if (this.checkBoxOffset != null) {
                    centerPos = Support.directionalOffset(this.field_11867, this.checkBoxOffset, (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)PreservationControllerBlock.FACING));
                }
                SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)this.field_11863, class_243.method_24953((class_2382)centerPos), (class_2394)class_2398.field_11240, 1, new class_243(0.0, 0.0, 0.0), new class_243(0.1, 0.1, 0.1));
                SpectrumS2CPacketSender.playParticleWithExactOffsetAndVelocity((class_3218)this.field_11863, class_243.method_24953((class_2382)centerPos), (class_2394)class_2398.field_11251, 250, new class_243(this.checkBox.method_17939() / 2.0, this.checkBox.method_17940() / 2.0, this.checkBox.method_17941() / 2.0), new class_243(0.0, 0.0, 0.0));
            }
            if (this.destinationPos != null) {
                SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)this.field_11863, class_243.method_24953((class_2382)this.destinationPos), (class_2394)class_2398.field_11207, 1, new class_243(0.0, 0.0, 0.0), new class_243(0.1, 0.1, 0.1));
            }
        }
    }

    public void toggleParticles() {
        this.spawnParticles = true;
    }

    public void openExit() {
        boolean didSomething = false;
        class_2350 facing = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)PreservationControllerBlock.FACING);
        if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
            for (int x = -1; x < 2; ++x) {
                for (int y = -3; y < 0; ++y) {
                    class_2338 offsetPos = this.field_11867.method_10069(x, y, 0);
                    class_2680 offsetState = this.field_11863.method_8320(offsetPos);
                    if (!offsetState.method_26164(SpectrumBlockTags.UNBREAKABLE_STRUCTURE_BLOCKS)) continue;
                    this.field_11863.method_8501(offsetPos, SpectrumBlocks.POLISHED_CALCITE.method_9564());
                    this.field_11863.method_8474(2001, offsetPos, class_2248.method_9507((class_2680)offsetState));
                    didSomething = true;
                }
            }
        } else {
            for (int z = -1; z < 2; ++z) {
                for (int y = -3; y < 0; ++y) {
                    class_2338 offsetPos = this.field_11867.method_10069(0, y, z);
                    class_2680 offsetState = this.field_11863.method_8320(offsetPos);
                    if (!offsetState.method_26164(SpectrumBlockTags.UNBREAKABLE_STRUCTURE_BLOCKS)) continue;
                    this.field_11863.method_8501(offsetPos, SpectrumBlocks.POLISHED_CALCITE.method_9564());
                    this.field_11863.method_8474(2001, offsetPos, class_2248.method_9507((class_2680)offsetState));
                    didSomething = true;
                }
            }
        }
        if (didSomething) {
            this.field_11863.method_8396(null, this.field_11867, SpectrumSoundEvents.STRUCTURE_SUCCESS, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public void yeetPlayer(@NotNull class_1657 player) {
        if (this.destinationPos != null) {
            player.method_5643(SpectrumDamageSources.DIKE_GATE, 1.0f);
            class_243 vec = class_243.method_24953((class_2382)this.destinationPos);
            player.method_5859(vec.method_10216(), vec.method_10214(), vec.method_10215());
            this.field_11863.method_8396(null, this.destinationPos, SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void yeetUnworthyPlayersAndGrantAdvancement() {
        if (this.checkBox != null) {
            List players = this.field_11863.method_18023((class_5575)class_1299.field_6097, this.checkBox, class_1309::method_5805);
            for (class_1657 playerEntity : players) {
                if (playerEntity.method_7337() || playerEntity.method_7325()) continue;
                if (this.requiredAdvancement != null && AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.requiredAdvancement)) {
                    if (this.unlockedAdvancement == null || this.unlockedAdvancementCriterion == null) continue;
                    Support.grantAdvancementCriterion((class_3222)playerEntity, this.unlockedAdvancement, this.unlockedAdvancementCriterion);
                    continue;
                }
                if (this.requiredEffect != null && playerEntity.method_6059(this.requiredEffect)) {
                    if (this.unlockedAdvancement == null || this.unlockedAdvancementCriterion == null) continue;
                    Support.grantAdvancementCriterion((class_3222)playerEntity, this.unlockedAdvancement, this.unlockedAdvancementCriterion);
                    continue;
                }
                this.yeetPlayer(playerEntity);
            }
        }
    }
}

