/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.titration_barrel;

import de.dafuqs.spectrum.blocks.titration_barrel.TitrationBarrelBlock;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import java.util.Date;
import java.util.Optional;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitrationBarrelBlockEntity
extends class_2586 {
    protected static final int INVENTORY_SIZE = 5;
    public static final int MAX_ITEM_COUNT = 64;
    protected class_1277 inventory = new class_1277(5);
    @NotNull
    protected class_3611 storedFluid = class_3612.field_15906;
    protected long sealTime = -1L;
    protected long tapTime = -1L;
    protected String recipe;
    protected int extractedBottles = 0;

    public TitrationBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.TITRATION_BARREL, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660());
        nbt.method_10582("Fluid", class_2378.field_11154.method_10221((Object)this.storedFluid).toString());
        nbt.method_10544("SealTime", this.sealTime);
        nbt.method_10544("TapTime", this.tapTime);
        nbt.method_10569("ExtractedBottles", this.extractedBottles);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = new class_1277(5);
        if (nbt.method_10573("Inventory", 9)) {
            this.inventory.method_7659(nbt.method_10554("Inventory", 10));
        }
        this.storedFluid = (class_3611)class_2378.field_11154.method_10223(class_2960.method_12829((String)nbt.method_10558("Fluid")));
        this.sealTime = nbt.method_10573("SealTime", 4) ? nbt.method_10537("SealTime") : -1L;
        this.tapTime = nbt.method_10573("TapTime", 4) ? nbt.method_10537("TapTime") : -1L;
        this.extractedBottles = nbt.method_10573("ExtractedBottles", 3) ? nbt.method_10550("ExtractedBottles") : 0;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public boolean useBucket(class_1937 world, class_2338 pos, class_2680 state, class_1799 bucketStack, class_1657 player, class_1268 hand) {
        class_3611 bucketFluid = ((BucketItemAccessor)bucketStack.method_7909()).fabric_getFluid();
        if (this.storedFluid == class_3612.field_15906 && bucketFluid != class_3612.field_15906) {
            if (!player.method_7337()) {
                class_1792 remainderItem = bucketStack.method_7909().method_7858();
                bucketStack.method_7934(1);
                player.method_6122(hand, bucketStack);
                if (remainderItem != null) {
                    player.method_7270(remainderItem.method_7854());
                }
            }
            Optional soundEvent = bucketFluid.method_32359();
            soundEvent.ifPresent(event -> world.method_8396(null, this.field_11867, event, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f));
            this.storedFluid = bucketFluid;
            this.method_5431();
            if (state.method_11654(TitrationBarrelBlock.BARREL_STATE) == TitrationBarrelBlock.BarrelState.EMPTY) {
                world.method_8501(pos, (class_2680)state.method_11657(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.FILLED)));
            }
            return true;
        }
        if (this.sealTime == -1L && this.storedFluid != class_3612.field_15906 && bucketFluid == class_3612.field_15906) {
            player.method_6122(hand, class_5328.method_30012((class_1799)bucketStack, (class_1657)player, (class_1799)this.storedFluid.method_15774().method_7854()));
            Optional soundEvent = this.storedFluid.method_32359();
            soundEvent.ifPresent(event -> world.method_8396(null, this.field_11867, event, class_3419.field_15248, 0.8f, 0.8f + world.field_9229.method_43057() * 0.6f));
            if (state.method_11654(TitrationBarrelBlock.BARREL_STATE) == TitrationBarrelBlock.BarrelState.FILLED && this.inventory.method_5442()) {
                world.method_8501(pos, (class_2680)state.method_11657(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.EMPTY)));
            }
            this.storedFluid = class_3612.field_15906;
            this.method_5431();
            return true;
        }
        return false;
    }

    public void seal() {
        this.sealTime = new Date().getTime();
        this.method_5431();
        this.field_11863.method_8433().method_8132(SpectrumRecipeTypes.TITRATION_BARREL, (class_1263)this.inventory, this.field_11863);
    }

    public void tap() {
        this.tapTime = new Date().getTime();
        this.method_5431();
    }

    public void reset(class_1937 world, class_2338 blockPos, class_2680 state) {
        this.sealTime = -1L;
        this.tapTime = -1L;
        this.storedFluid = class_3612.field_15906;
        this.extractedBottles = 0;
        this.inventory.method_5448();
        world.method_8501(this.field_11867, (class_2680)state.method_11657(TitrationBarrelBlock.BARREL_STATE, (Comparable)((Object)TitrationBarrelBlock.BarrelState.EMPTY)));
        world.method_8396(null, blockPos, class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
    }

    public long getSealMilliseconds() {
        if (this.sealTime == -1L) {
            return 0L;
        }
        long tapTime = this.tapTime == -1L ? new Date().getTime() : this.tapTime;
        return tapTime - this.sealTime;
    }

    public long getSealSeconds() {
        return this.getSealMilliseconds() / 1000L;
    }

    public int getSealMinecraftDays() {
        return (int)this.getSealMilliseconds() / 1000 / 60 / 20;
    }

    public String getSealRealDays() {
        return Support.getWithOneDecimalAfterComma(this.getSealMilliseconds() / 1000L / 60L / 20L / 72L);
    }

    private boolean isEmpty(float temperature, int extractedBottles, ITitrationBarrelRecipe recipe) {
        if (recipe.method_31584() || recipe.getFluid() != this.storedFluid) {
            return true;
        }
        return extractedBottles >= recipe.getOutputCountAfterAngelsShare(temperature, this.getSealSeconds());
    }

    public void addDayOfSealTime() {
        this.sealTime -= TimeHelper.EPOCH_DAY_MILLIS;
        this.method_5431();
    }

    public class_1799 tryHarvest(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1799 handStack, @Nullable class_1657 player) {
        class_1799 harvestedStack = class_1799.field_8037;
        class_1959 biome = (class_1959)world.method_23753(blockPos).comp_349();
        Optional<ITitrationBarrelRecipe> optionalRecipe = this.getRecipeForInventory(world);
        if (optionalRecipe.isEmpty()) {
            if (player != null) {
                if (this.inventory.method_5442() && this.storedFluid == class_3612.field_15906) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.empty_when_tapping"), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping"), false);
                }
            }
        } else {
            ITitrationBarrelRecipe recipe = optionalRecipe.get();
            if (this.storedFluid == recipe.getFluid() && recipe.canPlayerCraft(player)) {
                boolean canTap;
                class_1792 tappingItem = recipe.getTappingItem();
                boolean bl = canTap = tappingItem == class_1802.field_8162;
                if (!canTap) {
                    if (handStack.method_31574(tappingItem)) {
                        handStack.method_7934(1);
                        canTap = true;
                    } else if (player != null) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.tapping_item_required").method_10852(tappingItem.method_7848()), false);
                    }
                }
                if (canTap) {
                    long secondsFermented = (this.tapTime - this.sealTime) / 1000L;
                    harvestedStack = recipe.tap((class_1263)this.inventory, secondsFermented, biome.method_8715(), biome.method_8712());
                    ++this.extractedBottles;
                }
            } else if (player != null) {
                if (this.storedFluid == class_3612.field_15906) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.missing_water_when_tapping"), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.spectrum.titration_barrel.invalid_recipe_when_tapping"), false);
                }
            }
        }
        if (player != null) {
            int daysSealed = this.getSealMinecraftDays();
            int inventoryCount = InventoryHelper.countItemsInInventory((class_1263)this.inventory);
            SpectrumAdvancementCriteria.TITRATION_BARREL_TAPPING.trigger((class_3222)player, harvestedStack, daysSealed, inventoryCount);
        }
        if (optionalRecipe.isEmpty() || this.isEmpty(biome.method_8712(), this.extractedBottles, optionalRecipe.get()) || !optionalRecipe.get().canPlayerCraft(player)) {
            this.reset(world, blockPos, blockState);
        }
        this.method_5431();
        return harvestedStack;
    }

    public Optional<ITitrationBarrelRecipe> getRecipeForInventory(class_1937 world) {
        return world.method_8433().method_8132(SpectrumRecipeTypes.TITRATION_BARREL, (class_1263)this.inventory, world);
    }

    public void giveRecipeRemainders(class_1657 player) {
        for (class_1799 stack : this.inventory.field_5828) {
            class_1792 item = stack.method_7909();
            class_1792 remainderItem = item.method_7858();
            if (remainderItem == null) continue;
            class_1799 remainderStack = remainderItem.method_7854();
            remainderStack.method_7939(stack.method_7947());
            Support.givePlayer(player, remainderStack);
        }
    }
}

