/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.upgrade;

import com.google.common.collect.Maps;
import de.dafuqs.spectrum.blocks.upgrade.UpgradeBlock;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Upgradeable {
    public static class_2499 toNbt(@NotNull Map<UpgradeType, Float> upgrades) {
        class_2499 nbtList = new class_2499();
        if (!upgrades.isEmpty()) {
            for (Map.Entry<UpgradeType, Float> upgrade : upgrades.entrySet()) {
                class_2487 upgradeCompound = new class_2487();
                upgradeCompound.method_10582("Type", upgrade.getKey().toString());
                upgradeCompound.method_10548("Power", upgrade.getValue().floatValue());
                nbtList.add((Object)upgradeCompound);
            }
        }
        return nbtList;
    }

    public static Map<UpgradeType, Float> fromNbt(@NotNull class_2499 nbtList) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            UpgradeType upgradeType = UpgradeType.valueOf(nbtCompound.method_10558("Type"));
            float upgradeMod = nbtCompound.method_10583("Power");
            map.put(upgradeType, Float.valueOf(upgradeMod));
        }
        return map;
    }

    @NotNull
    public static Map<UpgradeType, Float> calculateUpgradeMods4(class_1937 world, @NotNull class_2338 blockPos, int horizontalOffset, int verticalOffset, @Nullable UUID advancementPlayerUUID) {
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        posList.add(blockPos.method_10069(horizontalOffset, verticalOffset, horizontalOffset));
        posList.add(blockPos.method_10069(horizontalOffset, verticalOffset, -horizontalOffset));
        posList.add(blockPos.method_10069(-horizontalOffset, verticalOffset, horizontalOffset));
        posList.add(blockPos.method_10069(-horizontalOffset, verticalOffset, -horizontalOffset));
        return Upgradeable.calculateUpgrades(world, blockPos, posList, advancementPlayerUUID);
    }

    @NotNull
    public static Map<UpgradeType, Float> calculateUpgradeMods2(class_1937 world, class_2338 blockPos, @NotNull class_2470 multiblockRotation, int horizontalOffset, int verticalOffset, @Nullable UUID advancementPlayerUUID) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        switch (multiblockRotation) {
            case field_11467: {
                positions.add(blockPos.method_10069(horizontalOffset, verticalOffset, -horizontalOffset));
                positions.add(blockPos.method_10069(horizontalOffset, verticalOffset, horizontalOffset));
                break;
            }
            case field_11463: {
                positions.add(blockPos.method_10069(-horizontalOffset, verticalOffset, horizontalOffset));
                positions.add(blockPos.method_10069(horizontalOffset, verticalOffset, horizontalOffset));
                break;
            }
            case field_11464: {
                positions.add(blockPos.method_10069(-horizontalOffset, verticalOffset, horizontalOffset));
                positions.add(blockPos.method_10069(-horizontalOffset, verticalOffset, -horizontalOffset));
                break;
            }
            default: {
                positions.add(blockPos.method_10069(-horizontalOffset, verticalOffset, horizontalOffset));
                positions.add(blockPos.method_10069(horizontalOffset, verticalOffset, -horizontalOffset));
            }
        }
        return Upgradeable.calculateUpgrades(world, blockPos, positions, advancementPlayerUUID);
    }

    @NotNull
    public static Map<UpgradeType, Float> calculateUpgradeMods2(class_1937 world, class_2338 blockPos, @NotNull class_2470 multiblockRotation, int horizontalOffsetX, int horizontalOffsetZ, int verticalOffset, @Nullable UUID advancementPlayerUUID) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        switch (multiblockRotation) {
            case field_11467: {
                positions.add(blockPos.method_10069(-horizontalOffsetZ, verticalOffset, -horizontalOffsetX));
                positions.add(blockPos.method_10069(-horizontalOffsetZ, verticalOffset, horizontalOffsetX));
                break;
            }
            case field_11463: {
                positions.add(blockPos.method_10069(-horizontalOffsetX, verticalOffset, horizontalOffsetZ));
                positions.add(blockPos.method_10069(-horizontalOffsetX, verticalOffset, -horizontalOffsetZ));
                break;
            }
            case field_11464: {
                positions.add(blockPos.method_10069(horizontalOffsetZ, verticalOffset, horizontalOffsetX));
                positions.add(blockPos.method_10069(horizontalOffsetZ, verticalOffset, -horizontalOffsetX));
                break;
            }
            default: {
                positions.add(blockPos.method_10069(-horizontalOffsetX, verticalOffset, horizontalOffsetZ));
                positions.add(blockPos.method_10069(horizontalOffsetX, verticalOffset, horizontalOffsetZ));
            }
        }
        return Upgradeable.calculateUpgrades(world, blockPos, positions, advancementPlayerUUID);
    }

    @NotNull
    private static Map<UpgradeType, Float> calculateUpgrades(class_1937 world, class_2338 blockPos, @NotNull List<class_2338> positions, @Nullable UUID advancementPlayerUUID) {
        class_3222 class_32222;
        HashMap upgradeMods = new HashMap();
        int upgradeCount = 0;
        for (class_2338 class_23382 : positions) {
            class_2248 block = world.method_8320(class_23382).method_26204();
            if (!(block instanceof UpgradeBlock)) continue;
            UpgradeBlock upgradeBlock = (UpgradeBlock)block;
            UpgradeType upgradeType = upgradeBlock.getUpgradeType();
            float upgradeMod = upgradeBlock.getUpgradeMod();
            if (upgradeMods.containsKey((Object)upgradeType)) {
                ((List)upgradeMods.get((Object)upgradeType)).add(Float.valueOf(upgradeMod));
            } else {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                arrayList.add(Float.valueOf(upgradeMod));
                upgradeMods.put(upgradeType, arrayList);
            }
            ++upgradeCount;
        }
        LinkedHashMap upgradeMap = Maps.newLinkedHashMap();
        for (UpgradeType upgradeType : UpgradeType.values()) {
            if (upgradeMods.containsKey((Object)upgradeType)) {
                List upgradeModList = (List)upgradeMods.get((Object)upgradeType);
                Collections.sort(upgradeModList);
                Collections.reverse(upgradeModList);
                float resultingMod = 0.0f;
                for (int i = 0; i < upgradeModList.size(); ++i) {
                    resultingMod += ((Float)upgradeModList.get(i)).floatValue() * ((4.0f - (float)i) / 4.0f);
                }
                upgradeMap.put(upgradeType, Float.valueOf(1.0f + resultingMod));
                continue;
            }
            upgradeMap.put(upgradeType, Float.valueOf(1.0f));
        }
        if (advancementPlayerUUID != null && !world.field_9236 && (class_32222 = (class_3222)PlayerOwned.getPlayerEntityIfOnline(advancementPlayerUUID)) != null) {
            SpectrumAdvancementCriteria.UPGRADE_PLACING.trigger(class_32222, (class_3218)world, blockPos, upgradeCount, upgradeMap);
        }
        return upgradeMap;
    }

    public void resetUpgrades();

    public void calculateUpgrades();

    public float getUpgradeValue(UpgradeType var1);

    public static enum UpgradeType {
        SPEED,
        EFFICIENCY,
        YIELD,
        EXPERIENCE;

    }
}

