/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.dafuqs.revelationary.RevelationRegistry;
import de.dafuqs.revelationary.advancement_criteria.AdvancementGottenCriterion;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.enchanter.EnchanterEnchantable;
import de.dafuqs.spectrum.enchantments.SpectrumEnchantment;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.mixin.accessors.LootTableAccessor;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class SanityCommand {
    private static final List<class_2960> advancementGatingWarningWhitelist = new ArrayList<class_2960>(){
        {
            this.add(SpectrumCommon.locate("find_ancient_ruins"));
            this.add(SpectrumCommon.locate("hook_entity_with_molten_rod"));
            this.add(SpectrumCommon.locate("midgame/take_off_belt_overcharged"));
            this.add(SpectrumCommon.locate("midgame/craft_blacklisted_memory_fail"));
            this.add(SpectrumCommon.locate("midgame/craft_blacklisted_memory_success"));
            this.add(SpectrumCommon.locate("midgame/build_cinderhearth_structure_without_lava"));
            this.add(SpectrumCommon.locate("tap_aged_air"));
            this.add(SpectrumCommon.locate("midgame/tap_chrysocolla"));
        }
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spectrum_sanity").requires(source -> source.method_9259(2))).executes(context -> SanityCommand.execute((class_2168)context.getSource())));
    }

    private static int execute(class_2168 source) {
        class_5321 registryKey;
        SpectrumCommon.logInfo("##### SANITY CHECK START ######");
        for (Map.Entry entry : class_2378.field_11146.method_29722()) {
            class_2680 blockState;
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals("spectrum") || (blockState = ((class_2248)entry.getValue()).method_9564()).method_26204().method_36555() <= -1.0f || blockState.method_26164(class_3481.field_33715) || blockState.method_26164(class_3481.field_33713) || blockState.method_26164(class_3481.field_33716) || blockState.method_26164(class_3481.field_33714) || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_MINEABLE_DEBUG_CHECK)) continue;
            SpectrumCommon.logWarning("[SANITY: Mineable Tags] Block " + registryKey.method_29177() + " is not contained in a any vanilla mineable tag.");
        }
        for (Map.Entry entry : class_2378.field_11146.method_29722()) {
            registryKey = (class_5321)entry.getKey();
            if (!registryKey.method_29177().method_12836().equals("spectrum")) continue;
            class_2248 block = (class_2248)entry.getValue();
            class_2680 blockState = ((class_2248)entry.getValue()).method_9564();
            class_2960 class_29602 = block.method_26162();
            if (blockState.method_26204().method_36555() <= -1.0f || blockState.method_26164(SpectrumBlockTags.EXEMPT_FROM_LOOT_TABLE_DEBUG_CHECK)) continue;
            if (class_29602.equals((Object)class_39.field_844) || class_29602.method_12832().equals("blocks/air")) {
                SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + registryKey.method_29177() + " has a non-existent loot table");
                continue;
            }
            class_52 lootTable = source.method_9225().method_8503().method_3857().method_367(class_29602);
            class_55[] class_55Array = ((LootTableAccessor)lootTable).getPools();
            if (class_55Array.length != 0) continue;
            SpectrumCommon.logWarning("[SANITY: Loot Tables] Block " + registryKey.method_29177() + " has an empty loot table");
        }
        HashMap usedColorsForEachTier = new HashMap();
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap<BuiltinGemstoneColor, Integer> hashMap = new HashMap<BuiltinGemstoneColor, Integer>();
            for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
                hashMap.put(gemstoneColor, 0);
            }
            usedColorsForEachTier.put((Object)((Object)pedestalRecipeTier), hashMap);
        }
        MinecraftServer minecraftServer = source.method_9225().method_8503();
        class_1863 recipeManager = minecraftServer.method_3772();
        class_2989 advancementLoader = minecraftServer.method_3851();
        for (PedestalCraftingRecipe pedestalCraftingRecipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            if (pedestalCraftingRecipe.getTier() == PedestalRecipeTier.BASIC || pedestalCraftingRecipe.getTier() == PedestalRecipeTier.SIMPLE) {
                if (pedestalCraftingRecipe.getGemstonePowderInputs().getOrDefault(BuiltinGemstoneColor.BLACK, 0) > 0) {
                    SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalCraftingRecipe.method_8114() + "' of tier '" + pedestalCraftingRecipe.getTier() + "' is using onyx powder as input! Players will not have access to Onyx at that tier");
                }
                if (pedestalCraftingRecipe.getGemstonePowderInputs().getOrDefault(BuiltinGemstoneColor.WHITE, 0) > 0) {
                    SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalCraftingRecipe.method_8114() + "' of tier '" + pedestalCraftingRecipe.getTier() + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
                }
            } else if (pedestalCraftingRecipe.getTier() == PedestalRecipeTier.ADVANCED && pedestalCraftingRecipe.getGemstonePowderInputs().getOrDefault(BuiltinGemstoneColor.WHITE, 0) > 0) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipe Ingredients] Pedestal recipe '" + pedestalCraftingRecipe.method_8114() + "' of tier '" + pedestalCraftingRecipe.getTier() + "' is using moonstone powder as input! Players will not have access to Moonstone at that tier");
            }
            for (Map.Entry entry : pedestalCraftingRecipe.getGemstonePowderInputs().entrySet()) {
                ((HashMap)usedColorsForEachTier.get((Object)pedestalCraftingRecipe.getTier())).put((BuiltinGemstoneColor)entry.getKey(), (Integer)((HashMap)usedColorsForEachTier.get((Object)pedestalCraftingRecipe.getTier())).get(entry.getKey()) + (Integer)entry.getValue());
            }
        }
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.PEDESTAL, "Pedestal", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ANVIL_CRUSHING, "Anvil Crushing", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_BREWING, "Potion Workshop Brewing", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING, "Potion Workshop Reagent", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.POTION_WORKSHOP_REACTING, "Potion Workshop Crafting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING, "Midnight Solution Converting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.SPIRIT_INSTILLING, "Spirit Instilling", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.INK_CONVERTING, "Ink Converting", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.CRYSTALLARIEUM, "Crystallarieum", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.CINDERHEARTH, "Cinderhearth", recipeManager, advancementLoader);
        SanityCommand.testRecipeUnlocks(SpectrumRecipeTypes.TITRATION_BARREL, "Titration Barrel", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.FUSION_SHRINE, "Fusion Shrine", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTER, "Enchanting", recipeManager, advancementLoader);
        SanityCommand.testIngredientsAndOutputInColorRegistry(SpectrumRecipeTypes.ENCHANTMENT_UPGRADE, "Enchantment Upgrade", recipeManager, advancementLoader);
        for (Map.Entry entry : RevelationRegistry.getBlockStateEntries().entrySet()) {
            if (advancementLoader.method_12896((class_2960)entry.getKey()) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Block Cloaks] Advancement '" + ((class_2960)entry.getKey()).toString() + "' for block / item cloaking does not exist. Registered cloaks: " + ((List)entry.getValue()).size());
        }
        for (class_161 class_1612 : advancementLoader.method_12893()) {
            for (class_175 class_1752 : class_1612.method_682().values()) {
                AdvancementGottenCriterion.Conditions hasAdvancementConditions;
                class_2960 advancementIdentifier;
                class_161 advancementCriterionAdvancement;
                class_184 conditions = class_1752.method_774();
                class_2960 id = conditions.method_806();
                if (!id.equals((Object)AdvancementGottenCriterion.ID) || !(conditions instanceof AdvancementGottenCriterion.Conditions) || (advancementCriterionAdvancement = advancementLoader.method_12896(advancementIdentifier = (hasAdvancementConditions = (AdvancementGottenCriterion.Conditions)conditions).getAdvancementIdentifier())) != null) continue;
                SpectrumCommon.logWarning("[SANITY: Has_Advancement Criteria] Advancement '" + class_1612.method_688() + "' references advancement '" + advancementIdentifier + "' that does not exist");
            }
        }
        for (class_161 class_1613 : advancementLoader.method_12893()) {
            if (!class_1613.method_688().method_12836().equals("spectrum") || class_1613.method_688().method_12832().contains("hidden") || class_1613.method_688().method_12832().contains("progression") || class_1613.method_688().method_12832().contains("milestones") || class_1613.method_687() == null) continue;
            class_2960 previousAdvancementIdentifier = null;
            for (String[] requirement : class_1613.method_680()) {
                if (requirement.length <= 0 || !requirement[0].equals("gotten_previous")) continue;
                class_184 conditions = ((class_175)class_1613.method_682().get("gotten_previous")).method_774();
                if (conditions instanceof AdvancementGottenCriterion.Conditions) {
                    AdvancementGottenCriterion.Conditions advancementConditions = (AdvancementGottenCriterion.Conditions)conditions;
                    previousAdvancementIdentifier = advancementConditions.getAdvancementIdentifier();
                    break;
                }
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + class_1613.method_688() + "' has a \"gotten_previous\" requirement, but its not spectrum:has_advancement?");
            }
            if (advancementGatingWarningWhitelist.contains(class_1613.method_688())) continue;
            if (previousAdvancementIdentifier == null) {
                SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + class_1613.method_688() + "' does not have its parent set as requirement");
                continue;
            }
            if (class_1613.method_687().method_688().equals(previousAdvancementIdentifier)) continue;
            SpectrumCommon.logWarning("[SANITY: Advancement Gating] Advancement '" + class_1613.method_688() + "' has its \"gotten_previous\" advancement set to something else than their parent. Intended?");
        }
        for (PedestalCraftingRecipe pedestalCraftingRecipe : recipeManager.method_30027(SpectrumRecipeTypes.PEDESTAL)) {
            class_2960 id = pedestalCraftingRecipe.method_8114();
            if (id.method_12832().contains("/glass/") || id.method_12832().contains("/saplings/") || id.method_12832().contains("/detectors/") || id.method_12832().contains("/gem_lamps/") || id.method_12832().contains("/decostones/") || id.method_12832().contains("/runes/") || id.method_12832().contains("/pastel_network/") || id.method_12832().contains("/gemstone_chimes/") || id.method_12832().contains("/pastel_network/") || id.method_12832().contains("/player_only_glass/")) continue;
            if (pedestalCraftingRecipe.getTier() == PedestalRecipeTier.BASIC && !id.method_12832().contains("/tier1/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] BASIC Recipe not in the correct tier folder: '" + id + "'");
                continue;
            }
            if (pedestalCraftingRecipe.getTier() == PedestalRecipeTier.SIMPLE && !id.method_12832().contains("/tier2/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] SIMPLE Recipe not in the correct tier folder: '" + id + "'");
                continue;
            }
            if (pedestalCraftingRecipe.getTier() == PedestalRecipeTier.ADVANCED && !id.method_12832().contains("/tier3/")) {
                SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] ADVANCED Recipe not in the correct tier folder: '" + id + "'");
                continue;
            }
            if (pedestalCraftingRecipe.getTier() != PedestalRecipeTier.COMPLEX || id.method_12832().contains("/tier4/")) continue;
            SpectrumCommon.logWarning("[SANITY: Pedestal Recipes] COMPLEX Recipe not in the correct tier folder: '" + id + "'");
        }
        for (AnvilCrushingRecipe anvilCrushingRecipe : recipeManager.method_30027(SpectrumRecipeTypes.ANVIL_CRUSHING)) {
            class_3414 soundEvent = anvilCrushingRecipe.getSoundEvent();
            if (soundEvent != null) continue;
            SpectrumCommon.logWarning("[SANITY: Item Crushing] Recipe '" + anvilCrushingRecipe.method_8114() + "' has a nonexistent sound set");
        }
        for (Map.Entry entry : class_2378.field_11160.method_29722()) {
            SpectrumEnchantment spectrumEnchantment;
            class_2960 class_29603;
            class_161 advancementCriterionAdvancement;
            Object v = entry.getValue();
            if (!(v instanceof SpectrumEnchantment) || (advancementCriterionAdvancement = advancementLoader.method_12896(class_29603 = (spectrumEnchantment = (SpectrumEnchantment)((Object)v)).getUnlockAdvancementIdentifier())) != null) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantments] Enchantment '" + ((class_5321)entry.getKey()).method_29177() + "' references advancement '" + class_29603 + "' that does not exist");
        }
        for (Map.Entry entry : class_2378.field_11142.method_29722()) {
            class_1792 i = (class_1792)entry.getValue();
            if (!(i instanceof EnchanterEnchantable) || i.method_7837() >= 1) continue;
            SpectrumCommon.logWarning("[SANITY: Enchantability] Item '" + ((class_5321)entry.getKey()).method_29177() + "' is EnchanterEnchantable, but has enchantability of < 1");
        }
        SpectrumCommon.logInfo("##### SANITY CHECK FINISHED ######");
        SpectrumCommon.logInfo("##### SANITY CHECK PEDESTAL RECIPE STATISTICS ######");
        for (PedestalRecipeTier pedestalRecipeTier : PedestalRecipeTier.values()) {
            HashMap entry = (HashMap)usedColorsForEachTier.get((Object)pedestalRecipeTier);
            SpectrumCommon.logInfo("[SANITY: Pedestal Recipe Gemstone Usages] Gemstone Powder for tier " + StringUtils.leftPad((String)pedestalRecipeTier.toString(), (int)8) + ": C:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.CYAN)).toString(), (int)3) + " M:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.MAGENTA)).toString(), (int)3) + " Y:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.YELLOW)).toString(), (int)3) + " K:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.BLACK)).toString(), (int)3) + " W:" + StringUtils.leftPad((String)((Integer)entry.get(BuiltinGemstoneColor.WHITE)).toString(), (int)3));
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_12972;
            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"commands.spectrum.progression_sanity.success"), false);
        }
        return 0;
    }

    private static <R extends GatedRecipe> void testRecipeUnlocks(class_3956<R> recipeType, String name, class_1863 recipeManager, class_2989 advancementLoader) {
        for (GatedRecipe recipe : recipeManager.method_30027(recipeType)) {
            class_2960 advancementIdentifier = recipe.getRequiredAdvancementIdentifier();
            if (advancementIdentifier == null || advancementLoader.method_12896(advancementIdentifier) != null) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe Unlocks] Advancement '" + recipe.getRequiredAdvancementIdentifier() + "' in recipe '" + recipe.method_8114() + "' does not exist");
        }
    }

    private static <R extends GatedRecipe> void testIngredientsAndOutputInColorRegistry(class_3956<R> recipeType, String name, class_1863 recipeManager, class_2989 advancementLoader) {
        for (GatedRecipe recipe : recipeManager.method_30027(recipeType)) {
            for (class_1856 inputIngredient : recipe.method_8117()) {
                for (class_1799 matchingItemStack : inputIngredient.method_8105()) {
                    if (!ColorRegistry.ITEM_COLORS.getMapping(matchingItemStack.method_7909()).isEmpty()) continue;
                    SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Input '" + class_2378.field_11142.method_10221((Object)matchingItemStack.method_7909()) + "' in recipe '" + recipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
                }
            }
            class_1792 outputItem = recipe.method_8110().method_7909();
            if (outputItem == null || outputItem == class_1802.field_8162 || !ColorRegistry.ITEM_COLORS.getMapping(outputItem).isEmpty()) continue;
            SpectrumCommon.logWarning("[SANITY: " + name + " Recipe] Output '" + class_2378.field_11142.method_10221((Object)outputItem) + "' in recipe '" + recipe.method_8114() + "', does not exist in the item color registry. Add it for nice effects!");
        }
    }
}

