/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.compat.REI.plugins.GatedDisplayCategory;
import de.dafuqs.spectrum.compat.REI.plugins.PedestalCraftingDisplay;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.inventories.PedestalScreen;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class PedestalCraftingCategory
extends GatedDisplayCategory<PedestalCraftingDisplay> {
    public CategoryIdentifier<PedestalCraftingDisplay> getCategoryIdentifier() {
        return SpectrumPlugins.PEDESTAL_CRAFTING;
    }

    public class_2960 getIdentifier() {
        return SpectrumCommon.locate("pedestal_crafting");
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.spectrum.rei.pedestal_crafting.title");
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST);
    }

    @Override
    public void setupWidgets(Point startPoint, Rectangle bounds, List<Widget> widgets, @NotNull PedestalCraftingDisplay display) {
        int gemstoneSlotStartX;
        class_2960 backgroundTexture = PedestalScreen.getBackgroundTextureForTier(display.getTier());
        widgets.add((Widget)Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 1 + 18)).animationDurationTicks((double)display.craftingTime));
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + 1 + y * 18)).disableBackground().markInput());
            }
        }
        List<EntryIngredient> input = display.getInputEntries();
        int shownGemstoneSlotCount = display.getTier() == PedestalRecipeTier.COMPLEX ? 5 : (display.getTier() == PedestalRecipeTier.ADVANCED ? 4 : 3);
        int gemstoneDustStartSlot = 9;
        for (int i = 0; i < 9; ++i) {
            if (input.get(i).isEmpty()) continue;
            ((Slot)slots.get(i)).disableBackground().entries((Collection)input.get(i));
        }
        int n = shownGemstoneSlotCount == 5 ? -45 : (gemstoneSlotStartX = shownGemstoneSlotCount == 4 ? -40 : -31);
        int gemstoneSlotTextureStartX = shownGemstoneSlotCount == 5 ? 43 : (shownGemstoneSlotCount == 4 ? 52 : 61);
        for (int x = 0; x < shownGemstoneSlotCount; ++x) {
            slots.add(Widgets.createSlot((Point)new Point(bounds.getCenterX() + x * 18 + gemstoneSlotStartX, startPoint.y + 1 + 60)).disableBackground().markInput());
            if (input.get(gemstoneDustStartSlot + x).isEmpty()) continue;
            ((Slot)slots.get(9 + x)).entries((Collection)input.get(gemstoneDustStartSlot + x));
        }
        widgets.addAll(slots);
        List<EntryIngredient> results = display.getOutputEntries();
        EntryIngredient result = EntryIngredient.of((Iterable)((Iterable)results.get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 1 + 19)).entries((Collection)result).disableBackground().markOutput());
        widgets.add(Widgets.createTexturedWidget((class_2960)backgroundTexture, (int)(bounds.getCenterX() + gemstoneSlotStartX - 1), (int)(startPoint.y + 1 + 59), (float)gemstoneSlotTextureStartX, (float)76.0f, (int)(18 * shownGemstoneSlotCount), (int)18));
        widgets.add(Widgets.createTexturedWidget((class_2960)backgroundTexture, (int)startPoint.x, (int)(startPoint.y + 1), (float)29.0f, (float)18.0f, (int)54, (int)54));
        widgets.add(Widgets.createTexturedWidget((class_2960)backgroundTexture, (int)(startPoint.x + 94 - 4), (int)(startPoint.y + 1 + 18 - 4), (float)122.0f, (float)32.0f, (int)26, (int)26));
        widgets.add(Widgets.createTexturedWidget((class_2960)backgroundTexture, (int)(startPoint.x + 94 - 12), (int)(startPoint.y + 1 + 18 + 20), (float)200.0f, (float)0.0f, (int)40, (int)16));
        class_5250 text = display.craftingTime == 20 ? class_2561.method_43469((String)"container.spectrum.rei.pedestal_crafting.crafting_time_one_second_and_xp", (Object[])new Object[]{1, Float.valueOf(display.experience)}) : class_2561.method_43469((String)"container.spectrum.rei.pedestal_crafting.crafting_time_and_xp", (Object[])new Object[]{display.craftingTime / 20, Float.valueOf(display.experience)});
        widgets.add((Widget)Widgets.createLabel((Point)new Point(startPoint.x, startPoint.y + 82), (class_2561)text).leftAligned().color(0x3F3F3F).noShadow());
    }

    public int getDisplayHeight() {
        return 100;
    }
}

