/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.REI.plugins;

import de.dafuqs.spectrum.compat.REI.GatedSpectrumDisplay;
import de.dafuqs.spectrum.compat.REI.REIHelper;
import de.dafuqs.spectrum.compat.REI.SpectrumPlugins;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;

public class PedestalCraftingDisplay
extends GatedSpectrumDisplay {
    protected final PedestalRecipeTier pedestalRecipeTier;
    protected final int width;
    protected final int height;
    protected final float experience;
    protected final int craftingTime;

    public PedestalCraftingDisplay(PedestalCraftingRecipe recipe) {
        super((GatedRecipe)recipe, PedestalCraftingDisplay.mapIngredients(recipe), Collections.singletonList(EntryIngredients.of((class_1799)recipe.method_8110())));
        this.pedestalRecipeTier = recipe.getTier();
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        this.experience = recipe.getExperience();
        this.craftingTime = recipe.getCraftingTime();
    }

    private static List<EntryIngredient> mapIngredients(PedestalCraftingRecipe recipe) {
        int yellow;
        int magenta;
        int i;
        int shownGemstoneSlotCount = recipe.getTier() == PedestalRecipeTier.COMPLEX ? 5 : (recipe.getTier() == PedestalRecipeTier.ADVANCED ? 4 : 3);
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(9 + shownGemstoneSlotCount);
        for (i = 0; i < 9 + shownGemstoneSlotCount; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < recipe.getIngredientStacks().size(); ++i) {
            list.set(PedestalCraftingDisplay.getSlotWithSize(recipe.getWidth(), i), REIHelper.ofIngredientStack((IngredientStack)recipe.getIngredientStacks().get(i)));
        }
        HashMap<BuiltinGemstoneColor, Integer> gemstonePowderInputs = recipe.getGemstonePowderInputs();
        int firstGemstoneSlotId = 9;
        int cyan = gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.CYAN, 0);
        if (cyan > 0) {
            list.set(firstGemstoneSlotId, EntryIngredients.of((class_1935)SpectrumItems.TOPAZ_POWDER, (int)cyan));
        }
        if ((magenta = gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.MAGENTA, 0).intValue()) > 0) {
            list.set(firstGemstoneSlotId + 1, EntryIngredients.of((class_1935)SpectrumItems.AMETHYST_POWDER, (int)magenta));
        }
        if ((yellow = gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.YELLOW, 0).intValue()) > 0) {
            list.set(firstGemstoneSlotId + 2, EntryIngredients.of((class_1935)SpectrumItems.CITRINE_POWDER, (int)yellow));
        }
        if (shownGemstoneSlotCount >= 4) {
            int white;
            int black = gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.BLACK, 0);
            if (black > 0) {
                list.set(firstGemstoneSlotId + 3, EntryIngredients.of((class_1935)SpectrumItems.ONYX_POWDER, (int)black));
            }
            if (shownGemstoneSlotCount == 5 && (white = gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.WHITE, 0).intValue()) > 0) {
                list.set(firstGemstoneSlotId + 4, EntryIngredients.of((class_1935)SpectrumItems.MOONSTONE_POWDER, (int)white));
            }
        }
        return list;
    }

    public static int getSlotWithSize(int recipeWidth, int index) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return 3 * y + x;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SpectrumPlugins.PEDESTAL_CRAFTING;
    }

    @Override
    public boolean isUnlocked() {
        return PedestalRecipeTier.hasUnlockedRequiredTier((class_1657)class_310.method_1551().field_1724, this.pedestalRecipeTier) && super.isUnlocked();
    }

    public PedestalRecipeTier getTier() {
        return this.pedestalRecipeTier;
    }
}

