/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.emi.recipes;

import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.compat.emi.GatedSpectrumEmiRecipe;
import de.dafuqs.spectrum.compat.emi.SpectrumEmiRecipeCategories;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.inventories.PedestalScreen;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PedestalCraftingEmiRecipeGated
extends GatedSpectrumEmiRecipe<PedestalCraftingRecipe> {
    private static final int GEMSTONE_SLOTS = 9;

    public PedestalCraftingEmiRecipeGated(PedestalCraftingRecipe recipe) {
        super(SpectrumEmiRecipeCategories.PEDESTAL_CRAFTING, recipe, 124, 90);
        this.input = PedestalCraftingEmiRecipeGated.getIngredients(recipe);
    }

    @Override
    public boolean isUnlocked() {
        class_310 client = class_310.method_1551();
        return PedestalRecipeTier.hasUnlockedRequiredTier((class_1657)client.field_1724, ((PedestalCraftingRecipe)this.recipe).getTier()) && super.isUnlocked();
    }

    private static List<EmiIngredient> getIngredients(PedestalCraftingRecipe recipe) {
        int i;
        int shownGemstoneSlotCount = recipe.getTier() == PedestalRecipeTier.COMPLEX ? 5 : (recipe.getTier() == PedestalRecipeTier.ADVANCED ? 4 : 3);
        ArrayList<EmiIngredient> list = new ArrayList<EmiIngredient>(9 + shownGemstoneSlotCount);
        for (i = 0; i < 9 + shownGemstoneSlotCount; ++i) {
            list.add((EmiIngredient)EmiStack.EMPTY);
        }
        for (i = 0; i < recipe.getIngredientStacks().size(); ++i) {
            list.set(PedestalCraftingEmiRecipeGated.getSlotWithSize(recipe.getWidth(), i), EmiIngredient.of(((IngredientStack)recipe.getIngredientStacks().get(i)).getStacks().stream().map(EmiStack::of).toList()));
        }
        for (i = 0; i < shownGemstoneSlotCount; ++i) {
            int amount = recipe.getGemstonePowderInputs().getOrDefault(BuiltinGemstoneColor.values()[i], 0);
            if (amount <= 0) continue;
            list.set(9 + i, (EmiIngredient)EmiStack.of((class_1935)PedestalBlockEntity.getGemstonePowderItemForSlot(9 + i), (long)amount));
        }
        return list;
    }

    public static int getSlotWithSize(int recipeWidth, int index) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return 3 * y + x;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgets) {
        int x;
        int shownGemstoneSlotCount = ((PedestalCraftingRecipe)this.recipe).getTier() == PedestalRecipeTier.COMPLEX ? 5 : (((PedestalCraftingRecipe)this.recipe).getTier() == PedestalRecipeTier.ADVANCED ? 4 : 3);
        int gemstoneSlotStartX = this.width / 2 + (shownGemstoneSlotCount == 5 ? -45 : (shownGemstoneSlotCount == 4 ? -40 : -31));
        int gemstoneSlotTextureStartX = shownGemstoneSlotCount == 5 ? 43 : (shownGemstoneSlotCount == 4 ? 52 : 61);
        class_2960 backgroundTexture = PedestalScreen.getBackgroundTextureForTier(((PedestalCraftingRecipe)this.recipe).getTier());
        widgets.addTexture(backgroundTexture, gemstoneSlotStartX, 59, 18 * shownGemstoneSlotCount, 18, gemstoneSlotTextureStartX, 76);
        widgets.addTexture(backgroundTexture, 0, 0, 54, 54, 29, 18);
        widgets.addTexture(backgroundTexture, 90, 14, 26, 26, 122, 32);
        widgets.addTexture(backgroundTexture, 82, 38, 40, 16, 200, 0);
        for (x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                widgets.addSlot((EmiIngredient)this.input.get(y * 3 + x), x * 18, y * 18).drawBack(false);
            }
        }
        for (x = 0; x < shownGemstoneSlotCount; ++x) {
            widgets.addSlot((EmiIngredient)this.input.get(9 + x), x * 18 + gemstoneSlotStartX, 59).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 90, 14).large(true).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(60, 18, ((PedestalCraftingRecipe)this.recipe).getCraftingTime() * 50);
        widgets.addText(PedestalCraftingEmiRecipeGated.getCraftingTimeText(((PedestalCraftingRecipe)this.recipe).getCraftingTime(), ((PedestalCraftingRecipe)this.recipe).getExperience()), this.width / 2, 80, 0x3F3F3F, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }
}

