/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli;

import de.dafuqs.spectrum.compat.patchouli.PaymentButtonWidget;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.networking.SpectrumC2SPacketSender;
import de.dafuqs.spectrum.sound.HintRevelationSoundInstance;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1113;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;

public class PageHint
extends BookPage {
    IVariable cost;
    IVariable text;
    transient BookTextRenderer textRender;
    transient class_1856 ingredient;
    transient long lastRevealTick;
    transient long revealProgress;
    class_2561 rawText;
    class_2561 displayedText;
    String title;

    public int getTextHeight() {
        return 22;
    }

    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.ingredient = (class_1856)this.cost.as(class_1856.class);
    }

    public boolean isQuestDone(Book book) {
        return PersistentData.data.getBookData((Book)book).completedManualQuests.contains(this.getEntryId());
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.rawText = (class_2561)this.text.as(class_2561.class);
        boolean isDone = this.isQuestDone(parent.book);
        if (!isDone) {
            this.revealProgress = -1L;
            this.displayedText = this.calculateTextToRender(this.rawText);
            PaymentButtonWidget paymentButtonWidget = new PaymentButtonWidget(8, 121, 100, 20, (class_2561)class_2561.method_43473(), this::paymentButtonClicked, this);
            this.addButton(paymentButtonWidget);
        } else {
            this.displayedText = this.rawText;
            this.revealProgress = 0L;
        }
        this.textRender = new BookTextRenderer((GuiBook)parent, this.displayedText, 0, this.getTextHeight());
    }

    private class_2561 calculateTextToRender(class_2561 text) {
        if (this.revealProgress == 0L) {
            return text;
        }
        if (this.revealProgress < 0L) {
            return class_2561.method_43470((String)("$(obf)" + text.getString()));
        }
        class_5250 calculatedText = class_2561.method_43470((String)(text.getString().substring(0, (int)this.revealProgress) + "$(obf)" + text.getString().substring((int)this.revealProgress)));
        long currentTime = class_310.method_1551().field_1687.method_8510();
        if (currentTime != this.lastRevealTick) {
            this.lastRevealTick = currentTime;
            ++this.revealProgress;
            this.revealProgress = Math.min((long)text.getString().length(), this.revealProgress);
            if ((long)text.getString().length() < this.revealProgress) {
                this.revealProgress = 0L;
                return text;
            }
        }
        return calculatedText;
    }

    protected class_2960 getEntryId() {
        return new class_2960(this.entry.getId().method_12836(), this.entry.getId().method_12832() + "_" + this.pageNum);
    }

    @Environment(value=EnvType.CLIENT)
    protected void paymentButtonClicked(class_4185 button) {
        if (this.revealProgress > -1L) {
            return;
        }
        if (class_310.method_1551().field_1724.method_7337() || InventoryHelper.hasInInventory(List.of(this.ingredient), (class_1263)class_310.method_1551().field_1724.method_31548())) {
            PersistentData.BookData data = PersistentData.data.getBookData(this.parent.book);
            data.completedManualQuests.add(this.getEntryId());
            PersistentData.save();
            this.entry.markReadStateDirty();
            class_310.method_1551().method_1483().method_4873((class_1113)new HintRevelationSoundInstance((class_1657)this.mc.field_1724, this.rawText.getString().length()));
            SpectrumC2SPacketSender.sendGuidebookHintBoughtPaket(this.ingredient);
            this.revealProgress = 1L;
            this.lastRevealTick = class_310.method_1551().field_1687.method_8510();
            class_310.method_1551().field_1724.method_17356(class_3417.field_14627, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public void render(class_4587 ms, int mouseX, int mouseY, float pticks) {
        super.render(ms, mouseX, mouseY, pticks);
        if (this.revealProgress >= 0L) {
            this.textRender = new BookTextRenderer((GuiBook)this.parent, this.calculateTextToRender(this.rawText), 0, this.getTextHeight());
        }
        this.textRender.render(ms, mouseX, mouseY);
        if (this.revealProgress == -1L) {
            this.parent.renderIngredient(ms, 81, 122, mouseX, mouseY, this.ingredient);
        }
        this.parent.drawCenteredStringNoShadow(ms, this.title == null || this.title.isEmpty() ? class_1074.method_4662((String)"patchouli.gui.lexicon.objective", (Object[])new Object[0]) : this.i18n(this.title), 58, 0, this.book.headerColor);
        GuiBook.drawSeparator((class_4587)ms, (Book)this.book, (int)0, (int)12);
    }
}

