/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.patchouli.PatchouliHelper;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PagePedestalCrafting
extends PageDoubleRecipeRegistry<PedestalCraftingRecipe> {
    private static final class_2960 BACKGROUND_TEXTURE1 = SpectrumCommon.locate("textures/gui/patchouli/pedestal_crafting1.png");
    private static final class_2960 BACKGROUND_TEXTURE2 = SpectrumCommon.locate("textures/gui/patchouli/pedestal_crafting2.png");
    private static final class_2960 BACKGROUND_TEXTURE3 = SpectrumCommon.locate("textures/gui/patchouli/pedestal_crafting3.png");
    private static final class_2960 BACKGROUND_TEXTURE4 = SpectrumCommon.locate("textures/gui/patchouli/pedestal_crafting4.png");

    public PagePedestalCrafting() {
        super(SpectrumRecipeTypes.PEDESTAL);
    }

    protected class_1799 getRecipeOutput(PedestalCraftingRecipe recipe) {
        if (recipe == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110();
    }

    protected void drawRecipe(class_4587 ms, @NotNull PedestalCraftingRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getBackgroundTextureForTier(recipe.getTier()));
        RenderSystem.enableBlend();
        class_332.method_25290((class_4587)ms, (int)(recipeX - 2), (int)(recipeY - 2), (float)0.0f, (float)0.0f, (int)106, (int)97, (int)128, (int)256);
        this.parent.drawCenteredStringNoShadow(ms, this.getTitle(second).method_30937(), 58, recipeY - 10, this.book.headerColor);
        this.parent.renderItemStack(ms, recipeX + 78, recipeY + 22, mouseX, mouseY, recipe.method_8110());
        switch (recipe.getTier()) {
            case COMPLEX: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 3, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            case ADVANCED: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 12, recipeX, recipeY, mouseX, mouseY);
                break;
            }
            default: {
                this.drawGemstonePowderSlots(recipe, PedestalRecipeTier.getAvailableGemstoneDustColors(recipe.getTier()), ms, 22, recipeX, recipeY, mouseX, mouseY);
            }
        }
        class_2371<IngredientStack> ingredients = recipe.getIngredientStacks();
        int wrap = recipe.getWidth();
        for (int i = 0; i < ingredients.size(); ++i) {
            PatchouliHelper.renderIngredientStack(this.parent, ms, recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, (IngredientStack)ingredients.get(i));
        }
    }

    @Contract(pure=true)
    private class_2960 getBackgroundTextureForTier(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case BASIC: {
                return BACKGROUND_TEXTURE1;
            }
            case SIMPLE: {
                return BACKGROUND_TEXTURE2;
            }
            case ADVANCED: {
                return BACKGROUND_TEXTURE3;
            }
        }
        return BACKGROUND_TEXTURE4;
    }

    protected int getRecipeHeight() {
        return 108;
    }

    private void drawGemstonePowderSlots(PedestalCraftingRecipe recipe, GemstoneColor @NotNull [] colors, class_4587 ms, int startX, int recipeX, int recipeY, int mouseX, int mouseY) {
        int h = 0;
        for (GemstoneColor color : colors) {
            int amount = recipe.getGemstonePowderInputs().getOrDefault(color, 0);
            if (amount > 0) {
                class_1799 stack = color.getGemstonePowderItem().method_7854();
                stack.method_7939(amount);
                this.parent.renderItemStack(ms, recipeX + startX + h * 19, recipeY + 72, mouseX, mouseY, stack);
            }
            ++h;
        }
    }
}

