/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.patchouli.PatchouliHelper;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PageTitrationBarrelFermenting
extends PageDoubleRecipeRegistry<ITitrationBarrelRecipe> {
    private static final class_2960 BACKGROUND_TEXTURE = SpectrumCommon.locate("textures/gui/patchouli/titration_barrel.png");
    private transient BookTextRenderer textRenderer;
    private transient BookTextRenderer textRenderer2;

    public PageTitrationBarrelFermenting() {
        super(SpectrumRecipeTypes.TITRATION_BARREL);
    }

    protected class_1799 getRecipeOutput(ITitrationBarrelRecipe recipe) {
        if (recipe == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110();
    }

    protected void drawRecipe(class_4587 ms, @NotNull ITitrationBarrelRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        RenderSystem.enableBlend();
        class_332.method_25290((class_4587)ms, (int)(recipeX - 2), (int)(recipeY - 2), (float)0.0f, (float)0.0f, (int)100, (int)32, (int)128, (int)256);
        this.parent.drawCenteredStringNoShadow(ms, this.getTitle(second).method_30937(), 58, recipeY - 10, this.book.headerColor);
        class_3611 fluid = recipe.getFluid();
        boolean usesFluid = fluid != class_3612.field_15906;
        IngredientStack bucketStack = IngredientStack.EMPTY;
        if (usesFluid) {
            bucketStack = IngredientStack.of((class_1856)class_1856.method_8101((class_1799[])new class_1799[]{recipe.getFluid().method_15774().method_7854()}));
        }
        List<IngredientStack> ingredients = recipe.getIngredientStacks();
        int ingredientSize = ingredients.size();
        int startX = recipeX + Math.max(-5, 15 - ingredientSize * 10);
        int startY = recipeY + (ingredientSize > 2 ? 0 : 10);
        int ingredientSizeWithFluid = usesFluid ? ingredientSize + 1 : ingredientSize;
        for (int i = 0; i < ingredientSizeWithFluid; ++i) {
            int yOffset;
            int xOffset;
            IngredientStack currentIngredient;
            IngredientStack ingredientStack = currentIngredient = i == ingredientSize ? bucketStack : ingredients.get(i);
            if (i < 3) {
                xOffset = i * 18;
                yOffset = 0;
            } else {
                xOffset = (i - 3) * 18;
                yOffset = 18;
            }
            PatchouliHelper.renderIngredientStack(this.parent, ms, startX + xOffset, startY + yOffset, mouseX, mouseY, currentIngredient);
        }
        if (recipe.getTappingItem() == class_1802.field_8162) {
            this.parent.renderItemStack(ms, recipeX + 54, recipeY + 20, mouseX, mouseY, recipe.method_17447());
        } else {
            this.parent.renderItemStack(ms, recipeX + 54, recipeY + 20, mouseX, mouseY, recipe.getTappingItem().method_7854());
        }
        this.parent.renderItemStack(ms, recipeX + 78, recipeY + 10, mouseX, mouseY, recipe.method_8110());
        if (second) {
            if (this.textRenderer2 == null) {
                class_5250 text = TitrationBarrelRecipe.getDurationText(recipe.getMinFermentationTimeHours(), recipe.getFermentationData());
                this.textRenderer2 = new BookTextRenderer((GuiBook)this.parent, (class_2561)text, 0, recipeY + 40);
            }
            this.textRenderer2.render(ms, mouseX, mouseY);
        } else {
            if (this.textRenderer == null) {
                class_5250 text = TitrationBarrelRecipe.getDurationText(recipe.getMinFermentationTimeHours(), recipe.getFermentationData());
                this.textRenderer = new BookTextRenderer((GuiBook)this.parent, (class_2561)text, 0, recipeY + 40);
            }
            this.textRenderer.render(ms, mouseX, mouseY);
        }
    }

    protected int getRecipeHeight() {
        return 66;
    }
}

