/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4551;
import net.minecraft.class_6005;
import net.minecraft.class_6008;

public class EntityFishingDataLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final String ID = "entity_fishing";
    public static final EntityFishingDataLoader INSTANCE = new EntityFishingDataLoader();
    protected static final List<EntityFishingEntry> ENTITY_FISHING_ENTRIES = new ArrayList<EntityFishingEntry>();

    private EntityFishingDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            class_4551 fluidPredicate = class_4551.method_22474((JsonElement)jsonObject.get("fluid"));
            float chance = class_3518.method_15259((JsonObject)jsonObject, (String)"chance");
            JsonArray entityArray = class_3518.method_15261((JsonObject)jsonObject, (String)"entities");
            AtomicInteger weightSum = new AtomicInteger();
            class_6005.class_6006 entityTypesList = class_6005.method_34971();
            entityArray.forEach(entryElement -> {
                JsonObject entryObject = entryElement.getAsJsonObject();
                class_1299 entityType = (class_1299)class_2378.field_11145.method_10223(new class_2960(class_3518.method_15265((JsonObject)entryObject, (String)"id")));
                int weight = 1;
                if (class_3518.method_34920((JsonObject)jsonObject, (String)"weight")) {
                    weight = class_3518.method_15260((JsonObject)entryObject, (String)"weight");
                }
                weightSum.addAndGet(weight);
                entityTypesList.method_34975((Object)entityType, weight);
            });
            ENTITY_FISHING_ENTRIES.add(new EntityFishingEntry(fluidPredicate, chance, weightSum.get(), (class_6005<class_1299>)entityTypesList.method_34974()));
        });
    }

    public class_2960 getFabricId() {
        return SpectrumCommon.locate(ID);
    }

    public static Optional<class_1299> tryCatchEntity(class_3218 world, class_2338 pos, int bigCatchLevel) {
        for (EntityFishingEntry entry : ENTITY_FISHING_ENTRIES) {
            Optional x;
            if (!entry.fluidPredicate.method_22475(world, pos)) continue;
            if (world.field_9229.method_43057() < entry.entityChance * (float)(1 + bigCatchLevel) && (x = entry.weightedEntityTypes.method_34992(world.field_9229)).isPresent()) {
                return Optional.of((class_1299)((class_6008.class_6010)x.get()).method_34983());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public record EntityFishingEntry(class_4551 fluidPredicate, float entityChance, int weightSum, class_6005<class_1299> weightedEntityTypes) {
    }
}

